/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.UIManager;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFencePluginGeneratingProvider;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkdownLAFListener
implements LafManagerListener {
    MarkdownLAFListener() {
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        if (source == null) {
            MarkdownLAFListener.$$$reportNull$$$0(0);
        }
        UIManager.LookAndFeelInfo newLookAndFeel = source.getCurrentLookAndFeel();
        boolean isNewLookAndFeelDarcula = MarkdownLAFListener.isDarcula(newLookAndFeel);
        MarkdownLAFListener.reinit(isNewLookAndFeelDarcula);
    }

    public static void reinit(boolean isDarcula) {
        MarkdownCodeFencePluginGeneratingProvider.Companion.notifyLAFChanged();
        MarkdownLAFListener.updateCssSettingsForced(isDarcula);
    }

    private static void updateCssSettingsForced(boolean isDarcula) {
        MarkdownCssSettings currentCssSettings = MarkdownApplicationSettings.getInstance().getMarkdownCssSettings();
        String stylesheetUri = StringUtil.isEmpty((String)currentCssSettings.getStylesheetUri()) ? MarkdownCssSettings.getDefaultCssSettings(isDarcula).getStylesheetUri() : currentCssSettings.getStylesheetUri();
        MarkdownApplicationSettings.getInstance().setMarkdownCssSettings(new MarkdownCssSettings(currentCssSettings.isUriEnabled(), stylesheetUri, currentCssSettings.isTextEnabled(), currentCssSettings.getStylesheetText()));
        ((MarkdownApplicationSettings.SettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(MarkdownApplicationSettings.SettingsChangedListener.TOPIC)).settingsChanged(MarkdownApplicationSettings.getInstance());
    }

    public static boolean isDarcula(@Nullable UIManager.LookAndFeelInfo laf) {
        if (laf == null) {
            return false;
        }
        return laf.getName().contains("Darcula");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/intellij/plugins/markdown/settings/MarkdownLAFListener", "lookAndFeelChanged"));
    }
}

