/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.IOUtil;
import com.intellij.vcs.log.util.PersistentUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0012\u0010\u001a\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u0003H\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0014H\u0007R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/util/StorageId;", "", "projectName", "", "subdirName", "logId", "version", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "safeLogId", "safeProjectName", "subdir", "Ljava/io/File;", "getSubdir", "()Ljava/io/File;", "subdir$delegate", "Lkotlin/Lazy;", "getVersion", "()I", "cleanupAllStorageFiles", "", "cleanupStorageFiles", "", "kind", "forMapIndexStorage", "getFile", "getFileForMapIndexStorage", "getStorageFile", "Ljava/nio/file/Path;", "intellij.platform.vcs.log.impl"})
public final class StorageId {
    private final String safeLogId;
    private final String safeProjectName;
    @NotNull
    private final Lazy subdir$delegate;
    private final String projectName;
    private final String subdirName;
    private final String logId;
    private final int version;

    @NotNull
    public final File getSubdir() {
        Lazy lazy = this.subdir$delegate;
        StorageId storageId = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Path getStorageFile(@NotNull String kind, boolean forMapIndexStorage) {
        File storageFile;
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        File file = storageFile = forMapIndexStorage ? this.getFileForMapIndexStorage(kind) : this.getFile(kind);
        if (!storageFile.exists()) {
            int n = 0;
            int n2 = this.version;
            while (n < n2) {
                void oldVersion;
                new StorageId(this.projectName, this.subdirName, this.logId, (int)oldVersion).cleanupStorageFiles(kind, forMapIndexStorage);
                ++oldVersion;
            }
            IOUtil.deleteAllFilesStartingWith((File)new File(new File(PersistentUtil.LOG_CACHE, this.subdirName), this.safeLogId + '.'));
        }
        Path path2 = this.getFile(kind).toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"getFile(kind).toPath()");
        return path2;
    }

    public static /* synthetic */ Path getStorageFile$default(StorageId storageId, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return storageId.getStorageFile(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final Path getStorageFile(@NotNull String kind) {
        return StorageId.getStorageFile$default(this, kind, false, 2, null);
    }

    private final void cleanupStorageFiles(String kind, boolean forMapIndexStorage) {
        File oldStorageFile = forMapIndexStorage ? this.getFileForMapIndexStorage(kind) : this.getFile(kind);
        IOUtil.deleteAllFilesStartingWith((File)oldStorageFile);
    }

    public final boolean cleanupAllStorageFiles() {
        return FileUtil.deleteWithRenaming((File)this.getSubdir());
    }

    private final File getFile(String kind) {
        return new File(this.getSubdir(), kind + '.' + this.version);
    }

    private final File getFileForMapIndexStorage(String kind) {
        File file = MapIndexStorage.getIndexStorageFile((Path)this.getFile(kind).toPath()).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"MapIndexStorage.getIndex\u2026(kind).toPath()).toFile()");
        return file;
    }

    static /* synthetic */ File getFileForMapIndexStorage$default(StorageId storageId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return storageId.getFileForMapIndexStorage(string);
    }

    public final int getVersion() {
        return this.version;
    }

    public StorageId(@NotNull String projectName, @NotNull String subdirName, @NotNull String logId, int version) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)subdirName, (String)"subdirName");
        Intrinsics.checkParameterIsNotNull((Object)logId, (String)"logId");
        this.projectName = projectName;
        this.subdirName = subdirName;
        this.logId = logId;
        this.version = version;
        String string = PathUtilRt.suggestFileName((String)this.logId, (boolean)true, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.suggestFileName(logId, true, true)");
        this.safeLogId = string;
        String string2 = PathUtilRt.suggestFileName((String)(StringsKt.take((String)this.projectName, (int)7) + '.' + this.logId), (boolean)false, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.suggestFileNa\u2026)}.$logId\", false, false)");
        this.safeProjectName = string2;
        this.subdir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ StorageId this$0;

            @NotNull
            public final File invoke() {
                return new File(new File(PersistentUtil.LOG_CACHE, StorageId.access$getSubdirName$p(this.this$0)), StorageId.access$getSafeProjectName$p(this.this$0));
            }
            {
                this.this$0 = storageId;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ String access$getSubdirName$p(StorageId $this) {
        return $this.subdirName;
    }

    public static final /* synthetic */ String access$getSafeProjectName$p(StorageId $this) {
        return $this.safeProjectName;
    }
}

