/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsFreezingProcess;
import com.intellij.openapi.vcs.changes.VcsShelveChangesSaver;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class DefaultPreservingExecutorImpl {
    private static final Logger LOG = Logger.getInstance(DefaultPreservingExecutorImpl.class);
    private final Project myProject;
    private final Collection<? extends VirtualFile> myRootsToSave;
    private final String myOperationTitle;
    private final Runnable myOperation;
    private final VcsShelveChangesSaver mySaver;

    DefaultPreservingExecutorImpl(@NotNull Project project, @NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull String operationTitle, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        if (project == null) {
            DefaultPreservingExecutorImpl.$$$reportNull$$$0(0);
        }
        if (rootsToSave == null) {
            DefaultPreservingExecutorImpl.$$$reportNull$$$0(1);
        }
        if (operationTitle == null) {
            DefaultPreservingExecutorImpl.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            DefaultPreservingExecutorImpl.$$$reportNull$$$0(3);
        }
        if (operation == null) {
            DefaultPreservingExecutorImpl.$$$reportNull$$$0(4);
        }
        this.mySaver = new VcsShelveChangesSaver(project, indicator, operationTitle);
        this.myProject = project;
        this.myRootsToSave = rootsToSave;
        this.myOperationTitle = operationTitle;
        this.myOperation = operation;
    }

    public void execute() {
        Runnable operation = () -> {
            LOG.debug("starting");
            boolean savedSuccessfully = this.save();
            LOG.debug("save result: " + savedSuccessfully);
            if (savedSuccessfully) {
                try {
                    LOG.debug("running operation");
                    this.myOperation.run();
                    LOG.debug("operation completed.");
                }
                finally {
                    LOG.debug("loading");
                    ProgressManager.getInstance().executeNonCancelableSection(() -> this.mySaver.load());
                }
            }
            LOG.debug("finished.");
        };
        new VcsFreezingProcess(this.myProject, this.myOperationTitle, operation).execute();
    }

    private boolean save() {
        return (Boolean)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            try {
                this.mySaver.save(this.myRootsToSave);
                return true;
            }
            catch (VcsException e) {
                LOG.info("Couldn't save local changes", (Throwable)e);
                VcsNotifier.getInstance(this.myProject).notifyError(VcsBundle.message((String)"notification.title.couldn.t.save.uncommitted.changes", (Object[])new Object[0]), String.format("Tried to save uncommitted changes in shelve before %s, but failed with an error.<br/>%s", this.myOperationTitle, StringUtil.join((String[])e.getMessages())));
                return false;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rootsToSave";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "operationTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "operation";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/DefaultPreservingExecutorImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

