/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.HashMap;
import java.util.Map;

public class ApplyPatchContext {
    private final VirtualFile myBaseDir;
    private final int mySkipTopDirs;
    private final boolean myCreateDirectories;
    private final boolean myAllowRename;
    private final Map<VirtualFile, FilePath> myPathsBeforeRename = new HashMap<VirtualFile, FilePath>();

    public ApplyPatchContext(VirtualFile baseDir, int skipTopDirs, boolean createDirectories, boolean allowRename) {
        this.myBaseDir = baseDir;
        this.mySkipTopDirs = skipTopDirs;
        this.myCreateDirectories = createDirectories;
        this.myAllowRename = allowRename;
    }

    public VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    public int getSkipTopDirs() {
        return this.mySkipTopDirs;
    }

    public boolean isAllowRename() {
        return this.myAllowRename;
    }

    public boolean isCreateDirectories() {
        return this.myCreateDirectories;
    }

    public ApplyPatchContext getPrepareContext() {
        return new ApplyPatchContext(this.myBaseDir, this.mySkipTopDirs, false, false);
    }

    public void registerBeforeRename(VirtualFile file) {
        FilePath path2 = VcsUtil.getFilePath((VirtualFile)file);
        this.myPathsBeforeRename.put(file, path2);
    }

    public FilePath getPathBeforeRename(VirtualFile file) {
        FilePath path2 = this.myPathsBeforeRename.get(file);
        if (path2 != null) {
            return path2;
        }
        return VcsUtil.getFilePath((VirtualFile)file);
    }
}

