/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsStatisticsCollectorKt;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointsUsageCollector;", "", "()V", "Companion", "intellij.platform.debugger.impl"})
public final class BreakpointsUsageCollector {
    @NotNull
    public static final String GROUP = "debugger.breakpoints.usage";
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void reportNewBreakpoint(@NotNull XBreakpoint<?> breakpoint, @NotNull XBreakpointType<?, ?> type, boolean withinSession) {
        Companion.reportNewBreakpoint(breakpoint, type, withinSession);
    }

    @JvmStatic
    public static final void reportBreakpointVerified(@NotNull XBreakpoint<?> breakpoint, long time) {
        Companion.reportBreakpointVerified(breakpoint, time);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0007J,\u0010\u000b\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointsUsageCollector$Companion;", "", "()V", "GROUP", "", "reportBreakpointVerified", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "time", "", "reportNewBreakpoint", "type", "Lcom/intellij/xdebugger/breakpoints/XBreakpointType;", "withinSession", "", "intellij.platform.debugger.impl"})
    public static final class Companion {
        @JvmStatic
        public final void reportNewBreakpoint(@NotNull XBreakpoint<?> breakpoint, @NotNull XBreakpointType<?, ?> type, boolean withinSession) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            if (breakpoint instanceof XBreakpointBase) {
                FeatureUsageData data2 = new FeatureUsageData();
                BreakpointsStatisticsCollectorKt.addType(type, data2);
                data2.addData("within_session", withinSession);
                FUCounterUsageLogger.getInstance().logEvent(((XBreakpointBase)breakpoint).getProject(), BreakpointsUsageCollector.GROUP, "breakpoint.added", data2);
            }
        }

        @JvmStatic
        public final void reportBreakpointVerified(@NotNull XBreakpoint<?> breakpoint, long time) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            if (breakpoint instanceof XBreakpointBase) {
                FUCounterUsageLogger.getInstance().logEvent(((XBreakpointBase)breakpoint).getProject(), BreakpointsUsageCollector.GROUP, "breakpoint.verified", new FeatureUsageData().addData("time", time));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

