/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.IntObjectLinkedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntSLRUCache<T> {
    private static final boolean ourPrintDebugStatistics = false;
    private final IntObjectLinkedMap<T> myProtectedQueue;
    private final IntObjectLinkedMap<T> myProbationalQueue;
    private int probationalHits;
    private int protectedHits;
    private int misses;

    public IntSLRUCache(int protectedQueueSize, int probationalQueueSize) {
        this.myProtectedQueue = new IntObjectLinkedMap(protectedQueueSize);
        this.myProbationalQueue = new IntObjectLinkedMap(probationalQueueSize);
    }

    @NotNull
    public IntObjectLinkedMap.MapEntry<T> cacheEntry(int key, T value2) {
        IntObjectLinkedMap.MapEntry<T> cached = this.myProtectedQueue.getEntry(key);
        if (cached == null) {
            cached = this.myProbationalQueue.getEntry(key);
        }
        if (cached != null) {
            IntObjectLinkedMap.MapEntry<T> mapEntry = cached;
            if (mapEntry == null) {
                IntSLRUCache.$$$reportNull$$$0(0);
            }
            return mapEntry;
        }
        IntObjectLinkedMap.MapEntry<T> entry = new IntObjectLinkedMap.MapEntry<T>(key, value2);
        this.myProbationalQueue.putEntry(entry);
        IntObjectLinkedMap.MapEntry<T> mapEntry = entry;
        if (mapEntry == null) {
            IntSLRUCache.$$$reportNull$$$0(1);
        }
        return mapEntry;
    }

    @Nullable
    public IntObjectLinkedMap.MapEntry<T> getCachedEntry(int id2) {
        return this.getCachedEntry(id2, true);
    }

    @Nullable
    public IntObjectLinkedMap.MapEntry<T> getCachedEntry(int id2, boolean allowMutation) {
        IntObjectLinkedMap.MapEntry<T> entry = this.myProtectedQueue.getEntry(id2);
        if (entry != null) {
            ++this.protectedHits;
            return entry;
        }
        entry = this.myProbationalQueue.getEntry(id2);
        if (entry != null) {
            this.printStatistics(++this.probationalHits);
            if (allowMutation) {
                this.myProbationalQueue.removeEntry(entry.key);
                IntObjectLinkedMap.MapEntry<T> demoted = this.myProtectedQueue.putEntry(entry);
                if (demoted != null) {
                    this.myProbationalQueue.putEntry(demoted);
                }
            }
            return entry;
        }
        this.printStatistics(++this.misses);
        return null;
    }

    private void printStatistics(int hits) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IntSLRUCache", "cacheEntry"));
    }
}

