/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.util.Alarm;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

public class DetailController {
    private final MasterController myMasterController;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private DetailView myDetailView;
    private ItemWrapper mySelectedItem;

    public DetailController(MasterController masterController) {
        this.myMasterController = masterController;
    }

    public void setDetailView(@NotNull DetailView detailView) {
        if (detailView == null) {
            DetailController.$$$reportNull$$$0(0);
        }
        this.myDetailView = detailView;
    }

    protected void doUpdateDetailViewWithItem(ItemWrapper wrapper2) {
        if (wrapper2 != null) {
            wrapper2.updateDetailView(this.myDetailView);
        } else {
            this.myDetailView.clearEditor();
            this.myDetailView.setPropertiesPanel(null);
            this.myDetailView.setCurrentItem(null);
        }
    }

    private String getTitle2Text(String fullText) {
        int labelWidth = this.getLabel().getWidth();
        if (fullText == null || fullText.length() == 0) {
            return " ";
        }
        while (this.getLabel().getFontMetrics(this.getLabel().getFont()).stringWidth(fullText) > labelWidth) {
            int sep = fullText.indexOf(File.separatorChar, 4);
            if (sep < 0) {
                return fullText;
            }
            fullText = "..." + fullText.substring(sep);
        }
        return fullText;
    }

    private JLabel getLabel() {
        return this.myMasterController.getPathLabel();
    }

    public ItemWrapper getSelectedItem() {
        return this.mySelectedItem;
    }

    public void doUpdateDetailView(boolean now) {
        ItemWrapper[] values2 = this.myMasterController.getSelectedItems();
        ItemWrapper wrapper2 = null;
        if (values2 != null && values2.length == 1) {
            wrapper2 = values2[0];
            this.getLabel().setText(this.getTitle2Text(wrapper2.footerText()));
        } else {
            this.getLabel().setText(" ");
        }
        this.mySelectedItem = wrapper2;
        this.myUpdateAlarm.cancelAllRequests();
        if (now) {
            this.doUpdateDetailViewWithItem(this.mySelectedItem);
        } else {
            this.myUpdateAlarm.addRequest(() -> {
                this.doUpdateDetailViewWithItem(this.mySelectedItem);
                this.myUpdateAlarm.cancelAllRequests();
            }, 100);
        }
    }

    public void updateDetailView() {
        this.doUpdateDetailView(false);
    }

    public void setList(JBList list2) {
        ListSelectionModel listSelectionModel = list2.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        if (list2.getModel().getSize() == 0) {
            list2.clearSelection();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailView", "com/intellij/ui/popup/util/DetailController", "setDetailView"));
    }
}

