/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.util.ArrayDeque;
import java.util.Collection;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StackTouchBars {
    private final ArrayDeque<BarContainer> myContainersStack = new ArrayDeque();
    private final TouchBarHolder myTouchBarHolder = new TouchBarHolder();
    private long myCurrentKeyMask;

    StackTouchBars() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateKeyMask(long newMask) {
        if (this.myCurrentKeyMask != newMask) {
            StackTouchBars stackTouchBars = this;
            synchronized (stackTouchBars) {
                this.myCurrentKeyMask = newMask;
                this._setTouchBarFromTopContainer();
            }
        }
    }

    @Nullable
    synchronized TouchBar getTopTouchBar() {
        BarContainer topContainer = this.myContainersStack.peek();
        return topContainer == null ? null : topContainer.get();
    }

    synchronized void pop(@Nullable Condition<? super BarContainer> condition) {
        BarContainer top = this.myContainersStack.peek();
        if (top == null) {
            return;
        }
        if (condition != null && !condition.value((Object)top)) {
            return;
        }
        this.myContainersStack.pop();
        this._setTouchBarFromTopContainer();
    }

    synchronized void removeAll(@NotNull Collection<BarContainer> toErase) {
        if (toErase == null) {
            StackTouchBars.$$$reportNull$$$0(0);
        }
        this.myContainersStack.removeAll(toErase);
        this._setTouchBarFromTopContainer();
    }

    synchronized void setTouchBarFromTopContainer() {
        this._setTouchBarFromTopContainer();
    }

    synchronized void showContainer(BarContainer bar) {
        if (bar == null) {
            return;
        }
        BarContainer top = this.myContainersStack.peek();
        if (top == bar) {
            return;
        }
        this.myContainersStack.remove(bar);
        this.myContainersStack.push(bar);
        this._setTouchBarFromTopContainer();
    }

    synchronized void removeContainer(BarContainer tb) {
        if (tb == null || this.myContainersStack.isEmpty()) {
            return;
        }
        tb.onHide();
        BarContainer top = this.myContainersStack.peek();
        if (top == tb) {
            this.myContainersStack.pop();
            this._setTouchBarFromTopContainer();
        } else {
            this.myContainersStack.remove(tb);
        }
    }

    private void _setTouchBarFromTopContainer() {
        if (this.myContainersStack.isEmpty()) {
            this.myTouchBarHolder.setTouchBar(null);
            return;
        }
        BarContainer top = this.myContainersStack.peek();
        top.selectBarByKeyMask(this.myCurrentKeyMask);
        TouchBar tb = top.get();
        if (tb != null && tb.isEmpty()) {
            this.myTouchBarHolder.setTouchBar(null);
            return;
        }
        this.myTouchBarHolder.setTouchBar(tb);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toErase", "com/intellij/ui/mac/touchbar/StackTouchBars", "removeAll"));
    }

    private static class TouchBarHolder {
        private TouchBar myCurrentBar;
        private TouchBar myNextBar;

        private TouchBarHolder() {
        }

        synchronized void setTouchBar(TouchBar bar) {
            @NotNull Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                return;
            }
            this.myNextBar = bar;
            Timer timer2 = new Timer(100, event -> this._setNextTouchBar());
            timer2.setRepeats(false);
            timer2.start();
        }

        private synchronized void _setNextTouchBar() {
            if (this.myCurrentBar == this.myNextBar) {
                return;
            }
            if (this.myCurrentBar != null) {
                this.myCurrentBar.onHide();
            }
            this.myCurrentBar = this.myNextBar;
            if (this.myCurrentBar != null) {
                this.myCurrentBar.onBeforeShow();
            }
            NST.setTouchBar(this.myCurrentBar);
        }
    }
}

