/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodDecorator;
import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.SimpleParameterTablePanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractExtractMethodDialog<T>
extends DialogWrapper
implements ExtractMethodSettings<T> {
    private JPanel myContentPane;
    private SimpleParameterTablePanel myParametersPanel;
    private JTextField myMethodNameTextField;
    private MethodSignatureComponent mySignaturePreviewTextArea;
    private JTextArea myOutputVariablesTextArea;
    private final ComboBoxVisibilityPanel<T> myVisibilityComboBox;
    private final Project myProject;
    private final String myDefaultName;
    private final ExtractMethodValidator myValidator;
    private final ExtractMethodDecorator<T> myDecorator;
    private AbstractVariableData[] myVariableData;
    private Map<String, AbstractVariableData> myVariablesMap;
    private final List<String> myArguments;
    private final ArrayList<String> myOutputVariables;
    private final FileType myFileType;

    public AbstractExtractMethodDialog(Project project, String defaultName, CodeFragment fragment, T[] visibilityVariants, ExtractMethodValidator validator, ExtractMethodDecorator<T> decorator, FileType type) {
        super(project, true);
        this.myProject = project;
        this.myDefaultName = defaultName;
        this.myValidator = validator;
        this.myDecorator = decorator;
        this.myFileType = type;
        this.myVisibilityComboBox = new ComboBoxVisibilityPanel<T>(visibilityVariants);
        this.myVisibilityComboBox.setVisible(visibilityVariants.length > 1);
        this.getRememberedVisibility(visibilityVariants).ifPresent(this.myVisibilityComboBox::setVisibility);
        this.myVisibilityComboBox.addListener(event -> this.rememberCurrentVisibility());
        this.$$$setupUI$$$();
        this.myArguments = new ArrayList<String>(fragment.getInputVariables());
        Collections.sort(this.myArguments);
        this.myOutputVariables = new ArrayList(fragment.getOutputVariables());
        Collections.sort(this.myOutputVariables);
        this.setModal(true);
        this.setTitle(RefactoringBundle.message((String)"extract.method.title"));
        this.init();
    }

    protected void init() {
        super.init();
        this.myMethodNameTextField.setText(this.myDefaultName);
        this.myMethodNameTextField.setSelectionStart(0);
        this.myMethodNameTextField.setSelectionStart(this.myDefaultName.length());
        this.myMethodNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractExtractMethodDialog.this.updateOutputVariables();
                AbstractExtractMethodDialog.this.updateSignature();
                AbstractExtractMethodDialog.this.updateOkStatus();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/extractMethod/AbstractExtractMethodDialog$1", "textChanged"));
            }
        });
        this.myVariableData = AbstractExtractMethodDialog.createVariableDataByNames(this.myArguments);
        this.myVariablesMap = AbstractExtractMethodDialog.createVariableMap(this.myVariableData);
        this.myParametersPanel.init(this.myVariableData);
        this.updateOutputVariables();
        this.updateSignature();
        this.updateOkStatus();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMethodNameTextField;
    }

    public static AbstractVariableData[] createVariableDataByNames(List<String> args) {
        AbstractVariableData[] datas = new AbstractVariableData[args.size()];
        for (int i2 = 0; i2 < args.size(); ++i2) {
            String name;
            AbstractVariableData data2 = new AbstractVariableData();
            data2.originalName = name = args.get(i2);
            data2.name = name;
            data2.passAsParameter = true;
            datas[i2] = data2;
        }
        return datas;
    }

    public static Map<String, AbstractVariableData> createVariableMap(AbstractVariableData[] data2) {
        HashMap<String, AbstractVariableData> map2 = new HashMap<String, AbstractVariableData>();
        for (AbstractVariableData variableData : data2) {
            map2.put(variableData.getOriginalName(), variableData);
        }
        return map2;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            AbstractExtractMethodDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected void doOKAction() {
        String error = this.myValidator.check(this.getMethodName());
        if (error != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showInfoMessage((String)error, (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            if (Messages.showOkCancelDialog((String)(error + ". " + RefactoringBundle.message((String)"do.you.wish.to.continue")), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        super.doOKAction();
    }

    protected String getHelpId() {
        return "refactoring.extractMethod";
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.myParametersPanel = new SimpleParameterTablePanel(this.myValidator::isValidName){

            @Override
            protected void doCancelAction() {
                AbstractExtractMethodDialog.this.doCancelAction();
            }

            @Override
            protected void doEnterAction() {
                AbstractExtractMethodDialog.this.doOKAction();
            }

            @Override
            protected void updateSignature() {
                AbstractExtractMethodDialog.this.updateOutputVariables();
                AbstractExtractMethodDialog.this.updateSignature();
            }
        };
        this.mySignaturePreviewTextArea = new MethodSignatureComponent("", this.myProject, this.myFileType);
    }

    @NotNull
    private String getPersistenceId() {
        String string = "visibility.combobox." + this.getClass().getName();
        if (string == null) {
            AbstractExtractMethodDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void rememberCurrentVisibility() {
        PropertiesComponent.getInstance().setValue(this.getPersistenceId(), (String)Optional.ofNullable(this.getVisibility()).map(Object::toString).orElse(null));
    }

    private Optional<T> getRememberedVisibility(T[] visibilityVariants) {
        String stringValue = PropertiesComponent.getInstance().getValue(this.getPersistenceId());
        return Stream.of(visibilityVariants).filter(visibility -> visibility.toString().equals(stringValue)).findAny();
    }

    private void updateOutputVariables() {
        StringBuilder builder2 = new StringBuilder();
        boolean first = true;
        for (String variable : this.myOutputVariables) {
            String outputName;
            if (this.myVariablesMap == null) continue;
            AbstractVariableData data2 = this.myVariablesMap.get(variable);
            String string = outputName = data2 != null ? data2.getName() : variable;
            if (first) {
                first = false;
            } else {
                builder2.append(", ");
            }
            builder2.append(outputName);
        }
        this.myOutputVariablesTextArea.setText(builder2.length() > 0 ? builder2.toString() : RefactoringBundle.message((String)"refactoring.extract.method.dialog.empty"));
    }

    private void updateSignature() {
        this.mySignaturePreviewTextArea.setSignature(this.myDecorator.createMethodSignature(this));
    }

    private void updateOkStatus() {
        this.setOKActionEnabled(this.myValidator.isValidName(this.getMethodName()));
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.myMethodNameTextField.getText().trim();
        if (string == null) {
            AbstractExtractMethodDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public AbstractVariableData @NotNull [] getAbstractVariableData() {
        if (this.myVariableData == null) {
            AbstractExtractMethodDialog.$$$reportNull$$$0(3);
        }
        return this.myVariableData;
    }

    @Override
    @Nullable
    public T getVisibility() {
        return this.myVisibilityComboBox.getVisibility();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JTextField jTextField;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        this.myMethodNameTextField = jTextField = new JTextField();
        jTextField.setColumns(10);
        jTextField.setHorizontalAlignment(2);
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RefactoringBundle", AbstractExtractMethodDialog.class).getString("refactoring.extract.method.dialog.method.name"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBoxVisibilityPanel<T> comboBoxVisibilityPanel = this.myVisibilityComboBox;
        jPanel3.add(comboBoxVisibilityPanel, new GridConstraints(0, 0, 2, 1, 0, 1, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/RefactoringBundle", AbstractExtractMethodDialog.class).getString("refactoring.extract.method.dialog.parameters"), (int)0, (int)0, null, null));
        SimpleParameterTablePanel simpleParameterTablePanel = this.myParametersPanel;
        jPanel4.add((Component)simpleParameterTablePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        MethodSignatureComponent methodSignatureComponent = this.mySignaturePreviewTextArea;
        jBScrollPane.setViewportView((Component)((Object)methodSignatureComponent));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, new GridConstraints(5, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        this.myOutputVariablesTextArea = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jBScrollPane2.setViewportView(jTextArea);
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/RefactoringBundle", AbstractExtractMethodDialog.class).getString("refactoring.extract.method.dialog.signature.preview"));
        titledSeparator.putClientProperty((Object)"BorderFactoryClass", (Object)"");
        jPanel2.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText(DynamicBundle.getBundle((String)"messages/RefactoringBundle", AbstractExtractMethodDialog.class).getString("refactoring.extract.method.dialog.output.variables"));
        titledSeparator2.putClientProperty((Object)"BorderFactoryClass", (Object)"");
        jPanel2.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 1, 2, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/extractMethod/AbstractExtractMethodDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbstractVariableData";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

