/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.HashMap;

public class MemberInfoTooltipManager<T extends PsiElement, M extends MemberInfoBase<T>> {
    private final HashMap<M, String> myTooltips = new HashMap();
    private final TooltipProvider<T, M> myProvider;

    public MemberInfoTooltipManager(TooltipProvider<T, M> provider) {
        this.myProvider = provider;
    }

    public void invalidate() {
        this.myTooltips.clear();
    }

    public String getTooltip(M member) {
        if (this.myTooltips.containsKey(member)) {
            return this.myTooltips.get(member);
        }
        String tooltip = this.myProvider.getTooltip(member);
        this.myTooltips.put(member, tooltip);
        return tooltip;
    }

    public static interface TooltipProvider<T extends PsiElement, M extends MemberInfoBase<T>> {
        public String getTooltip(M var1);
    }
}

