/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.index.PrebuiltIndexProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.CompositeBinaryBuilderMap;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.PrebuiltStubsKt;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializedStubTreeDataExternalizer;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBuilderType;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingForwardIndexAccessor;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexDataComparer;
import com.intellij.util.indexing.IndexDataPresenter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SingleEntryCompositeIndexer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntMapForwardIndex;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubUpdatingIndex
extends SingleEntryFileBasedIndexExtension<SerializedStubTree>
implements CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree> {
    static final Logger LOG = Logger.getInstance(StubUpdatingIndex.class);
    public static final boolean USE_SNAPSHOT_MAPPINGS = SystemProperties.is((String)"stubs.use.snapshot.mappings");
    private static final int VERSION = 45 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 3, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final FileBasedIndex.InputFilter INPUT_FILTER = StubUpdatingIndex::canHaveStub;
    @NotNull
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    @NotNull
    private final SerializationManagerEx mySerializationManager;
    private static final byte IS_BINARY_MASK = 1;
    private static final byte BYTE_AND_CHAR_LENGTHS_ARE_THE_SAME_MASK = 2;

    public StubUpdatingIndex() {
        this(StubForwardIndexExternalizer.getIdeUsedExternalizer(), SerializationManagerEx.getInstanceEx());
    }

    public StubUpdatingIndex(@NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull SerializationManagerEx serializationManager) {
        if (stubIndexesExternalizer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(0);
        }
        if (serializationManager == null) {
            StubUpdatingIndex.$$$reportNull$$$0(1);
        }
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    public boolean hasSnapshotMapping() {
        return USE_SNAPSHOT_MAPPINGS;
    }

    public static boolean canHaveStub(@NotNull VirtualFile file2) {
        BinaryFileStubBuilder builder2;
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(2);
        }
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)file2);
        FileType fileType = SubstitutedFileType.substituteFileType(file2, file2.getFileType(), project);
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file2)) {
                return true;
            }
        }
        return (builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder2.acceptsFile(file2);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        ID<Integer, SerializedStubTree> iD = INDEX_ID;
        if (iD == null) {
            StubUpdatingIndex.$$$reportNull$$$0(3);
        }
        return iD;
    }

    @NotNull
    public SingleEntryIndexer<SerializedStubTree> getIndexer() {
        return new SingleEntryCompositeIndexer<SerializedStubTree, StubBuilderType, String>(false){

            public boolean requiresContentForSubIndexerEvaluation(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return StubTreeBuilder.requiresContentToFindBuilder(file2.getFileType());
            }

            @Nullable
            public StubBuilderType calculateSubIndexer(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return StubTreeBuilder.getStubBuilderType(file2, true);
            }

            @NotNull
            public String getSubIndexerVersion(@NotNull StubBuilderType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                String string = type.getVersion();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
                if (enumeratorStringDescriptor == null) {
                    1.$$$reportNull$$$0(4);
                }
                return enumeratorStringDescriptor;
            }

            @Nullable
            protected SerializedStubTree computeValue(@NotNull FileContent inputData, @NotNull StubBuilderType type) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(6);
                }
                try {
                    SerializedStubTree prebuiltTree = StubUpdatingIndex.findPrebuiltSerializedStubTree(inputData);
                    if (prebuiltTree != null) {
                        prebuiltTree = prebuiltTree.reSerialize(StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                        if (PrebuiltIndexProvider.DEBUG_PREBUILT_INDICES) {
                            StubUpdatingIndex.this.assertPrebuiltStubTreeMatchesActualTree(prebuiltTree, inputData, type);
                        }
                        return prebuiltTree;
                    }
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Exception e) {
                    LOG.error("Error while indexing: " + inputData.getFileName() + " using prebuilt stub index", (Throwable)e);
                }
                try {
                    Stub stub = StubTreeBuilder.buildStubTree(inputData, type);
                    if (stub == null) {
                        return null;
                    }
                    SerializedStubTree serializedStubTree = SerializedStubTree.serializeStub(stub, StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                    if (IndexDebugProperties.DEBUG) {
                        StubUpdatingIndex.assertDeserializedStubMatchesOriginalStub(serializedStubTree, stub);
                    }
                    return serializedStubTree;
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    LOG.error("Error indexing:" + inputData.getFile(), t);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersionDescriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "requiresContentForSubIndexerEvaluation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "computeValue";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    static SerializedStubTree findPrebuiltSerializedStubTree(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            StubUpdatingIndex.$$$reportNull$$$0(4);
        }
        if (!PrebuiltIndexProvider.USE_PREBUILT_INDEX) {
            return null;
        }
        PrebuiltStubsProvider prebuiltStubsProvider = (PrebuiltStubsProvider)PrebuiltStubsKt.getPrebuiltStubsProvider().forFileType(fileContent.getFileType());
        if (prebuiltStubsProvider == null) {
            return null;
        }
        return prebuiltStubsProvider.findStub(fileContent);
    }

    private static void assertDeserializedStubMatchesOriginalStub(@NotNull SerializedStubTree stubTree, @NotNull Stub originalStub) {
        Stub deserializedStub;
        if (stubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(5);
        }
        if (originalStub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(6);
        }
        try {
            deserializedStub = stubTree.getStub();
        }
        catch (SerializerNotFoundException e) {
            throw new RuntimeException("Failed to deserialize stub tree", e);
        }
        StubUpdatingIndex.assertStubsAreSimilar(originalStub, deserializedStub);
    }

    private static void assertStubsAreSimilar(@NotNull Stub stub, @NotNull Stub stub2) {
        if (stub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(7);
        }
        if (stub2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(8);
        }
        assert (stub.getStubType() == stub2.getStubType());
        List stubs = stub.getChildrenStubs();
        List stubs2 = stub2.getChildrenStubs();
        assert (stubs.size() == stubs2.size());
        int len = stubs.size();
        for (int i2 = 0; i2 < len; ++i2) {
            StubUpdatingIndex.assertStubsAreSimilar((Stub)stubs.get(i2), (Stub)stubs2.get(i2));
        }
    }

    private void assertPrebuiltStubTreeMatchesActualTree(@NotNull SerializedStubTree prebuiltStubTree, @NotNull FileContent fileContent, @NotNull StubBuilderType type) {
        if (prebuiltStubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(9);
        }
        if (fileContent == null) {
            StubUpdatingIndex.$$$reportNull$$$0(10);
        }
        if (type == null) {
            StubUpdatingIndex.$$$reportNull$$$0(11);
        }
        try {
            Stub stub = StubTreeBuilder.buildStubTree(fileContent, type);
            if (stub == null) {
                return;
            }
            SerializedStubTree actualTree = SerializedStubTree.serializeStub(stub, this.mySerializationManager, this.myStubIndexesExternalizer);
            if (!IndexDataComparer.INSTANCE.areStubTreesTheSame(actualTree, prebuiltStubTree)) {
                throw new RuntimeExceptionWithAttachments("Prebuilt stub tree does not match actual stub tree", new Attachment[]{new Attachment("actual-stub-tree.txt", IndexDataPresenter.INSTANCE.getPresentableSerializedStubTree(actualTree)), new Attachment("prebuilt-stub-tree.txt", IndexDataPresenter.INSTANCE.getPresentableSerializedStubTree(prebuiltStubTree))});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void rememberIndexingStamp(@NotNull FileContent content2) {
        VirtualFile file2;
        boolean isBinary;
        if (content2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(12);
        }
        int contentLength = (isBinary = (file2 = content2.getFile()).getFileType().isBinary()) ? -1 : content2.getPsiFile().getTextLength();
        long byteLength = file2.getLength();
        StubUpdatingIndex.rememberIndexingStamp(file2, isBinary, byteLength, contentLength);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Indexing stubs for " + file2 + "; " + IndexingStampInfo.dumpSize(byteLength, contentLength));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void rememberIndexingStamp(@NotNull VirtualFile file2, boolean isBinary, long contentByteLength, int n) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(13);
        }
        try (DataOutputStream stream = INDEXED_STAMP.writeAttribute(file2);){
            void contentCharLength;
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)file2.getTimeStamp());
            DataInputOutputUtil.writeLONG((DataOutput)stream, (long)contentByteLength);
            boolean lengthsAreTheSame = contentByteLength == (long)contentCharLength;
            byte flags = 0;
            flags = BitUtil.set((byte)flags, (byte)1, (boolean)isBinary);
            flags = BitUtil.set((byte)flags, (byte)2, (boolean)lengthsAreTheSame);
            stream.writeByte(flags);
            if (!lengthsAreTheSame && !isBinary) {
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)contentCharLength);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(14);
        }
        try (DataInputStream stream = INDEXED_STAMP.readAttribute(file2);){
            if (stream == null) {
                IndexingStampInfo indexingStampInfo2 = null;
                return indexingStampInfo2;
            }
            long stamp = DataInputOutputUtil.readTIME((DataInput)stream);
            long byteLength = DataInputOutputUtil.readLONG((DataInput)stream);
            byte flags = stream.readByte();
            boolean isBinary = BitUtil.isSet((byte)flags, (byte)1);
            boolean readOnlyOneLength = BitUtil.isSet((byte)flags, (byte)2);
            int charLength = isBinary ? -1 : (readOnlyOneLength ? (int)byteLength : DataInputOutputUtil.readINT((DataInput)stream));
            IndexingStampInfo indexingStampInfo = new IndexingStampInfo(stamp, byteLength, charLength);
            return indexingStampInfo;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        StubUpdatingIndex.ensureSerializationManagerInitialized(this.mySerializationManager);
        return new SerializedStubTreeDataExternalizer(true, this.mySerializationManager, this.myStubIndexesExternalizer);
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
        if (inputFilter == null) {
            StubUpdatingIndex.$$$reportNull$$$0(15);
        }
        return inputFilter;
    }

    public int getVersion() {
        return VERSION;
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage) throws StorageException, IOException {
        if (extension == null) {
            StubUpdatingIndex.$$$reportNull$$$0(16);
        }
        if (storage == null) {
            StubUpdatingIndex.$$$reportNull$$$0(17);
        }
        ((StubIndexImpl)StubIndex.getInstance()).initializeStubIndexes();
        if (storage instanceof TransientChangesIndexStorage) {
            TransientChangesIndexStorage memStorage = (TransientChangesIndexStorage)storage;
            memStorage.addBufferingStateListener(new TransientChangesIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState2) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState2);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        this.checkNameStorage();
        boolean hasSnapshotMapping = VfsAwareMapReduceIndex.hasSnapshotMapping(this);
        StubUpdatingForwardIndexAccessor stubForwardIndexAccessor = new StubUpdatingForwardIndexAccessor(extension);
        SnapshotInputMappings<Integer, SerializedStubTree> snapshotInputMappings = hasSnapshotMapping ? new SnapshotInputMappings<Integer, SerializedStubTree>((IndexExtension<Integer, SerializedStubTree, FileContent>)this, stubForwardIndexAccessor) : null;
        IntMapForwardIndex forwardIndex = hasSnapshotMapping ? new IntMapForwardIndex(snapshotInputMappings.getInputIndexStorageFile(), true) : new EmptyForwardIndex();
        AbstractMapForwardIndexAccessor accessor = hasSnapshotMapping ? snapshotInputMappings.getForwardIndexAccessor() : stubForwardIndexAccessor;
        return new MyIndex(extension, storage, (ForwardIndex)forwardIndex, (ForwardIndexAccessor<Integer, SerializedStubTree>)accessor, snapshotInputMappings);
    }

    private void checkNameStorage() throws StorageException {
        if (this.mySerializationManager.isNameStorageCorrupted()) {
            this.mySerializationManager.repairNameStorage();
            throw new StorageException("NameStorage for stubs serialization has been corrupted");
        }
    }

    private static void ensureSerializationManagerInitialized(@NotNull SerializationManagerEx serializationManager) {
        if (serializationManager == null) {
            StubUpdatingIndex.$$$reportNull$$$0(18);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            StubUpdatingIndex.instantiateElementTypesFromFields();
            StubIndexEx.initExtensions();
            serializationManager.initSerializers();
        });
    }

    private static void instantiateElementTypesFromFields() {
        FileTypeRegistry.getInstance().getRegisteredFileTypes();
        StubUpdatingIndex.getExtensions(BinaryFileStubBuilders.INSTANCE).forEach(builder2 -> {});
        StubUpdatingIndex.getExtensions(LanguageParserDefinitions.INSTANCE).forEach(ParserDefinition::getFileNodeType);
    }

    @NotNull
    private static <T> Stream<T> getExtensions(@NotNull KeyedExtensionCollector<T, ?> collector) {
        ExtensionPoint point;
        if (collector == null) {
            StubUpdatingIndex.$$$reportNull$$$0(19);
        }
        Stream<Object> stream = (point = collector.getPoint()) == null ? Stream.empty() : point.extensions().map(KeyedLazyInstance::getInstance);
        if (stream == null) {
            StubUpdatingIndex.$$$reportNull$$$0(20);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesExternalizer";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubTree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalStub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prebuiltStubTree";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canHaveStub";
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPrebuiltSerializedStubTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertDeserializedStubMatchesOriginalStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assertStubsAreSimilar";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assertPrebuiltStubTreeMatchesActualTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rememberIndexingStamp";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStampInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createIndexImplementation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "ensureSerializationManagerInitialized";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyIndex
    extends VfsAwareMapReduceIndex<Integer, SerializedStubTree> {
        private StubIndexImpl myStubIndex;
        @Nullable
        private final CompositeBinaryBuilderMap myCompositeBinaryBuilderMap;

        MyIndex(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Integer, SerializedStubTree> forwardIndexAccessor, @Nullable SnapshotInputMappings<Integer, SerializedStubTree> snapshotInputMappings) throws IOException {
            if (extension == null) {
                MyIndex.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                MyIndex.$$$reportNull$$$0(1);
            }
            super(extension, storage, forwardIndex, forwardIndexAccessor, snapshotInputMappings, (ReadWriteLock)null);
            this.myCompositeBinaryBuilderMap = FileBasedIndex.USE_IN_MEMORY_INDEX ? null : new CompositeBinaryBuilderMap();
        }

        @Override
        protected void doFlush() throws IOException, StorageException {
            StubIndexImpl stubIndex = this.getStubIndex();
            try {
                stubIndex.flush();
            }
            finally {
                super.doFlush();
            }
        }

        @NotNull
        private StubIndexImpl getStubIndex() {
            StubIndexImpl index = this.myStubIndex;
            if (index == null) {
                this.myStubIndex = index = (StubIndexImpl)StubIndex.getInstance();
            }
            StubIndexImpl stubIndexImpl = index;
            if (stubIndexImpl == null) {
                MyIndex.$$$reportNull$$$0(2);
            }
            return stubIndexImpl;
        }

        @Override
        @NotNull
        protected InputData<Integer, SerializedStubTree> mapInput(int inputId, @Nullable FileContent content2) {
            InputData data2 = super.mapInput(inputId, content2);
            if (content2 != null && !data2.getKeyValues().isEmpty()) {
                StubUpdatingIndex.rememberIndexingStamp(content2);
            }
            InputData inputData = data2;
            if (inputData == null) {
                MyIndex.$$$reportNull$$$0(3);
            }
            return inputData;
        }

        @Override
        protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<? extends Integer, ? extends SerializedStubTree> map2) {
            if (map2 == null) {
                MyIndex.$$$reportNull$$$0(4);
            }
            super.removeTransientDataForInMemoryKeys(inputId, map2);
            MyIndex.removeStubIndexKeys(inputId, MyIndex.getStubIndexMaps(map2));
        }

        @Override
        public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Integer> keys2) {
            Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> maps;
            if (keys2 == null) {
                MyIndex.$$$reportNull$$$0(5);
            }
            try {
                Map data2 = this.getIndexedFileData(inputId);
                maps = MyIndex.getStubIndexMaps(data2);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
            super.removeTransientDataForKeys(inputId, keys2);
            MyIndex.removeStubIndexKeys(inputId, maps);
        }

        private static void removeStubIndexKeys(int inputId, @NotNull Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs) {
            if (indexedStubs == null) {
                MyIndex.$$$reportNull$$$0(6);
            }
            StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
            for (StubIndexKey<?, ?> key : indexedStubs.keySet()) {
                stubIndex.removeTransientDataForFile(key, inputId, indexedStubs.get(key).keySet());
            }
        }

        @NotNull
        private static Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> getStubIndexMaps(@NotNull Map<? extends Integer, ? extends SerializedStubTree> data2) {
            if (data2 == null) {
                MyIndex.$$$reportNull$$$0(7);
            }
            if (data2.isEmpty()) {
                Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map2 = Collections.emptyMap();
                if (map2 == null) {
                    MyIndex.$$$reportNull$$$0(8);
                }
                return map2;
            }
            SerializedStubTree tree = data2.values().iterator().next();
            Map<Object, Object> map3 = tree == null ? Collections.emptyMap() : tree.getStubIndicesValueMap();
            if (map3 == null) {
                MyIndex.$$$reportNull$$$0(9);
            }
            return map3;
        }

        @Override
        protected void doClear() throws StorageException, IOException {
            StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
            if (stubIndex != null) {
                stubIndex.clearAllIndices();
            }
            super.doClear();
        }

        @Override
        protected void doDispose() throws StorageException {
            try {
                super.doDispose();
            }
            finally {
                this.getStubIndex().dispose();
            }
        }

        @Override
        public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(10);
            }
            super.setIndexedStateForFile(fileId, file2);
            this.setBinaryBuilderConfiguration(fileId, file2);
        }

        @Override
        protected boolean isIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(11);
            }
            if (this.myCompositeBinaryBuilderMap == null) {
                return true;
            }
            try {
                return this.myCompositeBinaryBuilderMap.isUpToDateState(fileId, file2.getFile());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
        }

        @Override
        protected void setIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(12);
            }
            this.setBinaryBuilderConfiguration(fileId, file2);
        }

        private void setBinaryBuilderConfiguration(int fileId, @NotNull IndexedFile file2) {
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(13);
            }
            if (this.myCompositeBinaryBuilderMap != null) {
                try {
                    this.myCompositeBinaryBuilderMap.persistState(fileId, file2.getFile());
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexedStubs";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStubIndex";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mapInput";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStubIndexMaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTransientDataForInMemoryKeys";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTransientDataForKeys";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeStubIndexKeys";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getStubIndexMaps";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setIndexedStateForFile";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isIndexConfigurationUpToDate";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setIndexConfigurationUpToDate";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setBinaryBuilderConfiguration";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

