/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WelcomeScreenTab;
import com.intellij.openapi.wm.WelcomeTabFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.EmptyStateProjectsPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.TabbedWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class ProjectsTabFactory
implements WelcomeTabFactory {
    static final int PRIMARY_BUTTONS_NUM = 3;

    @NotNull
    public WelcomeScreenTab createWelcomeTab(final @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ProjectsTabFactory.$$$reportNull$$$0(0);
        }
        return new TabbedWelcomeScreen.DefaultWelcomeScreenTab(IdeBundle.message((String)"welcome.screen.projects.title", (Object[])new Object[0])){

            @Override
            protected JComponent buildComponent() {
                if (RecentProjectListActionProvider.getInstance().getActions(false, true).isEmpty()) {
                    return new EmptyStateProjectsPanel();
                }
                JBPanel mainPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel().withBorder((Border)JBUI.Borders.empty((int)13, (int)12))).withBackground(WelcomeScreenUIManager.getProjectsBackground());
                SearchTextField projectSearch = this.createSearchProjectsField();
                NewRecentProjectPanel projectsPanel = this.createProjectsPanelWithExternalSearch(projectSearch);
                projectsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)10));
                JBPanel northPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel().andTransparent()).withBorder((Border)new CustomLineBorder(JBColor.border(), (Insets)JBUI.insetsBottom((int)1)){

                    public Insets getBorderInsets(Component c) {
                        return JBUI.insetsBottom((int)12);
                    }
                });
                JComponent projectActionsPanel = this.createActionsToolbar().getComponent();
                northPanel.add((Component)projectSearch, "Center");
                northPanel.add((Component)projectActionsPanel, "East");
                mainPanel.add((Component)northPanel, "North");
                mainPanel.add((Component)projectsPanel, "Center");
                mainPanel.add((Component)this.createNotificationsPanel(parentDisposable), "South");
                return mainPanel;
            }

            @NotNull
            private NewRecentProjectPanel createProjectsPanelWithExternalSearch(final @NotNull SearchTextField projectSearch) {
                if (projectSearch == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new NewRecentProjectPanel(parentDisposable, false){

                    @Override
                    protected JBList<AnAction> createList(AnAction[] recentProjectActions, Dimension size) {
                        final JBList<AnAction> projectsList = super.createList(recentProjectActions, size);
                        projectsList.setEmptyText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                        final SpeedSearch speedSearch2 = new SpeedSearch();
                        final NameFilteringListModel model = new NameFilteringListModel(projectsList.getModel(), 2.createProjectNameFunction(), arg_0 -> ((SpeedSearch)speedSearch2).shouldBeShowing(arg_0), () -> StringUtil.notNullize((String)speedSearch2.getFilter()));
                        projectsList.setModel((ListModel)model);
                        projectSearch.addDocumentListener((DocumentListener)new DocumentAdapter(){

                            protected void textChanged(@NotNull DocumentEvent e) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                speedSearch2.updatePattern(projectSearch.getText());
                                model.refilter();
                                projectsList.setSelectedIndex(0);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1$2$1", "textChanged"));
                            }
                        });
                        ScrollingUtil.installActions(projectsList, (JComponent)projectSearch);
                        DumbAwareAction.create(event -> {
                            AnAction selectedProject = (AnAction)this.myList.getSelectedValue();
                            if (selectedProject != null) {
                                selectedProject.actionPerformed(event);
                            }
                        }).registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)projectSearch, parentDisposable);
                        return projectsList;
                    }
                };
            }

            @NotNull
            private SearchTextField createSearchProjectsField() {
                SearchTextField projectSearch = new SearchTextField(false);
                projectSearch.setOpaque(false);
                projectSearch.setBorder((Border)JBUI.Borders.empty());
                projectSearch.getTextEditor().setOpaque(false);
                projectSearch.getTextEditor().setBorder((Border)JBUI.Borders.empty());
                projectSearch.getTextEditor().getEmptyText().setText(IdeBundle.message((String)"welcome.screen.search.projects.empty.text", (Object[])new Object[0]));
                SearchTextField searchTextField = projectSearch;
                if (searchTextField == null) {
                    1.$$$reportNull$$$0(1);
                }
                return searchTextField;
            }

            @NotNull
            private ActionToolbar createActionsToolbar() {
                Couple<DefaultActionGroup> mainAndMore = WelcomeScreenComponentFactory.splitActionGroupToMainAndMore((ActionGroup)ActionManager.getInstance().getAction("WelcomeScreen.QuickStart"), 3);
                DefaultActionGroup toolbarActionGroup = new DefaultActionGroup(ContainerUtil.map2List((Object[])((DefaultActionGroup)mainAndMore.getFirst()).getChildren(null), WelcomeScreenComponentFactory.ToolbarTextButtonWrapper::wrapAsTextButton));
                ActionGroup moreActionGroup = (ActionGroup)mainAndMore.getSecond();
                Presentation moreActionPresentation = moreActionGroup.getTemplatePresentation();
                moreActionPresentation.setIcon(AllIcons.Actions.More);
                moreActionPresentation.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
                toolbarActionGroup.addAction((AnAction)moreActionGroup);
                ActionToolbarImpl toolbar = new ActionToolbarImpl("WelcomeScreen", (ActionGroup)toolbarActionGroup, true){

                    @Override
                    @NotNull
                    protected ActionButton createToolbarButton(@NotNull AnAction action2, ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation2, @NotNull Dimension minimumSize) {
                        if (action2 == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (place == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if (presentation2 == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        if (minimumSize == null) {
                            3.$$$reportNull$$$0(3);
                        }
                        ActionButton toolbarButton = super.createToolbarButton(action2, look, place, presentation2, minimumSize);
                        toolbarButton.setFocusable(true);
                        ActionButton actionButton = toolbarButton;
                        if (actionButton == null) {
                            3.$$$reportNull$$$0(4);
                        }
                        return actionButton;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 4: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 4: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "action";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "place";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "presentation";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "minimumSize";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1$3";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1$3";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createToolbarButton";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "createToolbarButton";
                                break;
                            }
                            case 4: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 4: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                toolbar.setOpaque(false);
                ActionToolbarImpl actionToolbarImpl = toolbar;
                if (actionToolbarImpl == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionToolbarImpl;
            }

            private JPanel createNotificationsPanel(@NotNull Disposable parentDisposable2) {
                if (parentDisposable2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                NonOpaquePanel notificationsPanel = new NonOpaquePanel((LayoutManager)new FlowLayout(2));
                notificationsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)10));
                notificationsPanel.add(WelcomeScreenComponentFactory.createErrorsLink(parentDisposable2));
                return notificationsPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectSearch";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parentDisposable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchProjectsField";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActionsToolbar";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createProjectsPanelWithExternalSearch";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "createNotificationsPanel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/welcomeScreen/ProjectsTabFactory", "createWelcomeTab"));
    }
}

