/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.observable.properties;

import com.intellij.openapi.observable.operations.AnonymousParallelOperationTrace;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableClearableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002!\"B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015J4\u0010\u0016\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0015J\u0012\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\rJ\u0014\u0010\u001f\u001a\u00020\u00132\n\u0010\u001a\u001a\u00060\u0007R\u00020\u0000H\u0002J\u0012\u0010 \u001a\u00020\u00132\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\rR(\u0010\u0005\u001a\u001c\u0012\b\u0012\u00060\u0007R\u00020\u0000\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001d\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u0007R\u00020\u00000\u0007R\u00020\u00000\u000f\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/observable/properties/PropertyGraph;", "", "debugName", "", "(Ljava/lang/String;)V", "dependencies", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/openapi/observable/properties/PropertyGraph$Dependency;", "propagation", "Lcom/intellij/openapi/observable/operations/AnonymousParallelOperationTrace;", "properties", "Lcom/intellij/openapi/observable/properties/ObservableClearableProperty;", "recursionGuard", "Lcom/intellij/openapi/util/RecursionGuard;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "afterPropagation", "", "listener", "Lkotlin/Function0;", "dependsOn", "T", "child", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "parent", "update", "isPropagationBlocked", "", "property", "propagateChange", "register", "Dependency", "PropertyNode", "intellij.platform.ide.impl"})
public final class PropertyGraph {
    private final AnonymousParallelOperationTrace propagation;
    private final ConcurrentHashMap<ObservableClearableProperty<?>, PropertyNode> properties;
    private final ConcurrentHashMap<PropertyNode, CopyOnWriteArrayList<Dependency<?>>> dependencies;
    private final RecursionGuard<PropertyNode> recursionGuard;

    public final <T> void dependsOn(@NotNull AtomicProperty<T> child2, @NotNull ObservableClearableProperty<?> parent, @NotNull Function0<? extends T> update2) {
        Intrinsics.checkParameterIsNotNull(child2, (String)"child");
        Intrinsics.checkParameterIsNotNull(parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull(update2, (String)"update");
        PropertyNode propertyNode = this.properties.get(child2);
        if (propertyNode == null) {
            throw (Throwable)new IllegalArgumentException("Unregistered child property");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyNode, (String)"properties[child] ?: thr\u2026gistered child property\")");
        PropertyNode childNode = propertyNode;
        PropertyNode propertyNode2 = this.properties.get(parent);
        if (propertyNode2 == null) {
            throw (Throwable)new IllegalArgumentException("Unregistered parent property");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyNode2, (String)"properties[parent] ?: th\u2026istered parent property\")");
        PropertyNode parentNode = propertyNode2;
        this.dependencies.putIfAbsent(parentNode, new CopyOnWriteArrayList());
        CopyOnWriteArrayList children2 = (CopyOnWriteArrayList)MapsKt.getValue((Map)this.dependencies, (Object)parentNode);
        children2.add(new Dependency<T>(childNode, child2, update2));
    }

    public final void afterPropagation(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        this.propagation.afterOperation(listener2);
    }

    public final void register(@NotNull ObservableClearableProperty<?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        PropertyNode node = new PropertyNode();
        ((Map)this.properties).put(property, node);
        property.afterChange((Function1)new Function1<Object, Unit>(this, node){
            final /* synthetic */ PropertyGraph this$0;
            final /* synthetic */ PropertyNode $node;

            public final void invoke(@Nullable Object it) {
                PropertyGraph.access$getRecursionGuard$p(this.this$0).doPreventingRecursion((Object)this.$node, false, (Computable)new Computable<T>(this){
                    final /* synthetic */ register.1 this$0;

                    public final void compute() {
                        AnonymousParallelOperationTrace.Companion.task(PropertyGraph.access$getPropagation$p(this.this$0.this$0), (Function0)new Function0<Unit>(this){
                            final /* synthetic */ register.1 this$0;

                            public final void invoke() {
                                this.this$0.this$0.$node.setPropagationBlocked(true);
                                PropertyGraph.access$propagateChange(this.this$0.this$0.this$0, this.this$0.this$0.$node);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = propertyGraph;
                this.$node = propertyNode;
                super(1);
            }
        });
        property.afterReset((Function0<Unit>)((Function0)new Function0<Unit>(node){
            final /* synthetic */ PropertyNode $node;

            public final void invoke() {
                this.$node.setPropagationBlocked(false);
            }
            {
                this.$node = propertyNode;
                super(0);
            }
        }));
    }

    private final void propagateChange(PropertyNode parent) {
        CopyOnWriteArrayList<Dependency<?>> copyOnWriteArrayList = this.dependencies.get(parent);
        if (copyOnWriteArrayList == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(copyOnWriteArrayList, (String)"dependencies[parent] ?: return");
        CopyOnWriteArrayList<Dependency<?>> dependencies = copyOnWriteArrayList;
        for (Dependency<?> dependency : dependencies) {
            PropertyNode child2 = dependency.getNode();
            if (child2.isPropagationBlocked()) continue;
            this.recursionGuard.doPreventingRecursion((Object)child2, false, new Computable<T>(this, dependency, child2){
                final /* synthetic */ PropertyGraph this$0;
                final /* synthetic */ Dependency $dependency;
                final /* synthetic */ PropertyNode $child;

                public final void compute() {
                    this.$dependency.applyUpdate();
                    PropertyGraph.access$propagateChange(this.this$0, this.$child);
                }
                {
                    this.this$0 = propertyGraph;
                    this.$dependency = dependency;
                    this.$child = propertyNode;
                }
            });
        }
    }

    public final boolean isPropagationBlocked(@NotNull ObservableClearableProperty<?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        return ((PropertyNode)MapsKt.getValue((Map)this.properties, property)).isPropagationBlocked();
    }

    public PropertyGraph(@Nullable String debugName) {
        this.propagation = new AnonymousParallelOperationTrace((debugName == null ? "" : " of " + debugName) + ": Graph propagation");
        this.properties = new ConcurrentHashMap();
        this.dependencies = new ConcurrentHashMap();
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)PropertyGraph.class.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)recursionGuard, (String)"RecursionManager.createG\u2026tyGraph::class.java.name)");
        this.recursionGuard = recursionGuard;
    }

    public /* synthetic */ PropertyGraph(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public PropertyGraph() {
        this(null, 1, null);
    }

    public static final /* synthetic */ RecursionGuard access$getRecursionGuard$p(PropertyGraph $this) {
        return $this.recursionGuard;
    }

    public static final /* synthetic */ AnonymousParallelOperationTrace access$getPropagation$p(PropertyGraph $this) {
        return $this.propagation;
    }

    public static final /* synthetic */ void access$propagateChange(PropertyGraph $this, PropertyNode parent) {
        $this.propagateChange(parent);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;", "", "(Lcom/intellij/openapi/observable/properties/PropertyGraph;)V", "isPropagationBlocked", "", "()Z", "setPropagationBlocked", "(Z)V", "intellij.platform.ide.impl"})
    private final class PropertyNode {
        private volatile boolean isPropagationBlocked;

        public final boolean isPropagationBlocked() {
            return this.isPropagationBlocked;
        }

        public final void setPropagationBlocked(boolean bl) {
            this.isPropagationBlocked = bl;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eR\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/observable/properties/PropertyGraph$Dependency;", "T", "", "node", "Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "property", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "update", "Lkotlin/Function0;", "(Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;Lcom/intellij/openapi/observable/properties/AtomicProperty;Lkotlin/jvm/functions/Function0;)V", "getNode", "()Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;", "applyUpdate", "", "intellij.platform.ide.impl"})
    private static final class Dependency<T> {
        @NotNull
        private final PropertyNode node;
        private final AtomicProperty<T> property;
        private final Function0<T> update;

        public final void applyUpdate() {
            this.property.updateAndGet((Function1)new Function1<T, T>(this){
                final /* synthetic */ Dependency this$0;

                public final T invoke(T it) {
                    return (T)Dependency.access$getUpdate$p(this.this$0).invoke();
                }
                {
                    this.this$0 = dependency;
                    super(1);
                }
            });
        }

        @NotNull
        public final PropertyNode getNode() {
            return this.node;
        }

        public Dependency(@NotNull PropertyNode node, @NotNull AtomicProperty<T> property, @NotNull Function0<? extends T> update2) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull(property, (String)"property");
            Intrinsics.checkParameterIsNotNull(update2, (String)"update");
            this.node = node;
            this.property = property;
            this.update = update2;
        }

        public static final /* synthetic */ Function0 access$getUpdate$p(Dependency $this) {
            return $this.update;
        }
    }
}

