/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.SmartList;
import com.intellij.util.messages.Topic;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="TodoConfiguration", storages={@Storage(value="editor.xml")})
public class TodoConfiguration
implements PersistentStateComponent<Element> {
    public static final Topic<PropertyChangeListener> PROPERTY_CHANGE = new Topic("TodoConfiguration changes", PropertyChangeListener.class);
    private boolean myMultiLine = true;
    private TodoPattern[] myTodoPatterns;
    private TodoFilter[] myTodoFilters;
    private IndexPattern[] myIndexPatterns;
    @NonNls
    public static final String PROP_MULTILINE = "multiLine";
    @NonNls
    public static final String PROP_TODO_PATTERNS = "todoPatterns";
    @NonNls
    public static final String PROP_TODO_FILTERS = "todoFilters";
    @NonNls
    private static final String ELEMENT_MULTILINE = "multiLine";
    @NonNls
    private static final String ELEMENT_PATTERN = "pattern";
    @NonNls
    private static final String ELEMENT_FILTER = "filter";

    public TodoConfiguration() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                TodoConfiguration.this.colorSettingsChanged();
            }
        });
        this.resetToDefaultTodoPatterns();
    }

    public static TodoConfiguration getInstance() {
        return (TodoConfiguration)ServiceManager.getService(TodoConfiguration.class);
    }

    public void resetToDefaultTodoPatterns() {
        this.myTodoPatterns = this.getDefaultPatterns();
        this.myTodoFilters = new TodoFilter[0];
        this.buildIndexPatterns();
    }

    protected TodoPattern @NotNull [] getDefaultPatterns() {
        TodoPattern[] todoPatternArray = new TodoPattern[]{new TodoPattern("\\btodo\\b.*", TodoAttributesUtil.createDefault(), false), new TodoPattern("\\bfixme\\b.*", TodoAttributesUtil.createDefault(), false)};
        if (todoPatternArray == null) {
            TodoConfiguration.$$$reportNull$$$0(0);
        }
        return todoPatternArray;
    }

    private void buildIndexPatterns() {
        this.myIndexPatterns = new IndexPattern[this.myTodoPatterns.length];
        for (int i2 = 0; i2 < this.myTodoPatterns.length; ++i2) {
            this.myIndexPatterns[i2] = this.myTodoPatterns[i2].getIndexPattern();
        }
    }

    public TodoPattern @NotNull [] getTodoPatterns() {
        if (this.myTodoPatterns == null) {
            TodoConfiguration.$$$reportNull$$$0(1);
        }
        return this.myTodoPatterns;
    }

    public IndexPattern @NotNull [] getIndexPatterns() {
        if (this.myIndexPatterns == null) {
            TodoConfiguration.$$$reportNull$$$0(2);
        }
        return this.myIndexPatterns;
    }

    public void setTodoPatterns(TodoPattern @NotNull [] todoPatterns) {
        if (todoPatterns == null) {
            TodoConfiguration.$$$reportNull$$$0(3);
        }
        this.doSetTodoPatterns(todoPatterns, true);
    }

    private void doSetTodoPatterns(@NotNull @NotNull TodoPattern @NotNull [] todoPatterns, boolean shouldNotifyIndices) {
        if (todoPatterns == null) {
            TodoConfiguration.$$$reportNull$$$0(4);
        }
        Object[] oldTodoPatterns = this.myTodoPatterns;
        Object[] oldIndexPatterns = this.myIndexPatterns;
        this.myTodoPatterns = todoPatterns;
        this.buildIndexPatterns();
        if (shouldNotifyIndices && !Arrays.deepEquals(this.myIndexPatterns, oldIndexPatterns)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "indexPatterns", oldTodoPatterns, todoPatterns);
            TodoConfiguration.getPublisher((Topic<PropertyChangeListener>)IndexPatternProvider.INDEX_PATTERNS_CHANGED).propertyChange(event);
        }
        if (!Arrays.deepEquals(this.myTodoPatterns, oldTodoPatterns)) {
            TodoConfiguration.getPublisher(PROPERTY_CHANGE).propertyChange(new PropertyChangeEvent(this, PROP_TODO_PATTERNS, oldTodoPatterns, todoPatterns));
        }
    }

    @NotNull
    private static PropertyChangeListener getPublisher(@NotNull Topic<PropertyChangeListener> topic) {
        if (topic == null) {
            TodoConfiguration.$$$reportNull$$$0(5);
        }
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(topic);
        if (propertyChangeListener == null) {
            TodoConfiguration.$$$reportNull$$$0(6);
        }
        return propertyChangeListener;
    }

    public TodoFilter getTodoFilter(String name) {
        for (TodoFilter filter2 : this.myTodoFilters) {
            if (!filter2.getName().equals(name)) continue;
            return filter2;
        }
        return null;
    }

    public TodoFilter @NotNull [] getTodoFilters() {
        if (this.myTodoFilters == null) {
            TodoConfiguration.$$$reportNull$$$0(7);
        }
        return this.myTodoFilters;
    }

    public boolean isMultiLine() {
        return this.myMultiLine;
    }

    public void setMultiLine(boolean multiLine) {
        if (multiLine != this.myMultiLine) {
            this.myMultiLine = multiLine;
            TodoConfiguration.getPublisher(PROPERTY_CHANGE).propertyChange(new PropertyChangeEvent(this, "multiLine", !multiLine, multiLine));
        }
    }

    public void setTodoFilters(TodoFilter @NotNull [] filters) {
        if (filters == null) {
            TodoConfiguration.$$$reportNull$$$0(8);
        }
        TodoFilter[] oldFilters = this.myTodoFilters;
        this.myTodoFilters = filters;
        TodoConfiguration.getPublisher(PROPERTY_CHANGE).propertyChange(new PropertyChangeEvent(this, PROP_TODO_FILTERS, oldFilters, filters));
    }

    public void loadState(@NotNull Element element2) {
        String multiLineText;
        if (element2 == null) {
            TodoConfiguration.$$$reportNull$$$0(9);
        }
        this.myMultiLine = (multiLineText = element2.getChildText("multiLine")) == null || Boolean.valueOf(multiLineText) != false;
        SmartList patternsList = new SmartList();
        for (Element child2 : element2.getChildren(ELEMENT_PATTERN)) {
            patternsList.add(new TodoPattern(child2, TodoAttributesUtil.getDefaultColorSchemeTextAttributes()));
        }
        TodoPattern[] patterns = patternsList.isEmpty() ? this.getDefaultPatterns() : patternsList.toArray(new TodoPattern[0]);
        this.doSetTodoPatterns(patterns, false);
        SmartList filtersList = new SmartList();
        for (Element child3 : element2.getChildren(ELEMENT_FILTER)) {
            filtersList.add(new TodoFilter(child3, Arrays.asList(patterns)));
        }
        if (!filtersList.isEmpty() || this.myTodoFilters.length != 0) {
            this.setTodoFilters(filtersList.toArray(new TodoFilter[0]));
        }
    }

    public Element getState() {
        Element element2 = new Element("state");
        if (!this.myMultiLine) {
            Element m = new Element("multiLine");
            m.setText(Boolean.FALSE.toString());
            element2.addContent(m);
        }
        TodoPattern[] todoPatterns = this.myTodoPatterns;
        if (!Arrays.equals(this.myTodoPatterns, this.getDefaultPatterns())) {
            for (TodoPattern todoPattern : todoPatterns) {
                Element child2 = new Element(ELEMENT_PATTERN);
                todoPattern.writeExternal(child2);
                element2.addContent(child2);
            }
        }
        for (TodoFilter todoFilter : this.myTodoFilters) {
            Element child2 = new Element(ELEMENT_FILTER);
            todoFilter.writeExternal(child2, todoPatterns);
            element2.addContent(child2);
        }
        return element2;
    }

    public void colorSettingsChanged() {
        for (TodoPattern pattern : this.myTodoPatterns) {
            TodoAttributes attributes = pattern.getAttributes();
            if (attributes.shouldUseCustomTodoColor()) continue;
            attributes.setUseCustomTodoColor(false, TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROP_TODO_PATTERNS;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPatterns";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTodoPatterns";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexPatterns";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTodoFilters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTodoPatterns";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doSetTodoPatterns";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTodoFilters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

