/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.actions.associate.ui;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class FileTypeAssociationForm {
    private JPanel myFileTypesPanel;
    private JPanel myTopPanel;
    private JBScrollPane myScrollPane;
    private JBLabel myDescLabel;
    private List<MyFileTypeItem> myItems;

    public FileTypeAssociationForm() {
        this.$$$setupUI$$$();
        this.myTopPanel.setPreferredSize((Dimension)JBDimension.create((Dimension)new Dimension(800, 600)));
        this.myTopPanel.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myDescLabel.setText(ApplicationBundle.message((String)"light.edit.file.types.open.with.label", (Object[])new Object[]{ApplicationInfo.getInstance().getFullApplicationName()}));
    }

    private void createUIComponents() {
        this.myFileTypesPanel = new JPanel();
        this.myFileTypesPanel.setBorder((Border)JBUI.Borders.empty());
        this.myFileTypesPanel.setLayout(new BoxLayout(this.myFileTypesPanel, 1));
        this.myItems = this.createItems();
        this.myItems.forEach(item -> this.myFileTypesPanel.add((Component)((MyFileTypeItem)item).myCheckBox));
    }

    public JPanel getTopPanel() {
        return this.myTopPanel;
    }

    public List<MyFileTypeItem> createItems() {
        ArrayList<MyFileTypeItem> items = new ArrayList<MyFileTypeItem>();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (FileType fileType : fileTypeManager.getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || fileTypeManager.getAssociations(fileType).isEmpty()) continue;
            items.add(new MyFileTypeItem(fileType));
        }
        Collections.sort(items);
        return items;
    }

    List<FileType> getSelectedFileTypes() {
        return this.myItems.stream().filter(item -> ((MyFileTypeItem)item).myCheckBox.isSelected()).map(item -> ((MyFileTypeItem)item).myFileType).collect(Collectors.toList());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = this.myFileTypesPanel;
        jBScrollPane.setViewportView(jPanel3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private static class MyFileTypeItem
    implements Comparable<MyFileTypeItem> {
        private final FileType myFileType;
        private final JBCheckBox myCheckBox;

        private MyFileTypeItem(FileType fileType) {
            this.myFileType = fileType;
            this.myCheckBox = new JBCheckBox(this.getName());
        }

        private String getName() {
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(this.myFileType.getDisplayName()).append(" (");
            List matchers = FileTypeManager.getInstance().getAssociations(this.myFileType);
            Supplier<String> commaSupplier = new Supplier<String>(){
                private boolean isFirst = true;

                @Override
                public String get() {
                    if (this.isFirst) {
                        this.isFirst = false;
                        return "";
                    }
                    return ", ";
                }
            };
            matchers.stream().map(FileNameMatcher::getPresentableString).forEach(arg_0 -> MyFileTypeItem.lambda$getName$0(nameBuilder, (Supplier)commaSupplier, arg_0));
            nameBuilder.append(")");
            return nameBuilder.toString();
        }

        @Override
        public int compareTo(@NotNull MyFileTypeItem item) {
            if (item == null) {
                MyFileTypeItem.$$$reportNull$$$0(0);
            }
            return this.myFileType.getDisplayName().compareTo(item.myFileType.getDisplayName());
        }

        private static /* synthetic */ void lambda$getName$0(StringBuilder nameBuilder, Supplier commaSupplier, String matcherStr) {
            nameBuilder.append((String)commaSupplier.get()).append(matcherStr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/lightEdit/actions/associate/ui/FileTypeAssociationForm$MyFileTypeItem", "compareTo"));
        }
    }
}

