/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.Block;
import com.intellij.history.core.Content;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.Progress;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class SelectionCalculator {
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);
    private final IdeaGateway myGateway;
    private final List<? extends Revision> myRevisions;
    private final int myFromLine;
    private final int myToLine;
    private final Int2ObjectOpenHashMap<Block> myCache = new Int2ObjectOpenHashMap();

    public SelectionCalculator(IdeaGateway gw, List<? extends Revision> rr, int fromLine, int toLine) {
        this.myGateway = gw;
        this.myRevisions = rr;
        this.myFromLine = fromLine;
        this.myToLine = toLine;
    }

    public boolean canCalculateFor(Revision r, Progress p) {
        try {
            this.doGetSelectionFor(r, p);
        }
        catch (ContentIsUnavailableException e) {
            return false;
        }
        return true;
    }

    public Block getSelectionFor(Revision r, Progress p) {
        return this.doGetSelectionFor(r, p);
    }

    private Block doGetSelectionFor(Revision r, Progress p) {
        int target2 = this.myRevisions.indexOf(r);
        return this.getSelectionFor(target2, target2 + 1, p);
    }

    private Block getSelectionFor(int revisionIndex, int totalRevisions, Progress p) {
        Block result2;
        Block cached = (Block)this.myCache.get(revisionIndex);
        if (cached != null) {
            return cached;
        }
        String content2 = this.getRevisionContent(this.myRevisions.get(revisionIndex));
        p.processed((totalRevisions - revisionIndex) * 100 / totalRevisions);
        if (content2 == null) {
            result2 = EMPTY_BLOCK;
        } else if (revisionIndex == 0) {
            result2 = new Block(content2, this.myFromLine, this.myToLine + 1);
        } else {
            Block prev = EMPTY_BLOCK;
            int i2 = revisionIndex;
            while (prev == EMPTY_BLOCK && i2 > 0) {
                prev = this.getSelectionFor(--i2, totalRevisions, p);
            }
            result2 = prev.createPreviousBlock(content2);
        }
        this.myCache.put(revisionIndex, (Object)result2);
        return result2;
    }

    @Nullable
    private String getRevisionContent(Revision r) {
        Entry e = r.findEntry();
        if (e == null) {
            return null;
        }
        Content c = e.getContent();
        if (!c.isAvailable()) {
            throw new ContentIsUnavailableException();
        }
        return c.getString(e, this.myGateway);
    }

    private static class ContentIsUnavailableException
    extends RuntimeException {
        private ContentIsUnavailableException() {
        }
    }
}

