/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.exclude.ExcludedFileState;
import com.intellij.framework.detection.impl.exclude.ExcludesConfigurationState;
import com.intellij.framework.detection.impl.exclude.old.OldFacetDetectionExcludesConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FrameworkDetectionExcludesConfiguration")
public class DetectionExcludesConfigurationImpl
extends DetectionExcludesConfiguration
implements PersistentStateComponent<ExcludesConfigurationState>,
Disposable {
    private final Map<String, VirtualFilePointerContainer> myExcludedFiles;
    private final Set<String> myExcludedFrameworks;
    private final Project myProject;
    private final VirtualFilePointerManager myPointerManager;
    private boolean myDetectionEnabled;
    private boolean myConverted;

    public DetectionExcludesConfigurationImpl(@NotNull Project project) {
        if (project == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(0);
        }
        this.myDetectionEnabled = true;
        this.myProject = project;
        this.myPointerManager = VirtualFilePointerManager.getInstance();
        this.myExcludedFrameworks = new HashSet<String>();
        this.myExcludedFiles = FactoryMap.create(key -> this.myPointerManager.createContainer((Disposable)this));
    }

    public void addExcludedFramework(@NotNull FrameworkType type) {
        if (type == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(1);
        }
        this.convert();
        if (!this.myDetectionEnabled) {
            return;
        }
        this.myExcludedFrameworks.add(type.getId());
        VirtualFilePointerContainer container2 = this.myExcludedFiles.remove(type.getId());
        if (container2 != null) {
            container2.clear();
        }
    }

    public void addExcludedFile(@NotNull VirtualFile file2, @Nullable FrameworkType type) {
        String typeId;
        if (file2 == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(2);
        }
        this.convert();
        String string = typeId = type != null ? type.getId() : null;
        if (!this.myDetectionEnabled || typeId != null && this.myExcludedFrameworks.contains(typeId) || this.isFileExcluded(file2, typeId)) {
            return;
        }
        VirtualFilePointerContainer container2 = this.myExcludedFiles.get(typeId);
        if (typeId == null) {
            for (VirtualFilePointerContainer pointerContainer : this.myExcludedFiles.values()) {
                this.removeDescendants(file2, pointerContainer);
            }
        } else {
            this.removeDescendants(file2, container2);
        }
        container2.add(file2);
    }

    public void addExcludedUrl(@NotNull String url, @Nullable FrameworkType type) {
        String typeId;
        VirtualFile file2;
        if (url == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(3);
        }
        if ((file2 = VirtualFileManager.getInstance().findFileByUrl(url)) != null) {
            this.addExcludedFile(file2, type);
            return;
        }
        this.convert();
        String string = typeId = type != null ? type.getId() : null;
        if (!this.myDetectionEnabled || typeId != null && this.myExcludedFrameworks.contains(typeId)) {
            return;
        }
        this.myExcludedFiles.get(typeId).add(url);
    }

    private void convert() {
        this.ensureOldSettingsLoaded();
        this.markAsConverted();
    }

    private void markAsConverted() {
        this.myConverted = true;
        OldFacetDetectionExcludesConfiguration.getInstance(this.myProject).unsetState();
    }

    private void ensureOldSettingsLoaded() {
        OldFacetDetectionExcludesConfiguration oldConfiguration;
        ExcludesConfigurationState oldState;
        if (!this.myConverted && (oldState = (oldConfiguration = OldFacetDetectionExcludesConfiguration.getInstance(this.myProject)).convert()) != null) {
            this.doLoadState(oldState);
        }
    }

    public boolean isExcludedFromDetection(@NotNull VirtualFile file2, @NotNull FrameworkType frameworkType) {
        if (file2 == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(4);
        }
        if (frameworkType == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(5);
        }
        this.ensureOldSettingsLoaded();
        return this.isExcludedFromDetection(frameworkType) || this.isFileExcluded(file2, frameworkType.getId());
    }

    public boolean isExcludedFromDetection(@NotNull FrameworkType frameworkType) {
        if (frameworkType == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(6);
        }
        this.ensureOldSettingsLoaded();
        return !this.myDetectionEnabled || this.myExcludedFrameworks.contains(frameworkType.getId());
    }

    private boolean isFileExcluded(@NotNull VirtualFile file2, @Nullable String typeId) {
        if (file2 == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(7);
        }
        if (this.myExcludedFiles.containsKey(typeId) && DetectionExcludesConfigurationImpl.isUnder(file2, this.myExcludedFiles.get(typeId))) {
            return true;
        }
        return typeId != null && this.myExcludedFiles.containsKey(null) && DetectionExcludesConfigurationImpl.isUnder(file2, this.myExcludedFiles.get(null));
    }

    private static boolean isUnder(VirtualFile file2, VirtualFilePointerContainer container2) {
        for (VirtualFile excludedFile : container2.getFiles()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)excludedFile, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void removeDescendants(VirtualFile file2, VirtualFilePointerContainer container2) {
        for (VirtualFile virtualFile : container2.getFiles()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)virtualFile, (boolean)false)) continue;
            container2.remove(this.myPointerManager.create(virtualFile, (Disposable)this, null));
        }
    }

    public void removeExcluded(@NotNull Collection<VirtualFile> files2, FrameworkType frameworkType) {
        if (files2 == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(8);
        }
        this.ensureOldSettingsLoaded();
        if (!this.myDetectionEnabled || this.myExcludedFrameworks.contains(frameworkType.getId())) {
            files2.clear();
            return;
        }
        Iterator<VirtualFile> iterator2 = files2.iterator();
        while (iterator2.hasNext()) {
            VirtualFile file2 = iterator2.next();
            if (!this.isFileExcluded(file2, frameworkType.getId())) continue;
            iterator2.remove();
        }
    }

    @NotNull
    public ExcludesConfigurationState getActualState() {
        this.ensureOldSettingsLoaded();
        ExcludesConfigurationState state = new ExcludesConfigurationState();
        state.setDetectionEnabled(this.myDetectionEnabled);
        state.getFrameworkTypes().addAll(this.myExcludedFrameworks);
        state.getFrameworkTypes().sort(String.CASE_INSENSITIVE_ORDER);
        for (String typeId : this.myExcludedFiles.keySet()) {
            VirtualFilePointerContainer container2 = this.myExcludedFiles.get(typeId);
            for (String url : container2.getUrls()) {
                state.getFiles().add(new ExcludedFileState(url, typeId));
            }
        }
        state.getFiles().sort((o1, o2) -> StringUtil.comparePairs((String)o1.getFrameworkType(), (String)o1.getUrl(), (String)o2.getFrameworkType(), (String)o2.getUrl(), (boolean)true));
        ExcludesConfigurationState excludesConfigurationState = state;
        if (excludesConfigurationState == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(9);
        }
        return excludesConfigurationState;
    }

    @Nullable
    public ExcludesConfigurationState getState() {
        if (!this.myConverted) {
            return null;
        }
        return this.getActualState();
    }

    public void loadState(@NotNull ExcludesConfigurationState state) {
        if (state == null) {
            DetectionExcludesConfigurationImpl.$$$reportNull$$$0(10);
        }
        this.doLoadState(state);
        if (!(this.myExcludedFiles.isEmpty() && this.myExcludedFrameworks.isEmpty() && this.myDetectionEnabled)) {
            this.markAsConverted();
        }
    }

    private void doLoadState(@Nullable ExcludesConfigurationState state) {
        this.myExcludedFrameworks.clear();
        for (VirtualFilePointerContainer container2 : this.myExcludedFiles.values()) {
            container2.clear();
        }
        boolean bl = this.myDetectionEnabled = state == null || state.isDetectionEnabled();
        if (state != null) {
            this.myExcludedFrameworks.addAll(state.getFrameworkTypes());
            for (ExcludedFileState fileState : state.getFiles()) {
                this.myExcludedFiles.get(fileState.getFrameworkType()).add(fileState.getUrl());
            }
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedFramework";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedUrl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFromDetection";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFileExcluded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeExcluded";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

