/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentInside {
    public int whiteSpaces = 0;
    public int tabs = 0;

    public IndentInside() {
    }

    public IndentInside(int whiteSpaces, int tabs) {
        this.whiteSpaces = whiteSpaces;
        this.tabs = tabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndentInside indent = (IndentInside)o;
        if (this.tabs != indent.tabs) {
            return false;
        }
        return this.whiteSpaces == indent.whiteSpaces;
    }

    public int hashCode() {
        int result2 = this.whiteSpaces;
        result2 = 29 * result2 + this.tabs;
        return result2;
    }

    public int getTabsCount(CommonCodeStyleSettings.IndentOptions options2) {
        int tabsFromSpaces = this.whiteSpaces / options2.TAB_SIZE;
        return this.tabs + tabsFromSpaces;
    }

    public int getSpacesCount(CommonCodeStyleSettings.IndentOptions options2) {
        return this.whiteSpaces + this.tabs * options2.TAB_SIZE;
    }

    @NotNull
    static IndentInside getLastLineIndent(@NotNull CharSequence text) {
        if (text == null) {
            IndentInside.$$$reportNull$$$0(0);
        }
        CharSequence lastLine = IndentInside.getLastLine(text);
        return IndentInside.createIndentOn(lastLine);
    }

    @NotNull
    public static IndentInside createIndentOn(@Nullable CharSequence lastLine) {
        IndentInside result2 = new IndentInside();
        if (lastLine == null) {
            IndentInside indentInside = result2;
            if (indentInside == null) {
                IndentInside.$$$reportNull$$$0(1);
            }
            return indentInside;
        }
        for (int i2 = 0; i2 < lastLine.length(); ++i2) {
            if (lastLine.charAt(i2) == ' ') {
                ++result2.whiteSpaces;
            }
            if (lastLine.charAt(i2) != '\t') continue;
            ++result2.tabs;
        }
        IndentInside indentInside = result2;
        if (indentInside == null) {
            IndentInside.$$$reportNull$$$0(2);
        }
        return indentInside;
    }

    @NotNull
    public static CharSequence getLastLine(@NotNull CharSequence text) {
        int i2;
        if (text == null) {
            IndentInside.$$$reportNull$$$0(3);
        }
        if ((i2 = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)(text.length() - 1), (String)"\n")) < 0) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                IndentInside.$$$reportNull$$$0(4);
            }
            return charSequence;
        }
        if (i2 >= text.length() - 1) {
            return "";
        }
        CharSequence charSequence = text.subSequence(i2 + 1, text.length());
        if (charSequence == null) {
            IndentInside.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    public String toString() {
        return String.format("spaces: %d, tabs: %d", this.whiteSpaces, this.tabs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/IndentInside";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/IndentInside";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndentOn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLastLineIndent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLastLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

