/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgCatCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.ShellCommand;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgBranchReferenceValidator;

public abstract class HgUtil {
    public static final Pattern URL_WITH_PASSWORD = Pattern.compile("(?:.+)://(?:.+)(:.+)@(?:.+)");
    public static final int MANY_FILES = 100;
    private static final Logger LOG = Logger.getInstance(HgUtil.class);
    public static final String DOT_HG = ".hg";
    public static final String TIP_REFERENCE = "tip";
    public static final String HEAD_REFERENCE = "HEAD";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyResourceToTempFile(String basename, String extension) throws IOException {
        InputStream in = HgUtil.class.getClassLoader().getResourceAsStream("python/" + basename + extension);
        File tempFile = FileUtil.createTempFile((String)basename, (String)extension);
        byte[] buffer = new byte[4096];
        OutputStream out = null;
        try {
            int bytesRead;
            out = new FileOutputStream(tempFile, false);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static void markDirectoryDirty(Project project, VirtualFile file) {
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(file);
    }

    public static void markFileDirty(Project project, VirtualFile file) throws InvocationTargetException, InterruptedException {
        ApplicationManager.getApplication().runReadAction(() -> VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file));
        HgUtil.runWriteActionAndWait(() -> file.refresh(true, false));
    }

    public static void runWriteActionAndWait(@NotNull Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (runnable == null) {
            HgUtil.$$$reportNull$$$0(0);
        }
        GuiUtils.runOrInvokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(runnable));
    }

    public static void runWriteActionLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            HgUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(runnable));
    }

    @Nullable
    public static File getTemporaryPythonFile(String base) {
        try {
            File file = HgUtil.copyResourceToTempFile(base, ".py");
            String fileName = file.getName();
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                File[] files = file.getParentFile().listFiles((dir, name) -> name.startsWith(fileName));
                if (files != null) {
                    for (File file1 : files) {
                        file1.delete();
                    }
                }
            });
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static VirtualFile getNearestHgRoot(VirtualFile dir) {
        for (VirtualFile currentDir = dir; currentDir != null; currentDir = currentDir.getParent()) {
            if (!HgUtil.isHgRoot(currentDir)) continue;
            return currentDir;
        }
        return null;
    }

    public static boolean isHgRoot(@Nullable VirtualFile dir) {
        return dir != null && dir.findChild(DOT_HG) != null;
    }

    @Nullable
    public static VirtualFile getHgRootOrNull(Project project, FilePath filePath) {
        if (project == null) {
            return HgUtil.getNearestHgRoot(VcsUtil.getVirtualFile((String)filePath.getPath()));
        }
        return HgUtil.getNearestHgRoot(VcsUtil.getVcsRootFor((Project)project, (FilePath)filePath));
    }

    @NotNull
    public static Set<VirtualFile> hgRoots(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(2);
        }
        if (filePaths == null) {
            HgUtil.$$$reportNull$$$0(3);
        }
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (FilePath filePath : filePaths) {
            ContainerUtil.addIfNotNull(roots, (Object)HgUtil.getHgRootOrNull(project, filePath));
        }
        HashSet<VirtualFile> hashSet = roots;
        if (hashSet == null) {
            HgUtil.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Nullable
    public static VirtualFile getHgRootOrNull(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            HgUtil.$$$reportNull$$$0(5);
        }
        return HgUtil.getHgRootOrNull(project, VcsUtil.getFilePath((String)file.getPath()));
    }

    @NotNull
    public static VirtualFile getHgRootOrThrow(Project project, FilePath filePath) throws VcsException {
        VirtualFile vf = HgUtil.getHgRootOrNull(project, filePath);
        if (vf == null) {
            throw new VcsException(HgBundle.message("hg4idea.exception.file.not.under.hg", filePath.getPresentableUrl()));
        }
        VirtualFile virtualFile = vf;
        if (virtualFile == null) {
            HgUtil.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile getHgRootOrThrow(Project project, VirtualFile file) throws VcsException {
        return HgUtil.getHgRootOrThrow(project, VcsUtil.getFilePath((String)file.getPath()));
    }

    @Nullable
    public static String getNewBranchNameFromUser(@NotNull HgRepository repository, @NlsContexts.DialogTitle @NotNull String dialogTitle) {
        if (repository == null) {
            HgUtil.$$$reportNull$$$0(7);
        }
        if (dialogTitle == null) {
            HgUtil.$$$reportNull$$$0(8);
        }
        return Messages.showInputDialog((Project)repository.getProject(), (String)HgBundle.message("hg4idea.branch.enter.name", new Object[0]), (String)dialogTitle, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new HgBranchReferenceValidator(repository));
    }

    @NotNull
    public static Map<VirtualFile, List<String>> getRelativePathsByRepository(Collection<? extends HgFile> hgFiles) {
        HashMap<VirtualFile, List<String>> map = new HashMap<VirtualFile, List<String>>();
        if (hgFiles == null) {
            HashMap<VirtualFile, List<String>> hashMap = map;
            if (hashMap == null) {
                HgUtil.$$$reportNull$$$0(9);
            }
            return hashMap;
        }
        for (HgFile hgFile : hgFiles) {
            VirtualFile repo = hgFile.getRepo();
            ArrayList<String> files = (ArrayList<String>)map.get(repo);
            if (files == null) {
                files = new ArrayList<String>();
                map.put(repo, files);
            }
            files.add(hgFile.getRelativePath());
        }
        HashMap<VirtualFile, List<String>> hashMap = map;
        if (hashMap == null) {
            HgUtil.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    public static HgFile getFileNameInTargetRevision(Project project, HgRevisionNumber vcsRevisionNumber, HgFile localHgFile) {
        HgStatusCommand statCommand = new HgStatusCommand.Builder(false).copySource(true).baseRevision(vcsRevisionNumber).targetRevision(HgRevisionNumber.getInstance("", ".")).build(project);
        Set<HgChange> changes = statCommand.executeInCurrentThread(localHgFile.getRepo(), Collections.singletonList(localHgFile.toFilePath()));
        for (HgChange change : changes) {
            if (!change.afterFile().equals(localHgFile)) continue;
            HgFile hgFile = change.beforeFile();
            if (hgFile == null) {
                HgUtil.$$$reportNull$$$0(11);
            }
            return hgFile;
        }
        HgFile hgFile = localHgFile;
        if (hgFile == null) {
            HgUtil.$$$reportNull$$$0(12);
        }
        return hgFile;
    }

    @NotNull
    public static FilePath getOriginalFileName(@NotNull FilePath filePath, ChangeListManager changeListManager) {
        Change change;
        if (filePath == null) {
            HgUtil.$$$reportNull$$$0(13);
        }
        if ((change = changeListManager.getChange(filePath)) == null) {
            FilePath filePath2 = filePath;
            if (filePath2 == null) {
                HgUtil.$$$reportNull$$$0(14);
            }
            return filePath2;
        }
        FileStatus status = change.getFileStatus();
        if (status == HgChangeProvider.COPIED || status == HgChangeProvider.RENAMED) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null) : "If a file's status is copied or renamed, there must be an previous version";
            FilePath filePath3 = beforeRevision.getFile();
            if (filePath3 == null) {
                HgUtil.$$$reportNull$$$0(15);
            }
            return filePath3;
        }
        FilePath filePath4 = filePath;
        if (filePath4 == null) {
            HgUtil.$$$reportNull$$$0(16);
        }
        return filePath4;
    }

    @NotNull
    public static Map<VirtualFile, Collection<VirtualFile>> sortByHgRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(17);
        }
        if (files == null) {
            HgUtil.$$$reportNull$$$0(18);
        }
        HashMap<VirtualFile, Collection<VirtualFile>> sorted = new HashMap<VirtualFile, Collection<VirtualFile>>();
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        for (VirtualFile virtualFile : files) {
            HgRepository repo = (HgRepository)repositoryManager.getRepositoryForFile(virtualFile);
            if (repo == null) continue;
            HashSet<VirtualFile> filesForRoot = (HashSet<VirtualFile>)sorted.get(repo.getRoot());
            if (filesForRoot == null) {
                filesForRoot = new HashSet<VirtualFile>();
                sorted.put(repo.getRoot(), filesForRoot);
            }
            filesForRoot.add(virtualFile);
        }
        HashMap<VirtualFile, Collection<VirtualFile>> hashMap = sorted;
        if (hashMap == null) {
            HgUtil.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    @NotNull
    public static Map<VirtualFile, Collection<FilePath>> groupFilePathsByHgRoots(@NotNull Project project, @NotNull Collection<? extends FilePath> files) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(20);
        }
        if (files == null) {
            HgUtil.$$$reportNull$$$0(21);
        }
        HashMap<VirtualFile, Collection<FilePath>> sorted = new HashMap<VirtualFile, Collection<FilePath>>();
        if (project.isDisposed()) {
            HashMap<VirtualFile, Collection<FilePath>> hashMap = sorted;
            if (hashMap == null) {
                HgUtil.$$$reportNull$$$0(22);
            }
            return hashMap;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        for (FilePath filePath : files) {
            HgRepository repo = (HgRepository)repositoryManager.getRepositoryForFile(filePath);
            if (repo == null) continue;
            HashSet<FilePath> filesForRoot = (HashSet<FilePath>)sorted.get(repo.getRoot());
            if (filesForRoot == null) {
                filesForRoot = new HashSet<FilePath>();
                sorted.put(repo.getRoot(), filesForRoot);
            }
            filesForRoot.add(filePath);
        }
        HashMap<VirtualFile, Collection<FilePath>> hashMap = sorted;
        if (hashMap == null) {
            HgUtil.$$$reportNull$$$0(23);
        }
        return hashMap;
    }

    @Nullable
    public static VirtualFile convertToLocalVirtualFile(@Nullable VirtualFile file) {
        if (!(file instanceof AbstractVcsVirtualFile)) {
            return file;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile resultFile = lfs.findFileByPath(file.getPath());
        if (resultFile == null) {
            resultFile = lfs.refreshAndFindFileByPath(file.getPath());
        }
        return resultFile;
    }

    @NotNull
    public static List<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable HgRevisionNumber revNum1, @Nullable HgRevisionNumber revNum2) {
        HgStatusCommand statusCommand;
        if (project == null) {
            HgUtil.$$$reportNull$$$0(24);
        }
        if (root == null) {
            HgUtil.$$$reportNull$$$0(25);
        }
        if (path == null) {
            HgUtil.$$$reportNull$$$0(26);
        }
        if (revNum1 != null) {
            statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(!path.isDirectory()).baseRevision(revNum1).targetRevision(revNum2).build(project);
        } else {
            LOG.assertTrue(revNum2 != null, (Object)("revision1 and revision2 can't both be null. Path: " + path));
            statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(false).baseRevision(revNum2).build(project);
        }
        Set<HgChange> hgChanges = statusCommand.executeInCurrentThread(root, Collections.singleton(path));
        return HgUtil.createChanges(project, root, revNum1, revNum2, hgChanges);
    }

    @NotNull
    public static List<Change> createChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable HgRevisionNumber revNum1, @Nullable HgRevisionNumber revNum2, Collection<HgChange> hgChanges) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(27);
        }
        if (root == null) {
            HgUtil.$$$reportNull$$$0(28);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (HgChange hgChange : hgChanges) {
            FileStatus status = HgUtil.convertHgDiffStatus(hgChange.getStatus());
            if (status == FileStatus.UNKNOWN) continue;
            changes.add(HgHistoryUtil.createChange(project, root, hgChange.beforeFile().getRelativePath(), revNum1, hgChange.afterFile().getRelativePath(), revNum2, status));
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            HgUtil.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @NotNull
    public static FileStatus convertHgDiffStatus(@NotNull HgFileStatusEnum hgstatus) {
        if (hgstatus == null) {
            HgUtil.$$$reportNull$$$0(30);
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.ADDED)) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                HgUtil.$$$reportNull$$$0(31);
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.DELETED)) {
            FileStatus fileStatus = FileStatus.DELETED;
            if (fileStatus == null) {
                HgUtil.$$$reportNull$$$0(32);
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.MODIFIED)) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                HgUtil.$$$reportNull$$$0(33);
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.COPY)) {
            FileStatus fileStatus = HgChangeProvider.COPIED;
            if (fileStatus == null) {
                HgUtil.$$$reportNull$$$0(34);
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.UNVERSIONED)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                HgUtil.$$$reportNull$$$0(35);
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.IGNORED)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            if (fileStatus == null) {
                HgUtil.$$$reportNull$$$0(36);
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.UNKNOWN;
        if (fileStatus == null) {
            HgUtil.$$$reportNull$$$0(37);
        }
        return fileStatus;
    }

    public static byte @NotNull [] loadContent(@NotNull Project project, @Nullable HgRevisionNumber revisionNumber, @NotNull HgFile fileToCat) {
        HgCommandResult result;
        if (project == null) {
            HgUtil.$$$reportNull$$$0(38);
        }
        if (fileToCat == null) {
            HgUtil.$$$reportNull$$$0(39);
        }
        byte[] byArray = (result = new HgCatCommand(project).execute(fileToCat, revisionNumber, fileToCat.toFilePath().getCharset())) != null && result.getExitValue() == 0 ? result.getBytesOutput() : ArrayUtilRt.EMPTY_BYTE_ARRAY;
        if (byArray == null) {
            HgUtil.$$$reportNull$$$0(40);
        }
        return byArray;
    }

    public static String removePasswordIfNeeded(@NotNull String path) {
        Matcher matcher;
        if (path == null) {
            HgUtil.$$$reportNull$$$0(41);
        }
        if ((matcher = URL_WITH_PASSWORD.matcher(path)).matches()) {
            return path.substring(0, matcher.start(1)) + path.substring(matcher.end(1));
        }
        return path;
    }

    @NotNull
    public static String getDisplayableBranchOrBookmarkText(@NotNull HgRepository repository) {
        if (repository == null) {
            HgUtil.$$$reportNull$$$0(42);
        }
        Repository.State state = repository.getState();
        String branchText = "";
        if (state != Repository.State.NORMAL) {
            branchText = branchText + state.toString() + " ";
        }
        String string = branchText + repository.getCurrentBranchName();
        if (string == null) {
            HgUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public static HgRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(44);
        }
        HgRepositoryManager hgRepositoryManager = (HgRepositoryManager)((Object)ServiceManager.getService((Project)project, HgRepositoryManager.class));
        if (hgRepositoryManager == null) {
            HgUtil.$$$reportNull$$$0(45);
        }
        return hgRepositoryManager;
    }

    @Nullable
    public static HgRepository getCurrentRepository(@NotNull Project project) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(46);
        }
        if (project.isDisposed()) {
            return null;
        }
        return (HgRepository)DvcsUtil.guessRepositoryForFile((Project)project, (RepositoryManager)HgUtil.getRepositoryManager(project), (VirtualFile)DvcsUtil.getSelectedFile((Project)project), (String)HgProjectSettings.getInstance(project).getRecentRootPath());
    }

    @Nullable
    public static HgRepository getRepositoryForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(47);
        }
        if (file == null || project.isDisposed()) {
            return null;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        VirtualFile root = HgUtil.getHgRootOrNull(project, file);
        return (HgRepository)repositoryManager.getRepositoryForRoot(root);
    }

    @Nullable
    public static String getRepositoryDefaultPath(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(48);
        }
        if (root == null) {
            HgUtil.$$$reportNull$$$0(49);
        }
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRootQuick(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getDefaultPath();
    }

    @Nullable
    public static String getRepositoryDefaultPushPath(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(50);
        }
        if (root == null) {
            HgUtil.$$$reportNull$$$0(51);
        }
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getDefaultPushPath();
    }

    @Nullable
    public static String getConfig(@NotNull Project project, @NotNull VirtualFile root, @NotNull String section, @Nullable String configName) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(52);
        }
        if (root == null) {
            HgUtil.$$$reportNull$$$0(53);
        }
        if (section == null) {
            HgUtil.$$$reportNull$$$0(54);
        }
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getNamedConfig(section, configName);
    }

    @NotNull
    public static Collection<String> getRepositoryPaths(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            HgUtil.$$$reportNull$$$0(55);
        }
        if (root == null) {
            HgUtil.$$$reportNull$$$0(56);
        }
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRootQuick(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        Collection<String> collection = hgRepository.getRepositoryConfig().getPaths();
        if (collection == null) {
            HgUtil.$$$reportNull$$$0(57);
        }
        return collection;
    }

    public static boolean isExecutableValid(@Nullable String executable) {
        try {
            if (StringUtil.isEmptyOrSpaces((String)executable)) {
                return false;
            }
            HgCommandResult result = HgUtil.getVersionOutput(executable);
            return result.getExitValue() == 0 && !result.getRawOutput().isEmpty();
        }
        catch (Throwable e) {
            LOG.info("Error during hg executable validation: ", e);
            return false;
        }
    }

    @NotNull
    public static HgCommandResult getVersionOutput(@NotNull String executable) throws ShellCommandException {
        if (executable == null) {
            HgUtil.$$$reportNull$$$0(58);
        }
        String hgExecutable = executable.trim();
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(hgExecutable);
        cmdArgs.add("version");
        cmdArgs.add("-q");
        ShellCommand shellCommand = new ShellCommand(cmdArgs, null, CharsetToolkit.getDefaultSystemCharset());
        HgCommandResult hgCommandResult = shellCommand.execute(false, false);
        if (hgCommandResult == null) {
            HgUtil.$$$reportNull$$$0(59);
        }
        return hgCommandResult;
    }

    public static List<String> getNamesWithoutHashes(Collection<? extends HgNameWithHashInfo> namesWithHashes) {
        ArrayList<String> names = new ArrayList<String>();
        for (HgNameWithHashInfo hgNameWithHashInfo : namesWithHashes) {
            if (names.contains(hgNameWithHashInfo.getName())) continue;
            names.add(hgNameWithHashInfo.getName());
        }
        return names;
    }

    public static List<String> getSortedNamesWithoutHashes(Collection<? extends HgNameWithHashInfo> namesWithHashes) {
        return ((StreamEx)StreamEx.of(HgUtil.getNamesWithoutHashes(namesWithHashes)).sorted(StringUtil::naturalCompare)).toList();
    }

    @NotNull
    public static Couple<String> parseUserNameAndEmail(@NotNull String authorString) {
        String userName;
        String email;
        if (authorString == null) {
            HgUtil.$$$reportNull$$$0(60);
        }
        int startEmailIndex = authorString.indexOf(60);
        int startDomainIndex = authorString.indexOf(64);
        int endEmailIndex = authorString.indexOf(62);
        if (0 < startEmailIndex && startEmailIndex < startDomainIndex && startDomainIndex < endEmailIndex) {
            email = authorString.substring(startEmailIndex + 1, endEmailIndex);
            userName = authorString.substring(0, startEmailIndex).trim();
        } else if (!authorString.contains(" ") && startDomainIndex > 0) {
            userName = "";
            email = startEmailIndex >= 0 && startDomainIndex > startEmailIndex && startDomainIndex < endEmailIndex ? authorString.substring(startEmailIndex + 1, endEmailIndex).trim() : authorString;
        } else {
            userName = authorString.trim();
            email = "";
        }
        Couple couple = Couple.of((Object)userName, (Object)email);
        if (couple == null) {
            HgUtil.$$$reportNull$$$0(61);
        }
        return couple;
    }

    @NotNull
    public static List<String> getTargetNames(@NotNull HgRepository repository) {
        if (repository == null) {
            HgUtil.$$$reportNull$$$0(62);
        }
        List list = ContainerUtil.sorted((Collection)ContainerUtil.map(repository.getRepositoryConfig().getPaths(), s -> HgUtil.removePasswordIfNeeded(s)));
        if (list == null) {
            HgUtil.$$$reportNull$$$0(63);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/util/HgUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 42: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 25: 
            case 28: 
            case 49: 
            case 51: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 26: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hgstatus";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCat";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/util/HgUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "hgRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHgRootOrThrow";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePathsByRepository";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameInTargetRevision";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFileName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByHgRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "groupFilePathsByHgRoots";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createChanges";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "convertHgDiffStatus";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayableBranchOrBookmarkText";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryPaths";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionOutput";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUserNameAndEmail";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionAndWait";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionLater";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hgRoots";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHgRootOrNull";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewBranchNameFromUser";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalFileName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sortByHgRoots";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "groupFilePathsByHgRoots";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDiff";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createChanges";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "convertHgDiffStatus";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadContent";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removePasswordIfNeeded";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayableBranchOrBookmarkText";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRepository";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFile";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryDefaultPath";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryDefaultPushPath";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryPaths";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getVersionOutput";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "parseUserNameAndEmail";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getTargetNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

