/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.java.InjectionCache;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConcatenationInjector
implements ConcatenationAwareInjector {
    private final Project myProject;

    public ConcatenationInjector(@NotNull Project project) {
        if (project == null) {
            ConcatenationInjector.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, PsiElement ... operands) {
        if (registrar == null) {
            ConcatenationInjector.$$$reportNull$$$0(1);
        }
        if (operands == null) {
            ConcatenationInjector.$$$reportNull$$$0(2);
        }
        if (operands.length == 0) {
            return;
        }
        boolean hasLiteral = false;
        InjectedLanguage tempInjectedLanguage = null;
        PsiFile containingFile = null;
        TemporaryPlacesRegistry temporaryPlaceRegistry = TemporaryPlacesRegistry.getInstance(this.myProject);
        for (PsiElement operand : operands) {
            if (!PsiUtilEx.isStringOrCharacterLiteral(operand)) continue;
            hasLiteral = true;
            if (containingFile == null) {
                containingFile = operands[0].getContainingFile();
            }
            if ((tempInjectedLanguage = temporaryPlaceRegistry.getLanguageFor((PsiLanguageInjectionHost)operand, containingFile)) != null) break;
        }
        if (!hasLiteral) {
            return;
        }
        this.processOperandsInjection(registrar, containingFile, tempInjectedLanguage, operands);
    }

    private void processOperandsInjection(final @NotNull MultiHostRegistrar registrar, final @NotNull PsiFile containingFile, final @Nullable InjectedLanguage tempInjectedLanguage, PsiElement @NotNull [] operands) {
        if (registrar == null) {
            ConcatenationInjector.$$$reportNull$$$0(3);
        }
        if (containingFile == null) {
            ConcatenationInjector.$$$reportNull$$$0(4);
        }
        if (operands == null) {
            ConcatenationInjector.$$$reportNull$$$0(5);
        }
        final Language tempLanguage = tempInjectedLanguage == null ? null : tempInjectedLanguage.getLanguage();
        LanguageInjectionSupport injectionSupport = tempLanguage == null ? InjectorUtils.findNotNullInjectionSupport("java") : TemporaryPlacesRegistry.getInstance(this.myProject).getLanguageInjectionSupport();
        InjectionProcessor injectionProcessor = new InjectionProcessor(Configuration.getProjectInstance(this.myProject), injectionSupport, operands){

            @Override
            protected Pair<PsiLanguageInjectionHost, Language> processInjection(Language language, List<? extends Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, boolean settingsAvailable, boolean unparsable) {
                InjectorUtils.registerInjection(language, list, containingFile, registrar);
                InjectorUtils.registerSupport(this.getLanguageInjectionSupport(), settingsAvailable, (PsiElement)list.get(0).getFirst(), language);
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)list.get(0).getFirst();
                if (tempLanguage != null) {
                    InjectorUtils.putInjectedFileUserData((PsiElement)host, language, LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, tempInjectedLanguage);
                }
                InjectorUtils.putInjectedFileUserData((PsiElement)host, language, InjectedLanguageUtil.FRANKENSTEIN_INJECTION, unparsable ? Boolean.TRUE : null);
                return Pair.create((Object)host, (Object)language);
            }

            @Override
            protected boolean areThereInjectionsWithName(String methodName, boolean annoOnly) {
                if (methodName == null) {
                    return false;
                }
                if (ConcatenationInjector.this.getAnnotatedElementsValue().contains(methodName)) {
                    return true;
                }
                return !annoOnly && ConcatenationInjector.this.getXmlAnnotatedElementsValue().contains(methodName);
            }
        };
        if (tempLanguage != null) {
            BaseInjection baseInjection = new BaseInjection("java");
            baseInjection.setInjectedLanguageId(tempInjectedLanguage.getID());
            List<Pair<PsiLanguageInjectionHost, Language>> list = injectionProcessor.processInjectionWithContext(baseInjection, false);
            for (Pair<PsiLanguageInjectionHost, Language> pair : list) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)pair.getFirst();
                Language language = (Language)pair.getSecond();
                InjectorUtils.putInjectedFileUserData((PsiElement)host, language, LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, tempInjectedLanguage);
            }
        } else {
            injectionProcessor.processInjections();
        }
    }

    private static boolean checkUnparsableReference(PsiExpression refExpression) {
        PsiElement parent = refExpression.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            IElementType operation = assignmentExpression.getOperationTokenType();
            if (assignmentExpression.getLExpression() == refExpression && JavaTokenType.PLUSEQ.equals(operation)) {
                return true;
            }
        } else if (parent instanceof PsiPolyadicExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression) {
            return true;
        }
        return false;
    }

    private Collection<String> getAnnotatedElementsValue() {
        return InjectionCache.getInstance(this.myProject).getAnnoIndex();
    }

    private Collection<String> getXmlAnnotatedElementsValue() {
        return InjectionCache.getInstance(this.myProject).getXmlIndex();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operands";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/intelliLang/inject/java/ConcatenationInjector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagesToInject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processOperandsInjection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class InjectionProcessor {
        private final Configuration myConfiguration;
        private final LanguageInjectionSupport mySupport;
        private final PsiElement[] myOperands;
        private boolean myShouldStop;
        private boolean myUnparsable;

        InjectionProcessor(Configuration configuration, LanguageInjectionSupport support, PsiElement ... operands) {
            this.myConfiguration = configuration;
            this.mySupport = support;
            this.myOperands = operands;
        }

        public void processInjections() {
            PsiElement firstOperand = this.myOperands[0];
            PsiElement topBlock = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)firstOperand, null);
            final LocalSearchScope searchScope = new LocalSearchScope(new PsiElement[]{topBlock instanceof PsiCodeBlock ? topBlock : firstOperand.getContainingFile()}, "", true);
            final ArrayList<PsiElement> places = new ArrayList<PsiElement>(5);
            places.add(firstOperand);
            THashSet visitedVars = new THashSet();
            class MyAnnoVisitor
            implements AnnotationUtilEx.AnnotatedElementVisitor {
                final /* synthetic */ Set val$visitedVars;

                MyAnnoVisitor() {
                    this.val$visitedVars = set;
                }

                @Override
                public boolean visitMethodParameter(PsiExpression expression, PsiCall psiCallExpression) {
                    PsiMethod method;
                    String methodName;
                    PsiExpressionList list = psiCallExpression.getArgumentList();
                    assert (list != null);
                    int index = ArrayUtil.indexOf((Object[])list.getExpressions(), (Object)expression);
                    if (psiCallExpression instanceof PsiMethodCallExpression) {
                        String referenceName = ((PsiMethodCallExpression)psiCallExpression).getMethodExpression().getReferenceName();
                        if ("super".equals(referenceName) || "this".equals(referenceName)) {
                            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiCallExpression, PsiClass.class, (boolean)true);
                            PsiClass psiTargetClass = "super".equals(referenceName) ? (psiClass == null ? null : psiClass.getSuperClass()) : psiClass;
                            methodName = psiTargetClass == null ? null : psiTargetClass.getName();
                        } else {
                            methodName = referenceName;
                        }
                    } else {
                        PsiJavaCodeReferenceElement classRef;
                        methodName = psiCallExpression instanceof PsiNewExpression ? ((classRef = ((PsiNewExpression)psiCallExpression).getClassOrAnonymousClassReference()) == null ? null : classRef.getReferenceName()) : (psiCallExpression instanceof PsiEnumConstant ? ((method = psiCallExpression.resolveMethod()) != null ? method.getName() : null) : null);
                    }
                    if (methodName != null && index >= 0 && InjectionProcessor.this.areThereInjectionsWithName(methodName, false) && (method = psiCallExpression.resolveMethod()) != null) {
                        PsiParameter[] parameters = method.getParameterList().getParameters();
                        if (index < parameters.length) {
                            InjectionProcessor.this.process((PsiModifierListOwner)parameters[index], method, index);
                        } else if (method.isVarArgs()) {
                            InjectionProcessor.this.process((PsiModifierListOwner)parameters[parameters.length - 1], method, parameters.length - 1);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visitMethodReturnStatement(PsiElement source, PsiMethod method) {
                    if (InjectionProcessor.this.areThereInjectionsWithName(method.getName(), false)) {
                        InjectionProcessor.this.process((PsiModifierListOwner)method, method, -1);
                    }
                    return false;
                }

                private void visitVariableUsages(PsiVariable variable) {
                    if (variable == null) {
                        return;
                    }
                    if (InjectionProcessor.this.myConfiguration.getAdvancedConfiguration().getDfaOption() != Configuration.DfaOption.OFF) {
                        ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope).forEach(psiReference -> {
                            PsiElement element = psiReference.getElement();
                            if (element instanceof PsiExpression) {
                                PsiExpression refExpression = (PsiExpression)element;
                                places.add(refExpression);
                                if (!InjectionProcessor.this.myUnparsable) {
                                    InjectionProcessor.this.myUnparsable = ConcatenationInjector.checkUnparsableReference(refExpression);
                                }
                            }
                            return true;
                        });
                    }
                }

                @Override
                public boolean visitVariable(PsiVariable variable) {
                    PsiVariable anchor;
                    if (!this.val$visitedVars.add(variable)) {
                        return false;
                    }
                    this.visitVariableUsages(variable);
                    Object object = !(variable.getFirstChild() instanceof PsiComment) ? variable : (anchor = variable.getModifierList() != null ? variable.getModifierList() : variable.getTypeElement());
                    if (anchor != null && !this.processCommentInjection((PsiElement)anchor)) {
                        InjectionProcessor.this.myShouldStop = true;
                    } else {
                        InjectionProcessor.this.process((PsiModifierListOwner)variable, null, -1);
                    }
                    return false;
                }

                @Override
                public boolean visitAnnotationParameter(PsiNameValuePair nameValuePair, PsiAnnotation psiAnnotation) {
                    String methodName;
                    String paramName = nameValuePair.getName();
                    String string = methodName = paramName != null ? paramName : "value";
                    if (InjectionProcessor.this.areThereInjectionsWithName(methodName, false)) {
                        PsiElement element;
                        PsiReference reference = nameValuePair.getReference();
                        PsiElement psiElement = element = reference == null ? null : reference.resolve();
                        if (element instanceof PsiMethod) {
                            InjectionProcessor.this.process((PsiModifierListOwner)((PsiMethod)element), (PsiMethod)element, -1);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visitReference(PsiReferenceExpression expression) {
                    if (InjectionProcessor.this.myConfiguration.getAdvancedConfiguration().getDfaOption() == Configuration.DfaOption.OFF) {
                        return true;
                    }
                    PsiElement e = expression.resolve();
                    if (e instanceof PsiVariable) {
                        if (e instanceof PsiParameter) {
                            PsiParameterList parameterList;
                            PsiParameter p = (PsiParameter)e;
                            PsiElement declarationScope = p.getDeclarationScope();
                            PsiMethod method = declarationScope instanceof PsiMethod ? (PsiMethod)declarationScope : null;
                            PsiParameterList psiParameterList = parameterList = method == null ? null : method.getParameterList();
                            if (parameterList != null && parameterList == e.getParent() && InjectionProcessor.this.areThereInjectionsWithName(method.getName(), false)) {
                                int parameterIndex = parameterList.getParameterIndex((PsiParameter)e);
                                InjectionProcessor.this.process((PsiModifierListOwner)e, method, parameterIndex);
                            }
                        }
                        this.visitVariable((PsiVariable)e);
                    }
                    return !InjectionProcessor.this.myShouldStop;
                }

                private boolean processCommentInjection(@NotNull PsiElement anchor) {
                    if (anchor == null) {
                        MyAnnoVisitor.$$$reportNull$$$0(0);
                    }
                    Ref causeRef = Ref.create();
                    BaseInjection injection = InjectionProcessor.this.mySupport.findCommentInjection(anchor, (Ref<? super PsiElement>)causeRef);
                    if (injection != null) {
                        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)anchor, PsiVariable.class);
                        this.visitVariableUsages(variable);
                        return InjectionProcessor.this.processCommentInjectionInner((PsiElement)causeRef.get(), injection);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/intellij/plugins/intelliLang/inject/java/ConcatenationInjector$InjectionProcessor$1MyAnnoVisitor", "processCommentInjection"));
                }
            }
            MyAnnoVisitor visitor = new MyAnnoVisitor();
            if (!visitor.processCommentInjection(firstOperand)) {
                return;
            }
            while (!places.isEmpty() && !this.myShouldStop) {
                PsiElement curPlace = (PsiElement)places.remove(0);
                AnnotationUtilEx.visitAnnotatedElements(curPlace, visitor);
            }
        }

        protected boolean processCommentInjectionInner(PsiElement comment, BaseInjection injection) {
            this.processInjectionWithContext(injection, false);
            return false;
        }

        private void process(PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
            if (!this.processAnnotationInjections(owner)) {
                this.myShouldStop = true;
            }
            for (BaseInjection injection : this.myConfiguration.getInjections("java")) {
                if (!injection.acceptsPsiElement((PsiElement)owner) || this.processXmlInjections(injection, owner, method, paramIndex)) continue;
                this.myShouldStop = true;
                break;
            }
        }

        private boolean processAnnotationInjections(PsiModifierListOwner annoElement) {
            PsiElement scope;
            if (annoElement instanceof PsiParameter && (scope = ((PsiParameter)annoElement).getDeclarationScope()) instanceof PsiMethod && !this.areThereInjectionsWithName(((PsiNamedElement)scope).getName(), true)) {
                return true;
            }
            PsiAnnotation[] annotations = AnnotationUtilEx.getAnnotationFrom(annoElement, this.myConfiguration.getAdvancedConfiguration().getLanguageAnnotationPair(), true);
            if (annotations.length > 0) {
                return this.processAnnotationInjectionInner(annoElement, annotations);
            }
            return true;
        }

        protected boolean processAnnotationInjectionInner(PsiModifierListOwner owner, PsiAnnotation[] annotations) {
            String id = AnnotationUtilEx.calcAnnotationValue(annotations, "value");
            String prefix = AnnotationUtilEx.calcAnnotationValue(annotations, "prefix");
            String suffix = AnnotationUtilEx.calcAnnotationValue(annotations, "suffix");
            BaseInjection injection = new BaseInjection("java");
            if (prefix != null) {
                injection.setPrefix(prefix);
            }
            if (suffix != null) {
                injection.setSuffix(suffix);
            }
            if (id != null) {
                injection.setInjectedLanguageId(id);
            }
            this.processInjectionWithContext(injection, false);
            return false;
        }

        protected boolean processXmlInjections(BaseInjection injection, PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
            this.processInjectionWithContext(injection, true);
            return !injection.isTerminal();
        }

        @NotNull
        List<Pair<PsiLanguageInjectionHost, Language>> processInjectionWithContext(BaseInjection injection, boolean settingsAvailable) {
            Language language = InjectorUtils.getLanguage(injection);
            if (language == null) {
                List<Pair<PsiLanguageInjectionHost, Language>> list = Collections.emptyList();
                if (list == null) {
                    InjectionProcessor.$$$reportNull$$$0(0);
                }
                return list;
            }
            boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
            Ref unparsableRef = Ref.create((Object)this.myUnparsable);
            List<Object> objects = ContextComputationProcessor.collectOperands(injection.getPrefix(), injection.getSuffix(), (Ref<? super Boolean>)unparsableRef, this.myOperands);
            if (objects.isEmpty()) {
                List<Pair<PsiLanguageInjectionHost, Language>> list = Collections.emptyList();
                if (list == null) {
                    InjectionProcessor.$$$reportNull$$$0(1);
                }
                return list;
            }
            ArrayList<Trinity> result = new ArrayList<Trinity>();
            int len = objects.size();
            for (int i = 0; i < len; ++i) {
                String curPrefix = null;
                Object o = objects.get(i);
                if (o instanceof String) {
                    curPrefix = (String)o;
                    if (i == len - 1) {
                        List<Pair<PsiLanguageInjectionHost, Language>> list = Collections.emptyList();
                        if (list == null) {
                            InjectionProcessor.$$$reportNull$$$0(2);
                        }
                        return list;
                    }
                    o = objects.get(++i);
                }
                String curSuffix = null;
                PsiLanguageInjectionHost curHost = null;
                if (o instanceof PsiLanguageInjectionHost) {
                    Object next;
                    curHost = (PsiLanguageInjectionHost)o;
                    if (i == len - 2 && (next = objects.get(i + 1)) instanceof String) {
                        ++i;
                        curSuffix = (String)next;
                    }
                }
                if (curHost == null) {
                    unparsableRef.set((Object)Boolean.TRUE);
                    continue;
                }
                if (curHost instanceof PsiLiteralExpression) {
                    List<TextRange> textBlockInjectedArea = InjectionProcessor.getTextBlockInjectedArea(curHost);
                    List<TextRange> injectedArea = textBlockInjectedArea == null ? injection.getInjectedArea((PsiElement)curHost) : textBlockInjectedArea;
                    int injectedAreaSize = injectedArea.size();
                    for (int j = 0; j < injectedAreaSize; ++j) {
                        TextRange textRange = injectedArea.get(j);
                        TextRange.assertProperRange((Segment)textRange, (Object)injection);
                        result.add(Trinity.create((Object)curHost, (Object)InjectedLanguage.create(injection.getInjectedLanguageId(), separateFiles || j == 0 ? curPrefix : "", separateFiles || j == injectedAreaSize - 1 ? curSuffix : "", true), (Object)textRange));
                    }
                    continue;
                }
                TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)curHost);
                TextRange.assertProperRange((Segment)textRange, (Object)injection);
                result.add(Trinity.create((Object)curHost, (Object)InjectedLanguage.create(injection.getInjectedLanguageId(), curPrefix, curSuffix, true), (Object)textRange));
            }
            if (result.isEmpty()) {
                List<Pair<PsiLanguageInjectionHost, Language>> list = Collections.emptyList();
                if (list == null) {
                    InjectionProcessor.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (injection.shouldBeIgnored(ContainerUtil.mapIterator(result.iterator(), r -> (PsiLanguageInjectionHost)r.first), "\n")) {
                List<Pair<PsiLanguageInjectionHost, Language>> list = Collections.emptyList();
                if (list == null) {
                    InjectionProcessor.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<Pair<PsiLanguageInjectionHost, Language>> res = new ArrayList<Pair<PsiLanguageInjectionHost, Language>>();
            if (separateFiles) {
                for (Trinity trinity : result) {
                    ContainerUtil.addIfNotNull(res, this.processInjection(language, Collections.singletonList(trinity), settingsAvailable, false));
                }
            } else if (InjectionProcessor.isReferenceInject(language)) {
                for (Trinity trinity : result) {
                    ContainerUtil.addIfNotNull(res, this.processInjection(language, Collections.singletonList(trinity), settingsAvailable, (Boolean)unparsableRef.get()));
                }
            } else {
                ContainerUtil.addIfNotNull(res, this.processInjection(language, result, settingsAvailable, (Boolean)unparsableRef.get()));
            }
            ArrayList<Pair<PsiLanguageInjectionHost, Language>> arrayList = res;
            if (arrayList == null) {
                InjectionProcessor.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static List<TextRange> getTextBlockInjectedArea(PsiLanguageInjectionHost host) {
            if (!(host instanceof PsiLiteralExpression)) {
                return null;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)host;
            if (!literalExpression.isTextBlock()) {
                return null;
            }
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)host);
            int indent = PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)literalExpression);
            if (indent <= 0) {
                return Collections.singletonList(textRange);
            }
            String text = literalExpression.getText();
            int startOffset = textRange.getStartOffset() + indent;
            int endOffset = text.indexOf(10, startOffset);
            SmartList result = new SmartList();
            while (endOffset > 0) {
                result.add(new TextRange(startOffset, ++endOffset));
                startOffset = endOffset + indent;
                endOffset = text.indexOf(10, startOffset);
            }
            endOffset = textRange.getEndOffset();
            if (startOffset < endOffset) {
                result.add(new TextRange(startOffset, endOffset));
            }
            return result;
        }

        private static boolean isReferenceInject(Language language) {
            return LanguageParserDefinitions.INSTANCE.forLanguage(language) == null && ReferenceInjector.findById((String)language.getID()) != null;
        }

        protected Pair<PsiLanguageInjectionHost, Language> processInjection(Language language, List<? extends Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, boolean xmlInjection, boolean unparsable) {
            return null;
        }

        protected boolean areThereInjectionsWithName(String methodName, boolean annoOnly) {
            return true;
        }

        public LanguageInjectionSupport getLanguageInjectionSupport() {
            return this.mySupport;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/java/ConcatenationInjector$InjectionProcessor", "processInjectionWithContext"));
        }
    }
}

