/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\"\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"pythonsStoreLocation", "Ljava/io/File;", "getPythonsStoreLocation", "()Ljava/io/File;", "appXReparsePointFileExists", "", "file", "getAppXAppsInstalled", "", "filenameFilter", "Ljava/io/FilenameFilter;", "mayBeAppXReparsePoint", "intellij.python.community.impl"})
public final class WinAppxToolsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean mayBeAppXReparsePoint(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File file2 = WinAppxToolsKt.getPythonsStoreLocation();
        if (file2 == null) return false;
        File file3 = file2;
        boolean bl = false;
        boolean bl2 = false;
        File storeLocation = file3;
        boolean bl3 = false;
        if (!FileUtil.isAncestor((File)storeLocation, (File)file, (boolean)false)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean appXReparsePointFileExists(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.exists()) return true;
        if (!WinAppxToolsKt.mayBeAppXReparsePoint(file)) return false;
        Object[] objectArray = file.getParentFile().list();
        if (objectArray == null) return false;
        if (!ArraysKt.contains((Object[])objectArray, (Object)file.getName())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getAppXAppsInstalled(@NotNull FilenameFilter filenameFilter) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)filenameFilter, (String)"filenameFilter");
        String[] stringArray = WinAppxToolsKt.getPythonsStoreLocation();
        if (stringArray != null && (stringArray = stringArray.list(filenameFilter)) != null) {
            void $this$mapNotNullTo$iv$iv;
            String[] $this$mapNotNull$iv = stringArray;
            boolean $i$f$mapNotNull = false;
            String[] stringArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var8_8 = $this$forEach$iv$iv$iv;
            int n = ((void)var8_8).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var8_8[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                File file = new File(WinAppxToolsKt.getPythonsStoreLocation(), (String)it);
                boolean bl3 = false;
                boolean bl4 = false;
                File it$iv$iv = file;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final File getPythonsStoreLocation() {
        if (!SystemInfo.isWin10OrNewer) {
            return null;
        }
        String string = System.getenv("LOCALAPPDATA");
        if (string == null) {
            return null;
        }
        String localappdata = string;
        File appsPath = new File(localappdata, "Microsoft//WindowsApps");
        return appsPath.exists() ? appsPath : null;
    }
}

