/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.PySdkToInstallOnWindows;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getPy37ToInstallOnWindows", "Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows;", "getPy38ToInstallOnWindows", "getSdksToInstall", "", "Lcom/jetbrains/python/sdk/PySdkToInstall;", "intellij.python.community.impl"})
public final class PySdkToInstallKt {
    private static final Logger LOGGER;

    @NotNull
    public static final List<PySdkToInstall> getSdksToInstall() {
        return SystemInfo.isWindows ? CollectionsKt.listOf((Object[])new PySdkToInstallOnWindows[]{PySdkToInstallKt.getPy37ToInstallOnWindows(), PySdkToInstallKt.getPy38ToInstallOnWindows()}) : CollectionsKt.emptyList();
    }

    private static final PySdkToInstallOnWindows getPy37ToInstallOnWindows() {
        PySdkToInstallOnWindows pySdkToInstallOnWindows;
        String version = "3.7";
        String name = "Python " + version;
        HashFunction hashFunction = Hashing.md5();
        if (SystemInfo.is32Bit) {
            HashFunction hashFunction2 = hashFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashFunction2, (String)"hashFunction");
            pySdkToInstallOnWindows = new PySdkToInstallOnWindows(name, version, "https://www.python.org/ftp/python/3.7.7/python-3.7.7.exe", 25747128L, "e9db9cf43b4f2472d75a055380871045", hashFunction2, "python-3.7.7.exe");
        } else {
            HashFunction hashFunction3 = hashFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashFunction3, (String)"hashFunction");
            pySdkToInstallOnWindows = new PySdkToInstallOnWindows(name, version, "https://www.python.org/ftp/python/3.7.7/python-3.7.7-amd64.exe", 26797616L, "e0c910087459df78d827eb1554489663", hashFunction3, "python-3.7.7-amd64.exe");
        }
        return pySdkToInstallOnWindows;
    }

    private static final PySdkToInstallOnWindows getPy38ToInstallOnWindows() {
        PySdkToInstallOnWindows pySdkToInstallOnWindows;
        String version = "3.8";
        String name = "Python " + version;
        HashFunction hashFunction = Hashing.md5();
        if (SystemInfo.is32Bit) {
            HashFunction hashFunction2 = hashFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashFunction2, (String)"hashFunction");
            pySdkToInstallOnWindows = new PySdkToInstallOnWindows(name, version, "https://www.python.org/ftp/python/3.8.3/python-3.8.3.exe", 26744744L, "452373e2c467c14220efeb10f40c231f", hashFunction2, "python-3.8.3.exe");
        } else {
            HashFunction hashFunction3 = hashFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashFunction3, (String)"hashFunction");
            pySdkToInstallOnWindows = new PySdkToInstallOnWindows(name, version, "https://www.python.org/ftp/python/3.8.3/python-3.8.3-amd64.exe", 27805800L, "fd2458fa0e9ead1dd9fbc2370a42853b", hashFunction3, "python-3.8.3-amd64.exe");
        }
        return pySdkToInstallOnWindows;
    }

    static {
        Logger logger = Logger.getInstance(PySdkToInstall.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(PySdkToInstall::class.java)");
        LOGGER = logger;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }
}

