/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import org.jetbrains.annotations.NotNull;

public class PyUpdatePropertySignatureQuickFix
implements LocalQuickFix {
    private final boolean myHasValue;

    public PyUpdatePropertySignatureQuickFix(boolean hasValue) {
        this.myHasValue = hasValue;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.update.parameters", new Object[0]);
        if (string == null) {
            PyUpdatePropertySignatureQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            PyUpdatePropertySignatureQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyUpdatePropertySignatureQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement element = descriptor2.getPsiElement();
        PyCallable function = (PyCallable)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallable.class, (boolean)false);
        assert (function != null);
        PyParameterList parameterList = function.getParameterList();
        PyParameter[] parameters = parameterList.getParameters();
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        String selfText = parameters.length != 0 ? parameters[0].getText() : "self";
        StringBuilder functionText = new StringBuilder("def foo(" + selfText);
        if (this.myHasValue) {
            String valueText = parameters.length > 1 ? parameters[1].getText() : "value";
            functionText.append(", ").append(valueText);
        }
        functionText.append("): pass");
        PyParameterList list = generator.createFromText(LanguageLevel.forElement(element), PyFunction.class, functionText.toString()).getParameterList();
        parameterList.replace((PsiElement)list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyUpdatePropertySignatureQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyUpdatePropertySignatureQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

