/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy.call;

import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.python.findUsages.PyClassFindUsagesHandler;
import com.jetbrains.python.findUsages.PyFunctionFindUsagesHandler;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStaticCallHierarchyUtil {
    public static Collection<PsiElement> getCallees(@NotNull PyElement element) {
        if (element == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(0);
        }
        final ArrayList<PsiElement> callees = new ArrayList<PsiElement>();
        PyRecursiveElementVisitor visitor2 = new PyRecursiveElementVisitor(){

            @Override
            public void visitPyParameterList(PyParameterList node) {
            }

            @Override
            public void visitPyLambdaExpression(PyLambdaExpression node) {
            }

            @Override
            public void visitPyFunction(PyFunction innerFunction) {
                for (PyParameter parameter : innerFunction.getParameterList().getParameters()) {
                    PyExpression defaultValue = parameter.getDefaultValue();
                    if (defaultValue == null) continue;
                    defaultValue.accept(this);
                }
            }

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                super.visitPyCallExpression(node);
                StreamEx.of(node.multiResolveCalleeFunction(PyResolveContext.implicitContext())).select(PyFunction.class).forEach(callees::add);
            }
        };
        visitor2.visitElement((PsiElement)element);
        return callees;
    }

    @NotNull
    public static Collection<PsiElement> getCallers(@NotNull PyElement pyElement) {
        if (pyElement == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(1);
        }
        ArrayList<PsiElement> callers = new ArrayList<PsiElement>();
        Collection<UsageInfo> usages = PyStaticCallHierarchyUtil.findUsages((PsiElement)pyElement);
        for (UsageInfo usage : usages) {
            PyExpression receiver;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            element = element.getParent();
            while (element instanceof PyParenthesizedExpression) {
                element = element.getParent();
            }
            if (!(element instanceof PyCallExpression) || (receiver = ((PyCallExpression)element).getReceiver(null)) instanceof PyCallExpression && ((PyCallExpression)receiver).isCalleeText("super")) continue;
            PsiElement caller = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyParameterList.class, PyFunction.class});
            if (caller instanceof PyFunction) {
                callers.add(caller);
                continue;
            }
            if (!(caller instanceof PyParameterList)) continue;
            PsiElement innerFunction = PsiTreeUtil.getParentOfType((PsiElement)caller, PyFunction.class);
            PsiElement outerFunction = PsiTreeUtil.getParentOfType((PsiElement)innerFunction, PyFunction.class);
            if (innerFunction == null || outerFunction == null) continue;
            callers.add(outerFunction);
        }
        ArrayList<PsiElement> arrayList = callers;
        if (arrayList == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static Collection<UsageInfo> findUsages(@NotNull PsiElement element) {
        FindUsagesHandlerBase handler;
        if (element == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(3);
        }
        if ((handler = PyStaticCallHierarchyUtil.createFindUsageHandler(element)) == null) {
            return new ArrayList<UsageInfo>();
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements());
        FindUsagesOptions options = handler.getFindUsagesOptions(null);
        for (PsiElement psiElement : psiElements) {
            handler.processElementUsages(psiElement, (Processor)processor2, options);
        }
        return processor2.getResults();
    }

    @Nullable
    private static FindUsagesHandlerBase createFindUsageHandler(@NotNull PsiElement element) {
        if (element == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(4);
        }
        if (element instanceof PyFunction) {
            PsiElement next;
            TypeEvalContext context = TypeEvalContext.userInitiated(element.getProject(), null);
            Collection superMethods = PySuperMethodsSearch.search((PyFunction)element, true, context).findAll();
            if (superMethods.size() > 0 && (next = (PsiElement)superMethods.iterator().next()) instanceof PyFunction && !PyStaticCallHierarchyUtil.isInObject((PyFunction)next)) {
                ArrayList<PsiElement> allMethods = new ArrayList<PsiElement>();
                allMethods.add(element);
                allMethods.addAll(superMethods);
                return new PyFunctionFindUsagesHandler(element, allMethods);
            }
            return new PyFunctionFindUsagesHandler(element);
        }
        if (element instanceof PyClass) {
            return new PyClassFindUsagesHandler((PyClass)element);
        }
        return null;
    }

    private static boolean isInObject(PyFunction fun) {
        PyClass containingClass = fun.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return PyUtil.isObjectClass(containingClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/hierarchy/call/PyStaticCallHierarchyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/hierarchy/call/PyStaticCallHierarchyUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCallees";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCallers";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsageHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

