/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;

public class PyQuotedStringIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.quoted.string", new Object[0]);
        if (string == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyStringLiteralExpression.class);
        if (string != null) {
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)string, PyDocStringOwner.class);
            if (docStringOwner != null && docStringOwner.getDocStringExpression() == string) {
                return false;
            }
            String stringText = string.getText();
            int prefixLength = PyStringLiteralUtil.getPrefixLength(stringText);
            if ((stringText = stringText.substring(prefixLength)).length() >= 6 && (stringText.startsWith("'''") && stringText.endsWith("'''") || stringText.startsWith("\"\"\"") && stringText.endsWith("\"\"\""))) {
                return false;
            }
            if (stringText.length() > 2) {
                if (stringText.startsWith("'") && stringText.endsWith("'")) {
                    this.setText(PyPsiBundle.message("INTN.quoted.string.single.to.double", new Object[0]));
                    return true;
                }
                if (stringText.startsWith("\"") && stringText.endsWith("\"")) {
                    this.setText(PyPsiBundle.message("INTN.quoted.string.double.to.single", new Object[0]));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(2);
        }
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyStringLiteralExpression.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (string != null) {
            PyStringLiteralExpression st;
            String result;
            int prefixLength;
            String stringText = string.getText();
            String text2 = stringText.substring(prefixLength = PyStringLiteralUtil.getPrefixLength(stringText));
            if (text2.startsWith("'") && text2.endsWith("'")) {
                result = PyQuotedStringIntention.convertSingleToDoubleQuoted(stringText);
                st = elementGenerator.createStringLiteralAlreadyEscaped(result);
                string.replace(st);
            }
            if (text2.startsWith("\"") && text2.endsWith("\"")) {
                result = PyQuotedStringIntention.convertDoubleToSingleQuoted(stringText);
                st = elementGenerator.createStringLiteralAlreadyEscaped(result);
                string.replace(st);
            }
        }
    }

    private static String convertDoubleToSingleQuoted(String stringText) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean skipNext = false;
        char[] charArr = stringText.toCharArray();
        for (int i = 0; i != charArr.length; ++i) {
            char ch = charArr[i];
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (ch == '\"') {
                stringBuilder.append('\'');
                continue;
            }
            if (ch == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (ch == '\\' && charArr[i + 1] == '\"' && i + 2 != charArr.length) {
                skipNext = true;
                stringBuilder.append(charArr[i + 1]);
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    private static String convertSingleToDoubleQuoted(String stringText) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean skipNext = false;
        char[] charArr = stringText.toCharArray();
        for (int i = 0; i != charArr.length; ++i) {
            char ch = charArr[i];
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (ch == '\'') {
                stringBuilder.append('\"');
                continue;
            }
            if (ch == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (ch == '\\' && charArr[i + 1] == '\'' && i + 2 != charArr.length) {
                skipNext = true;
                stringBuilder.append(charArr[i + 1]);
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

