/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import git4idea.config.GitExecutable;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public abstract class GitXmlRpcHandlerService<T>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GitXmlRpcHandlerService.class);
    @NotNull
    private final String myScriptTempFilePrefix;
    @NotNull
    private final String myHandlerName;
    @NotNull
    private final Class<? extends GitExternalApp> myScriptMainClass;
    @NotNull
    private final Map<String, File> myScriptPaths;
    @NotNull
    private final Object SCRIPT_FILE_LOCK;
    @NotNull
    private final THashMap<UUID, T> handlers;
    @NotNull
    private final Object HANDLERS_LOCK;

    protected GitXmlRpcHandlerService(@NotNull String prefix, @NotNull String handlerName, @NotNull Class<? extends GitExternalApp> aClass) {
        if (prefix == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(0);
        }
        if (handlerName == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(2);
        }
        this.myScriptPaths = new HashMap<String, File>();
        this.SCRIPT_FILE_LOCK = new Object();
        this.handlers = new THashMap();
        this.HANDLERS_LOCK = new Object();
        this.myScriptTempFilePrefix = prefix;
        this.myHandlerName = handlerName;
        this.myScriptMainClass = aClass;
    }

    public int getXmlRcpPort() {
        return BuiltInServerManager.getInstance().waitForStart().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public File getScriptPath(@NotNull GitExecutable executable, boolean useBatchFile) throws IOException {
        if (executable == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(3);
        }
        Object object = this.SCRIPT_FILE_LOCK;
        // MONITORENTER : object
        String id = executable.getId() + (useBatchFile ? "-bat" : "");
        File scriptPath = this.myScriptPaths.get(id);
        if (scriptPath == null || !scriptPath.exists()) {
            ScriptGenerator generator = new ScriptGenerator(this.myScriptTempFilePrefix + "-" + executable.getId(), this.myScriptMainClass);
            scriptPath = generator.generate(executable, useBatchFile);
            this.myScriptPaths.put(id, scriptPath);
        }
        File file = scriptPath;
        // MONITOREXIT : object
        if (file != null) return file;
        GitXmlRpcHandlerService.$$$reportNull$$$0(4);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public UUID registerHandler(@NotNull T handler) {
        if (handler == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(5);
        }
        Object object = this.HANDLERS_LOCK;
        // MONITORENTER : object
        XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
        if (!xmlRpcServer.hasHandler(this.myHandlerName)) {
            xmlRpcServer.addHandler(this.myHandlerName, this.createRpcRequestHandlerDelegate());
        }
        UUID key = UUID.randomUUID();
        this.handlers.put((Object)key, handler);
        UUID uUID = key;
        // MONITOREXIT : object
        if (uUID != null) return uUID;
        GitXmlRpcHandlerService.$$$reportNull$$$0(6);
        return uUID;
    }

    public void dispose() {
        XmlRpcServer xmlRpcServer = (XmlRpcServer)ApplicationManager.getApplication().getServiceIfCreated(XmlRpcServer.class);
        if (xmlRpcServer != null) {
            xmlRpcServer.removeHandler(this.myHandlerName);
        }
    }

    @NotNull
    protected abstract Object createRpcRequestHandlerDelegate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected T getHandler(UUID key) {
        Object object2 = this.HANDLERS_LOCK;
        // MONITORENTER : object2
        Object rc = this.handlers.get((Object)key);
        if (rc == null) {
            throw new IllegalStateException("No handler for the key " + key);
        }
        Object object = rc;
        // MONITOREXIT : object2
        if (object != null) return (T)object;
        GitXmlRpcHandlerService.$$$reportNull$$$0(7);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(UUID key) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            if (this.handlers.remove((Object)key) == null) {
                LOG.error("The handler " + key + " is not registered");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/git4idea/ssh/GitXmlRpcHandlerService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/git4idea/ssh/GitXmlRpcHandlerService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "registerHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScriptPath";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

