/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryFiles {
    private static final Logger LOG = Logger.getInstance(GitRepositoryFiles.class);
    public static final String GITIGNORE = ".gitignore";
    private static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    public static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    private static final String CONFIG = "config";
    private static final String HEAD = "HEAD";
    private static final String INDEX = "index";
    private static final String INFO = "info";
    private static final String INFO_EXCLUDE = "info/exclude";
    private static final String MERGE_HEAD = "MERGE_HEAD";
    private static final String MERGE_MSG = "MERGE_MSG";
    private static final String ORIG_HEAD = "ORIG_HEAD";
    private static final String REBASE_APPLY = "rebase-apply";
    private static final String REBASE_MERGE = "rebase-merge";
    private static final String PACKED_REFS = "packed-refs";
    private static final String REFS = "refs";
    private static final String REVERT_HEAD = "REVERT_HEAD";
    private static final String HEADS = "heads";
    private static final String TAGS = "tags";
    private static final String REMOTES = "remotes";
    private static final String SQUASH_MSG = "SQUASH_MSG";
    private static final String HOOKS = "hooks";
    private static final String PRE_COMMIT_HOOK = "pre-commit";
    private static final String PRE_PUSH_HOOK = "pre-push";
    private static final String COMMIT_MSG_HOOK = "commit-msg";
    private static final String SHALLOW = "shallow";
    private final VirtualFile myMainDir;
    private final VirtualFile myWorktreeDir;
    private final String myConfigFilePath;
    private final String myHeadFilePath;
    private final String myIndexFilePath;
    private final String myMergeHeadPath;
    private final String myCherryPickHeadPath;
    private final String myRevertHeadPath;
    private final String myOrigHeadPath;
    private final String myRebaseApplyPath;
    private final String myRebaseMergePath;
    private final String myPackedRefsPath;
    private final String myRefsHeadsDirPath;
    private final String myRefsRemotesDirPath;
    private final String myRefsTagsPath;
    private final String myCommitMessagePath;
    private final String myMergeMessagePath;
    private final String myMergeSquashPath;
    private final String myInfoDirPath;
    private final String myExcludePath;
    private final String myHooksDirPath;
    private final String myShallow;

    private GitRepositoryFiles(@NotNull VirtualFile mainDir, @NotNull VirtualFile worktreeDir) {
        if (mainDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(0);
        }
        if (worktreeDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(1);
        }
        this.myMainDir = mainDir;
        this.myWorktreeDir = worktreeDir;
        String mainPath = this.myMainDir.getPath();
        this.myConfigFilePath = mainPath + GitRepositoryFiles.slash(CONFIG);
        this.myPackedRefsPath = mainPath + GitRepositoryFiles.slash(PACKED_REFS);
        String refsPath = mainPath + GitRepositoryFiles.slash(REFS);
        this.myRefsHeadsDirPath = refsPath + GitRepositoryFiles.slash(HEADS);
        this.myRefsTagsPath = refsPath + GitRepositoryFiles.slash(TAGS);
        this.myRefsRemotesDirPath = refsPath + GitRepositoryFiles.slash(REMOTES);
        this.myInfoDirPath = mainPath + GitRepositoryFiles.slash(INFO);
        this.myExcludePath = mainPath + GitRepositoryFiles.slash(INFO_EXCLUDE);
        this.myHooksDirPath = mainPath + GitRepositoryFiles.slash(HOOKS);
        this.myShallow = mainPath + GitRepositoryFiles.slash(SHALLOW);
        String worktreePath = this.myWorktreeDir.getPath();
        this.myHeadFilePath = worktreePath + GitRepositoryFiles.slash(HEAD);
        this.myIndexFilePath = worktreePath + GitRepositoryFiles.slash(INDEX);
        this.myMergeHeadPath = worktreePath + GitRepositoryFiles.slash(MERGE_HEAD);
        this.myCherryPickHeadPath = worktreePath + GitRepositoryFiles.slash(CHERRY_PICK_HEAD);
        this.myRevertHeadPath = worktreePath + GitRepositoryFiles.slash(REVERT_HEAD);
        this.myOrigHeadPath = worktreePath + GitRepositoryFiles.slash(ORIG_HEAD);
        this.myCommitMessagePath = worktreePath + GitRepositoryFiles.slash(COMMIT_EDITMSG);
        this.myMergeMessagePath = worktreePath + GitRepositoryFiles.slash(MERGE_MSG);
        this.myMergeSquashPath = worktreePath + GitRepositoryFiles.slash(SQUASH_MSG);
        this.myRebaseApplyPath = worktreePath + GitRepositoryFiles.slash(REBASE_APPLY);
        this.myRebaseMergePath = worktreePath + GitRepositoryFiles.slash(REBASE_MERGE);
    }

    @NotNull
    public static GitRepositoryFiles getInstance(@NotNull VirtualFile gitDir) {
        VirtualFile gitDirForWorktree;
        if (gitDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(2);
        }
        VirtualFile mainDir = (gitDirForWorktree = GitRepositoryFiles.getMainGitDirForWorktree(gitDir)) == null ? gitDir : gitDirForWorktree;
        return new GitRepositoryFiles(mainDir, gitDir);
    }

    @Nullable
    private static VirtualFile getMainGitDirForWorktree(@NotNull VirtualFile gitDir) {
        String pathToMain;
        File gitDirFile;
        File commonDir;
        if (gitDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(3);
        }
        if (!(commonDir = new File(gitDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)gitDir), "commondir")).exists()) {
            return null;
        }
        try {
            pathToMain = FileUtil.loadFile((File)commonDir).trim();
        }
        catch (IOException e) {
            LOG.error("Couldn't load " + commonDir, (Throwable)e);
            return null;
        }
        String mainDir = FileUtil.toCanonicalPath((String)(gitDirFile.getPath() + File.separator + pathToMain), (boolean)true);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile mainDirVF = lfs.refreshAndFindFileByPath(mainDir);
        if (mainDirVF != null) {
            return mainDirVF;
        }
        return lfs.refreshAndFindFileByPath(pathToMain);
    }

    @NotNull
    private static String slash(@NotNull String s) {
        if (s == null) {
            GitRepositoryFiles.$$$reportNull$$$0(4);
        }
        String string = "/" + s;
        if (string == null) {
            GitRepositoryFiles.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    Collection<String> getDirsToWatch() {
        List<String> list = Arrays.asList(this.myRefsHeadsDirPath, this.myRefsRemotesDirPath, this.myRefsTagsPath, this.myInfoDirPath, this.myHooksDirPath);
        if (list == null) {
            GitRepositoryFiles.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    File getRefsHeadsFile() {
        return GitRepositoryFiles.file(this.myRefsHeadsDirPath);
    }

    @NotNull
    File getRefsRemotesFile() {
        return GitRepositoryFiles.file(this.myRefsRemotesDirPath);
    }

    @NotNull
    File getRefsTagsFile() {
        return GitRepositoryFiles.file(this.myRefsTagsPath);
    }

    @NotNull
    File getPackedRefsPath() {
        return GitRepositoryFiles.file(this.myPackedRefsPath);
    }

    @NotNull
    public File getHeadFile() {
        return GitRepositoryFiles.file(this.myHeadFilePath);
    }

    @NotNull
    File getConfigFile() {
        return GitRepositoryFiles.file(this.myConfigFilePath);
    }

    @NotNull
    public File getRebaseMergeDir() {
        return GitRepositoryFiles.file(this.myRebaseMergePath);
    }

    @NotNull
    public File getRebaseApplyDir() {
        return GitRepositoryFiles.file(this.myRebaseApplyPath);
    }

    @NotNull
    public File getMergeHeadFile() {
        return GitRepositoryFiles.file(this.myMergeHeadPath);
    }

    @NotNull
    public File getCherryPickHead() {
        return GitRepositoryFiles.file(this.myCherryPickHeadPath);
    }

    @NotNull
    public File getRevertHead() {
        return GitRepositoryFiles.file(this.myRevertHeadPath);
    }

    @NotNull
    public File getMergeMessageFile() {
        return GitRepositoryFiles.file(this.myMergeMessagePath);
    }

    @NotNull
    public File getSquashMessageFile() {
        return GitRepositoryFiles.file(this.myMergeSquashPath);
    }

    @NotNull
    public File getPreCommitHookFile() {
        return GitRepositoryFiles.file(this.myHooksDirPath + GitRepositoryFiles.slash(PRE_COMMIT_HOOK));
    }

    @NotNull
    public File getPrePushHookFile() {
        return GitRepositoryFiles.file(this.myHooksDirPath + GitRepositoryFiles.slash(PRE_PUSH_HOOK));
    }

    @NotNull
    public File getCommitMsgHookFile() {
        return GitRepositoryFiles.file(this.myHooksDirPath + GitRepositoryFiles.slash(COMMIT_MSG_HOOK));
    }

    @NotNull
    public File getShallowFile() {
        return GitRepositoryFiles.file(this.myShallow);
    }

    @NotNull
    public File getExcludeFile() {
        return GitRepositoryFiles.file(this.myExcludePath);
    }

    @NotNull
    private static File file(@NotNull String filePath) {
        if (filePath == null) {
            GitRepositoryFiles.$$$reportNull$$$0(7);
        }
        return new File(FileUtil.toSystemDependentName((String)filePath));
    }

    public boolean isConfigFile(String filePath) {
        return filePath.equals(this.myConfigFilePath);
    }

    public boolean isIndexFile(String filePath) {
        return filePath.equals(this.myIndexFilePath);
    }

    public boolean isHeadFile(String file) {
        return file.equals(this.myHeadFilePath);
    }

    public boolean isOrigHeadFile(@NotNull String file) {
        if (file == null) {
            GitRepositoryFiles.$$$reportNull$$$0(8);
        }
        return file.equals(this.myOrigHeadPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsHeadsDirPath);
    }

    public boolean isBranchFile(@NotNull String filePath, @NotNull String fullBranchName) {
        if (filePath == null) {
            GitRepositoryFiles.$$$reportNull$$$0(9);
        }
        if (fullBranchName == null) {
            GitRepositoryFiles.$$$reportNull$$$0(10);
        }
        return FileUtil.pathsEqual((String)filePath, (String)(this.myMainDir.getPath() + GitRepositoryFiles.slash(fullBranchName)));
    }

    public boolean isRemoteBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsRemotesDirPath);
    }

    public boolean isTagFile(@NotNull String path) {
        if (path == null) {
            GitRepositoryFiles.$$$reportNull$$$0(11);
        }
        return path.startsWith(this.myRefsTagsPath);
    }

    public boolean isRebaseFile(String path) {
        return path.equals(this.myRebaseApplyPath) || path.equals(this.myRebaseMergePath);
    }

    public boolean isMergeFile(String file) {
        return file.equals(this.myMergeHeadPath);
    }

    public boolean isPackedRefs(String file) {
        return file.equals(this.myPackedRefsPath);
    }

    public boolean isCommitMessageFile(@NotNull String file) {
        if (file == null) {
            GitRepositoryFiles.$$$reportNull$$$0(12);
        }
        return file.equals(this.myCommitMessagePath);
    }

    public boolean isExclude(@NotNull String path) {
        if (path == null) {
            GitRepositoryFiles.$$$reportNull$$$0(13);
        }
        return path.equals(this.myExcludePath);
    }

    public void refresh() {
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myMainDir, this.myWorktreeDir});
    }

    public void refreshIndexFile() {
        VirtualFile indexFilePath = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myIndexFilePath);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{indexFilePath});
    }

    public void refreshTagsFiles() {
        VirtualFile tagsDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myRefsTagsPath);
        VirtualFile packedRefsFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPackedRefsPath);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{tagsDir, packedRefsFile});
    }

    @NotNull
    Collection<VirtualFile> getRootDirs() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new VirtualFile[]{this.myMainDir, this.myWorktreeDir});
        if (hashSet == null) {
            GitRepositoryFiles.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worktreeDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryFiles";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullBranchName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "slash";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirsToWatch";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMainGitDirForWorktree";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "slash";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "file";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOrigHeadFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isBranchFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTagFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCommitMessageFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isExclude";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

