/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.history.GitHistoryUtils;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitDefaultMergeDialogCustomizer$WhenMappings;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.RefInfo;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/merge/GitDefaultMergeDialogCustomizer;", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getCherryPickTitleCustomizerList", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "repository", "Lgit4idea/repo/GitRepository;", "file", "Lcom/intellij/openapi/vcs/FilePath;", "getMergeTitleCustomizerList", "getMultipleFileMergeDescription", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRebaseTitleCustomizerList", "getTitleCustomizerList", "loadCherryPickCommitDetails", "Lgit4idea/merge/GitDefaultMergeDialogCustomizer$CherryPickDetails;", "CherryPickDetails", "intellij.vcs.git"})
public class GitDefaultMergeDialogCustomizer
extends MergeDialogCustomizer {
    private final Project project;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
        void $this$mapNotNullTo$iv$iv;
        Object element$iv$iv$iv3;
        void $this$mapNotNullTo$iv$iv2;
        boolean bl;
        void $this$mapNotNullTo$iv$iv3;
        Collection collection;
        Object it;
        Iterable $this$filter$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Collection collection2 = GitUtil.getRepositoriesForFiles(this.project, files);
        boolean bl2 = false;
        if (collection2.isEmpty()) {
            void $this$filterTo$iv$iv;
            boolean bl3 = false;
            Collection<GitRepository> collection3 = GitUtil.getRepositories(this.project);
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"getRepositories(project)");
            $this$filter$iv = collection3;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GitRepository)element$iv$iv;
                boolean bl4 = false;
                GitRepository gitRepository = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"it");
                GitStagingAreaHolder gitStagingAreaHolder = gitRepository.getStagingAreaHolder();
                Intrinsics.checkExpressionValueIsNotNull((Object)gitStagingAreaHolder, (String)"it.stagingAreaHolder");
                List<GitConflict> list = gitStagingAreaHolder.getAllConflicts();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.stagingAreaHolder.allConflicts");
                Collection collection4 = list;
                boolean bl5 = false;
                if (!(!collection4.isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = collection2;
        }
        Collection repos = collection;
        Iterable $this$mapNotNull$iv = repos;
        boolean $i$f$mapNotNull = false;
        $this$filter$iv = $this$mapNotNull$iv;
        Iterable<String> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            String string;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl6 = false;
            GitRepository it2 = (GitRepository)element$iv$iv;
            boolean bl7 = false;
            GitRepository gitRepository = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"it");
            RefInfo refInfo = GitDefaultMergeDialogCustomizerKt.access$resolveMergeBranch(gitRepository);
            if ((refInfo != null ? refInfo.getPresentable() : null) == null) continue;
            string = string;
            boolean bl8 = false;
            bl = false;
            String it$iv$iv = string;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set mergeBranches = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$mapNotNull$iv = mergeBranches;
        $i$f$mapNotNull = false;
        if (!$this$mapNotNull$iv.isEmpty()) {
            Set currentBranches = GitDefaultMergeDialogCustomizerKt.access$getCurrentBranchNameSet(repos);
            String string = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("merge.dialog.description.merge.label.text", mergeBranches.size(), XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)((String)CollectionsKt.first((Iterable)mergeBranches))), (String)"b"), currentBranches.size(), XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)((String)CollectionsKt.first((Iterable)currentBranches))), (String)"b")));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"wrapInHtml(\n        GitB\u2026), \"b\")\n        )\n      )");
            return string;
        }
        Iterable $this$mapNotNull$iv2 = repos;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Iterable<RefInfo> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv$iv3 : $this$forEach$iv$iv$iv2) {
            RefInfo refInfo;
            Object element$iv$iv = element$iv$iv$iv3;
            boolean bl10 = false;
            GitRepository it3 = (GitRepository)element$iv$iv;
            boolean bl11 = false;
            GitRepository gitRepository = it3;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"it");
            if (GitDefaultMergeDialogCustomizerKt.access$resolveRebaseOntoBranch(gitRepository) == null) continue;
            bl = false;
            boolean bl12 = false;
            RefInfo it$iv$iv = refInfo;
            boolean bl13 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List rebaseOntoBranches = (List)destination$iv$iv2;
        $this$mapNotNull$iv2 = rebaseOntoBranches;
        $i$f$mapNotNull2 = false;
        if (!$this$mapNotNull$iv2.isEmpty()) {
            RefInfo singleOntoBranch;
            String singleCurrentBranch = GitDefaultMergeDialogCustomizerKt.getSingleCurrentBranchName(repos);
            RefInfo refInfo = singleOntoBranch = (RefInfo)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)rebaseOntoBranches));
            RefInfo refInfo2 = singleOntoBranch;
            return GitDefaultMergeDialogCustomizerKt.getDescriptionForRebase(singleCurrentBranch, refInfo != null ? refInfo.getBranchName() : null, (Hash)(refInfo2 != null ? refInfo2.getHash() : null));
        }
        Iterable $this$mapNotNull$iv3 = repos;
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv2 = $this$mapNotNull$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        element$iv$iv$iv3 = $this$forEach$iv$iv$iv3.iterator();
        while (element$iv$iv$iv3.hasNext()) {
            CherryPickDetails cherryPickDetails;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = element$iv$iv$iv3.next();
            boolean bl14 = false;
            GitRepository it4 = (GitRepository)element$iv$iv;
            boolean bl15 = false;
            GitRepository gitRepository = it4;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"it");
            if (this.loadCherryPickCommitDetails(gitRepository) == null) continue;
            boolean bl16 = false;
            boolean bl17 = false;
            CherryPickDetails it$iv$iv = cherryPickDetails;
            boolean bl18 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List cherryPickCommitDetails = (List)destination$iv$iv3;
        $this$mapNotNull$iv3 = cherryPickCommitDetails;
        $i$f$mapNotNull3 = false;
        if (!$this$mapNotNull$iv3.isEmpty()) {
            Iterable $this$distinctBy$iv = cherryPickCommitDetails;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                it = (CherryPickDetails)e$iv;
                boolean bl19 = false;
                String key$iv = ((CherryPickDetails)it).getAuthorName() + ((CherryPickDetails)it).getCommitMessage();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            CherryPickDetails singleCherryPick = (CherryPickDetails)CollectionsKt.singleOrNull((List)list$iv);
            Object[] objectArray = new Object[5];
            objectArray[0] = cherryPickCommitDetails.size();
            objectArray[1] = XmlStringUtil.wrapInHtmlTag((String)((CherryPickDetails)CollectionsKt.single((List)cherryPickCommitDetails)).getShortHash(), (String)"code");
            objectArray[2] = GitDefaultMergeDialogCustomizerKt.access$toInt(singleCherryPick != null);
            CherryPickDetails cherryPickDetails = singleCherryPick;
            objectArray[3] = XmlStringUtil.escapeString((String)(cherryPickDetails != null ? cherryPickDetails.getAuthorName() : null));
            CherryPickDetails cherryPickDetails2 = singleCherryPick;
            objectArray[4] = "<br/>" + XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)(cherryPickDetails2 != null ? cherryPickDetails2.getCommitMessage() : null)), (String)"code");
            String string = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("merge.dialog.description.cherry.pick.label.text", objectArray));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"wrapInHtml(\n        GitB\u2026\"code\")\n        )\n      )");
            return string;
        }
        return super.getMultipleFileMergeDescription(files);
    }

    @NotNull
    public MergeDialogCustomizer.DiffEditorTitleCustomizerList getTitleCustomizerList(@NotNull FilePath file) {
        MergeDialogCustomizer.DiffEditorTitleCustomizerList diffEditorTitleCustomizerList;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFileQuick(file);
        if (gitRepository == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"GitRepositoryManager.get\u2026n DEFAULT_CUSTOMIZER_LIST");
        GitRepository repository = gitRepository;
        switch (GitDefaultMergeDialogCustomizer$WhenMappings.$EnumSwitchMapping$0[repository.getState().ordinal()]) {
            case 1: {
                diffEditorTitleCustomizerList = this.getMergeTitleCustomizerList(repository, file);
                break;
            }
            case 2: {
                diffEditorTitleCustomizerList = this.getRebaseTitleCustomizerList(repository, file);
                break;
            }
            case 3: {
                diffEditorTitleCustomizerList = this.getCherryPickTitleCustomizerList(repository, file);
                break;
            }
            default: {
                diffEditorTitleCustomizerList = MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
            }
        }
        return diffEditorTitleCustomizerList;
    }

    private final MergeDialogCustomizer.DiffEditorTitleCustomizerList getCherryPickTitleCustomizerList(GitRepository repository, FilePath file) {
        Hash hash = GitDefaultMergeDialogCustomizerKt.access$tryResolveRef(repository, "CHERRY_PICK_HEAD");
        if (hash == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        Hash cherryPickHead = hash;
        Object object = GitHistoryUtils.getMergeBase(repository.getProject(), repository.getRoot(), "CHERRY_PICK_HEAD", "HEAD");
        if (object == null || (object = ((GitRevisionNumber)object).getRev()) == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GitHistoryUtils.getMerge\u2026n DEFAULT_CUSTOMIZER_LIST");
        Object mergeBase = object;
        String string = GitBundle.getString("merge.dialog.diff.left.title.cherry.pick.label.text");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.getString(\"mer\u2026.cherry.pick.label.text\")");
        DiffEditorTitleCustomizer leftTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(string, repository, file, (Pair<String, String>)new Pair(mergeBase, (Object)"HEAD"));
        String string2 = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("merge.dialog.diff.right.title.cherry.pick.label.text", cherryPickHead.toShortString()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"wrapInHtml(GitBundle.mes\u2026ickHead.toShortString()))");
        String string3 = cherryPickHead.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"cherryPickHead.asString()");
        DiffEditorTitleCustomizer rightTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer(string2, repository, file, string3);
        return new MergeDialogCustomizer.DiffEditorTitleCustomizerList(leftTitleCustomizer, null, rightTitleCustomizer);
    }

    private final MergeDialogCustomizer.DiffEditorTitleCustomizerList getMergeTitleCustomizerList(GitRepository repository, FilePath file) {
        Hash hash = GitUtil.getHead(repository);
        if (hash == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"getHead(repository) ?: r\u2026n DEFAULT_CUSTOMIZER_LIST");
        Hash currentBranchHash = hash;
        String string = repository.getCurrentBranchName();
        if (string == null) {
            string = currentBranchHash.toShortString();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repository.currentBranch\u2026ranchHash.toShortString()");
        String currentBranchPresentable = string;
        RefInfo refInfo = GitDefaultMergeDialogCustomizerKt.access$resolveMergeBranch(repository);
        if (refInfo == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        RefInfo mergeBranch = refInfo;
        Hash mergeBranchHash = mergeBranch.getHash();
        Object object = GitHistoryUtils.getMergeBase(repository.getProject(), repository.getRoot(), currentBranchHash.asString(), mergeBranchHash.asString());
        if (object == null || (object = ((GitRevisionNumber)object).getRev()) == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GitHistoryUtils.getMerge\u2026n DEFAULT_CUSTOMIZER_LIST");
        Object mergeBase = object;
        getMergeTitleCustomizerList.1 $fun$getChangesFromBranchTitle$1 = getMergeTitleCustomizerList.1.INSTANCE;
        DiffEditorTitleCustomizer leftTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer($fun$getChangesFromBranchTitle$1.invoke(currentBranchPresentable), repository, file, (Pair<String, String>)new Pair(mergeBase, (Object)currentBranchHash.asString()));
        DiffEditorTitleCustomizer rightTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer($fun$getChangesFromBranchTitle$1.invoke(mergeBranch.getPresentable()), repository, file, (Pair<String, String>)new Pair(mergeBase, (Object)mergeBranchHash.asString()));
        return new MergeDialogCustomizer.DiffEditorTitleCustomizerList(leftTitleCustomizer, null, rightTitleCustomizer);
    }

    private final MergeDialogCustomizer.DiffEditorTitleCustomizerList getRebaseTitleCustomizerList(GitRepository repository, FilePath file) {
        Hash hash = GitUtil.getHead(repository);
        if (hash == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"getHead(repository) ?: r\u2026n DEFAULT_CUSTOMIZER_LIST");
        Hash currentBranchHash = hash;
        String string = repository.getCurrentBranchName();
        if (string == null) {
            string = currentBranchHash.toShortString();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repository.currentBranch\u2026ranchHash.toShortString()");
        String rebasingBranchPresentable = string;
        RefInfo refInfo = GitDefaultMergeDialogCustomizerKt.access$resolveRebaseOntoBranch(repository);
        if (refInfo == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        RefInfo upstreamBranch = refInfo;
        Hash upstreamBranchHash = upstreamBranch.getHash();
        Hash hash2 = GitDefaultMergeDialogCustomizerKt.access$tryResolveRef(repository, "REBASE_HEAD");
        if (hash2 == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        Hash rebaseHead = hash2;
        Object object = GitHistoryUtils.getMergeBase(repository.getProject(), repository.getRoot(), "REBASE_HEAD", upstreamBranchHash.asString());
        if (object == null || (object = ((GitRevisionNumber)object).getRev()) == null) {
            return MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GitHistoryUtils.getMerge\u2026n DEFAULT_CUSTOMIZER_LIST");
        Object mergeBase = object;
        String string2 = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("merge.dialog.diff.left.title.rebase.label.text", rebaseHead.toShortString(), XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)rebasingBranchPresentable), (String)"b")));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"wrapInHtml(\n      GitBun\u2026able), \"b\")\n      )\n    )");
        String leftTitle = string2;
        String string3 = rebaseHead.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"rebaseHead.asString()");
        DiffEditorTitleCustomizer leftTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer(leftTitle, repository, file, string3);
        String string4 = XmlStringUtil.wrapInHtml((CharSequence)(upstreamBranch.getBranchName() != null ? GitBundle.message("merge.dialog.diff.right.title.rebase.with.branch.label.text", XmlStringUtil.wrapInHtmlTag((String)upstreamBranch.getBranchName(), (String)"b")) : GitBundle.getString("merge.dialog.diff.right.title.rebase.without.branch.label.text")));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"wrapInHtml(\n      if (up\u2026abel.text\")\n      }\n    )");
        String rightTitle = string4;
        DiffEditorTitleCustomizer rightTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(rightTitle, repository, file, (Pair<String, String>)new Pair(mergeBase, (Object)"HEAD"));
        return new MergeDialogCustomizer.DiffEditorTitleCustomizerList(leftTitleCustomizer, null, rightTitleCustomizer);
    }

    private final CherryPickDetails loadCherryPickCommitDetails(GitRepository repository) {
        Hash hash = GitDefaultMergeDialogCustomizerKt.access$tryResolveRef(repository, "CHERRY_PICK_HEAD");
        if (hash == null) {
            return null;
        }
        Hash cherryPickHead = hash;
        List<? extends VcsCommitMetadata> list = GitLogUtil.collectMetadata(this.project, GitVcs.getInstance(this.project), repository.getRoot(), CollectionsKt.listOf((Object)cherryPickHead.asString()));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"GitLogUtil.collectMetada\u2026erryPickHead.asString()))");
        List<? extends VcsCommitMetadata> shortDetails = list;
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)CollectionsKt.singleOrNull(shortDetails);
        if (vcsCommitMetadata == null) {
            return null;
        }
        VcsCommitMetadata result2 = vcsCommitMetadata;
        String string = cherryPickHead.toShortString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cherryPickHead.toShortString()");
        VcsUser vcsUser = result2.getAuthor();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsUser, (String)"result.author");
        String string2 = vcsUser.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.author.name");
        String string3 = result2.getSubject();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"result.subject");
        return new CherryPickDetails(string, string2, string3);
    }

    public GitDefaultMergeDialogCustomizer(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lgit4idea/merge/GitDefaultMergeDialogCustomizer$CherryPickDetails;", "", "shortHash", "", "authorName", "commitMessage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAuthorName", "()Ljava/lang/String;", "getCommitMessage", "getShortHash", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class CherryPickDetails {
        @NotNull
        private final String shortHash;
        @NotNull
        private final String authorName;
        @NotNull
        private final String commitMessage;

        @NotNull
        public final String getShortHash() {
            return this.shortHash;
        }

        @NotNull
        public final String getAuthorName() {
            return this.authorName;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        public CherryPickDetails(@NotNull String shortHash, @NotNull String authorName, @NotNull String commitMessage) {
            Intrinsics.checkParameterIsNotNull((Object)shortHash, (String)"shortHash");
            Intrinsics.checkParameterIsNotNull((Object)authorName, (String)"authorName");
            Intrinsics.checkParameterIsNotNull((Object)commitMessage, (String)"commitMessage");
            this.shortHash = shortHash;
            this.authorName = authorName;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final String component1() {
            return this.shortHash;
        }

        @NotNull
        public final String component2() {
            return this.authorName;
        }

        @NotNull
        public final String component3() {
            return this.commitMessage;
        }

        @NotNull
        public final CherryPickDetails copy(@NotNull String shortHash, @NotNull String authorName, @NotNull String commitMessage) {
            Intrinsics.checkParameterIsNotNull((Object)shortHash, (String)"shortHash");
            Intrinsics.checkParameterIsNotNull((Object)authorName, (String)"authorName");
            Intrinsics.checkParameterIsNotNull((Object)commitMessage, (String)"commitMessage");
            return new CherryPickDetails(shortHash, authorName, commitMessage);
        }

        public static /* synthetic */ CherryPickDetails copy$default(CherryPickDetails cherryPickDetails, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = cherryPickDetails.shortHash;
            }
            if ((n & 2) != 0) {
                string2 = cherryPickDetails.authorName;
            }
            if ((n & 4) != 0) {
                string3 = cherryPickDetails.commitMessage;
            }
            return cherryPickDetails.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "CherryPickDetails(shortHash=" + this.shortHash + ", authorName=" + this.authorName + ", commitMessage=" + this.commitMessage + ")";
        }

        public int hashCode() {
            String string = this.shortHash;
            String string2 = this.authorName;
            String string3 = this.commitMessage;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CherryPickDetails)) break block3;
                    CherryPickDetails cherryPickDetails = (CherryPickDetails)object;
                    if (!Intrinsics.areEqual((Object)this.shortHash, (Object)cherryPickDetails.shortHash) || !Intrinsics.areEqual((Object)this.authorName, (Object)cherryPickDetails.authorName) || !Intrinsics.areEqual((Object)this.commitMessage, (Object)cherryPickDetails.commitMessage)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

