/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitRepositoryAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GitRepositoryAction.$$$reportNull$$$0(0);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs vcs = GitVcs.getInstance(project);
        List<VirtualFile> roots = GitRepositoryAction.getGitRoots(project, vcs);
        if (roots == null) {
            return;
        }
        VirtualFile defaultRoot = GitRepositoryAction.getDefaultRoot(project, roots, (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        this.perform(project, roots, defaultRoot);
    }

    @NotNull
    private static VirtualFile getDefaultRoot(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, VirtualFile @Nullable [] vFiles) {
        GitRepository currentRepository;
        if (project == null) {
            GitRepositoryAction.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            GitRepositoryAction.$$$reportNull$$$0(2);
        }
        if (vFiles != null) {
            for (VirtualFile file : vFiles) {
                GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(file);
                if (repository == null) continue;
                VirtualFile virtualFile = repository.getRoot();
                if (virtualFile == null) {
                    GitRepositoryAction.$$$reportNull$$$0(3);
                }
                return virtualFile;
            }
        }
        VirtualFile virtualFile = (currentRepository = GitBranchUtil.getCurrentRepository(project)) != null ? currentRepository.getRoot() : roots.get(0);
        if (virtualFile == null) {
            GitRepositoryAction.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Deprecated
    protected boolean executeFinalTasksSynchronously() {
        return true;
    }

    @Nullable
    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) {
        try {
            Object[] contentRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
            if (ArrayUtil.isEmpty((Object[])contentRoots)) {
                throw new VcsException(GitBundle.getString("repository.action.missing.roots.unconfigured.message"));
            }
            Collection<GitRepository> repositories = GitUtil.getRepositories(project);
            if (repositories.isEmpty()) {
                throw new VcsException(GitBundle.getString("repository.action.missing.roots.misconfigured"));
            }
            return DvcsUtil.sortVirtualFilesByPresentation(GitUtil.getRootsFromRepositories(repositories));
        }
        catch (VcsException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)GitBundle.getString("repository.action.missing.roots.title"));
            return null;
        }
    }

    @NotNull
    protected abstract String getActionName();

    protected abstract void perform(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitRepositoryAction.$$$reportNull$$$0(5);
        }
        super.update(e);
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
    }

    protected boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        return roots != null && roots.length != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitRepositoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitRepositoryAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRoot";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

