/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.ArrayUtil;
import com.intellij.util.JBIterableClassTraverser;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaMethodSignature {
    private static final Set<String> OBJECT_METHOD_NAMES = ContainerUtil.map2Set((Object[])Object.class.getDeclaredMethods(), Method::getName);
    private final String myMethodName;
    private final Class<?>[] myMethodParameters;

    public JavaMethodSignature(String methodName, Class<?> ... methodParameters) {
        this.myMethodName = methodName;
        this.myMethodParameters = methodParameters.length == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : methodParameters;
    }

    public JavaMethodSignature(@NotNull Method method) {
        if (method == null) {
            JavaMethodSignature.$$$reportNull$$$0(0);
        }
        this.myMethodName = method.getName();
        this.myMethodParameters = method.getParameterCount() == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : method.getParameterTypes();
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    @Nullable
    public final Method findMethod(@NotNull Class<?> aClass) {
        Method method;
        if (aClass == null) {
            JavaMethodSignature.$$$reportNull$$$0(1);
        }
        if ((method = this.getDeclaredMethod(aClass)) == null && aClass.isInterface() && OBJECT_METHOD_NAMES.contains(this.myMethodName)) {
            method = ReflectionUtil.getDeclaredMethod(Object.class, (String)this.myMethodName, (Class[])this.myMethodParameters);
        }
        return method;
    }

    @Nullable
    private Method getDeclaredMethod(@NotNull Class<?> aClass) {
        Method method;
        if (aClass == null) {
            JavaMethodSignature.$$$reportNull$$$0(2);
        }
        return (method = ReflectionUtil.getMethod(aClass, (String)this.myMethodName, (Class[])this.myMethodParameters)) == null ? ReflectionUtil.getDeclaredMethod(aClass, (String)this.myMethodName, (Class[])this.myMethodParameters) : method;
    }

    @NotNull
    List<Method> getAllMethods(@NotNull Class<?> startFrom) {
        if (startFrom == null) {
            JavaMethodSignature.$$$reportNull$$$0(3);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class superClass : JBIterable.from((Iterable)JBIterableClassTraverser.classTraverser(startFrom)).append(Object.class).unique()) {
            for (Method method : superClass.getDeclaredMethods()) {
                if (!this.myMethodName.equals(method.getName()) || method.getParameterCount() != this.myMethodParameters.length || !Arrays.equals(method.getParameterTypes(), this.myMethodParameters)) continue;
                result.add(method);
            }
        }
        ArrayList<Method> arrayList = result;
        if (arrayList == null) {
            JavaMethodSignature.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    static Method findMethod(@NotNull Method sampleMethod, @NotNull Class<?> startFrom, @NotNull Predicate<Method> checker) {
        if (sampleMethod == null) {
            JavaMethodSignature.$$$reportNull$$$0(5);
        }
        if (startFrom == null) {
            JavaMethodSignature.$$$reportNull$$$0(6);
        }
        if (checker == null) {
            JavaMethodSignature.$$$reportNull$$$0(7);
        }
        String sampleMethodName = sampleMethod.getName();
        Object[] sampleMethodParameters = sampleMethod.getParameterCount() == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : sampleMethod.getParameterTypes();
        for (Class superClass : JBIterable.from((Iterable)JBIterableClassTraverser.classTraverser(startFrom)).append(Object.class).unique()) {
            for (Method method : superClass.getDeclaredMethods()) {
                if (!sampleMethodName.equals(method.getName()) || method.getParameterCount() != sampleMethodParameters.length || !Arrays.equals(method.getParameterTypes(), sampleMethodParameters) || !checker.test(method)) continue;
                return method;
            }
        }
        return null;
    }

    public String toString() {
        return this.myMethodName + Arrays.asList(this.myMethodParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethodSignature that = (JavaMethodSignature)o;
        if (!this.myMethodName.equals(that.myMethodName)) {
            return false;
        }
        return Arrays.equals(this.myMethodParameters, that.myMethodParameters);
    }

    public int hashCode() {
        int result = this.myMethodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.myMethodParameters);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFrom";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/JavaMethodSignature";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/JavaMethodSignature";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethods";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

