/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SingletonIteratorBase;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartHashSet<T>
extends THashSet<T> {
    private T theElement;

    public SmartHashSet() {
    }

    public SmartHashSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            SmartHashSet.$$$reportNull$$$0(0);
        }
        super(strategy);
    }

    public SmartHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public SmartHashSet(int initialCapacity, @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            SmartHashSet.$$$reportNull$$$0(1);
        }
        super(initialCapacity, strategy);
    }

    public SmartHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SmartHashSet(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            SmartHashSet.$$$reportNull$$$0(2);
        }
        super(initialCapacity, loadFactor, strategy);
    }

    public SmartHashSet(@NotNull @NotNull Collection<? extends @NotNull T> collection) {
        if (collection == null) {
            SmartHashSet.$$$reportNull$$$0(3);
        }
        this(collection, ContainerUtil.canonicalStrategy());
    }

    public SmartHashSet(@NotNull @NotNull Collection<? extends @NotNull T> collection, @NotNull TObjectHashingStrategy<T> strategy) {
        if (collection == null) {
            SmartHashSet.$$$reportNull$$$0(4);
        }
        if (strategy == null) {
            SmartHashSet.$$$reportNull$$$0(5);
        }
        super(collection.size() == 1 ? Collections.emptyList() : collection, strategy);
        if (collection.size() == 1) {
            T element = collection.iterator().next();
            if (element == null) {
                throw new IllegalArgumentException("Null elements are not permitted but got: " + collection);
            }
            this.theElement = element;
        }
    }

    public boolean contains(@NotNull Object obj) {
        T theElement;
        if (obj == null) {
            SmartHashSet.$$$reportNull$$$0(6);
        }
        if ((theElement = this.theElement) != null) {
            return this.eq(theElement, obj);
        }
        return !super.isEmpty() && super.contains(obj);
    }

    public boolean add(@NotNull T obj) {
        T theElement;
        if (obj == null) {
            SmartHashSet.$$$reportNull$$$0(7);
        }
        if ((theElement = this.theElement) != null) {
            if (this.eq(theElement, obj)) {
                return false;
            }
            super.add(theElement);
            this.theElement = null;
        } else if (super.isEmpty()) {
            this.theElement = obj;
            return true;
        }
        return super.add(obj);
    }

    private boolean eq(T obj, T theElement) {
        return theElement == obj || this._hashingStrategy.equals(theElement, obj);
    }

    public boolean equals(@Nullable Object other) {
        T theElement = this.theElement;
        if (theElement != null) {
            return other instanceof Set && ((Set)other).size() == 1 && this.eq(theElement, ((Set)other).iterator().next());
        }
        return super.equals(other);
    }

    public int hashCode() {
        T theElement = this.theElement;
        if (theElement != null) {
            return this._hashingStrategy.computeHashCode(theElement);
        }
        return super.hashCode();
    }

    public void clear() {
        this.theElement = null;
        super.clear();
    }

    public int size() {
        if (this.theElement != null) {
            return 1;
        }
        return super.size();
    }

    public boolean isEmpty() {
        return this.theElement == null && super.isEmpty();
    }

    public boolean remove(@NotNull Object obj) {
        T theElement;
        if (obj == null) {
            SmartHashSet.$$$reportNull$$$0(8);
        }
        if ((theElement = this.theElement) != null) {
            if (this.eq(theElement, obj)) {
                this.theElement = null;
                return true;
            }
            return false;
        }
        return super.remove(obj);
    }

    @NotNull
    public Iterator<T> iterator() {
        if (this.theElement != null) {
            return new SingletonIteratorBase<T>(){

                @Override
                protected void checkCoModification() {
                    if (SmartHashSet.this.theElement == null) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                protected T getElement() {
                    return SmartHashSet.this.theElement;
                }

                @Override
                public void remove() {
                    this.checkCoModification();
                    SmartHashSet.this.clear();
                }
            };
        }
        Iterator iterator = super.iterator();
        if (iterator == null) {
            SmartHashSet.$$$reportNull$$$0(9);
        }
        return iterator;
    }

    public boolean forEach(@NotNull TObjectProcedure<T> procedure) {
        T theElement;
        if (procedure == null) {
            SmartHashSet.$$$reportNull$$$0(10);
        }
        if ((theElement = this.theElement) != null) {
            return procedure.execute(theElement);
        }
        return super.forEach(procedure);
    }

    public Object @NotNull [] toArray() {
        T theElement = this.theElement;
        if (theElement != null) {
            Object[] objectArray = new Object[]{theElement};
            if (objectArray == null) {
                SmartHashSet.$$$reportNull$$$0(11);
            }
            return objectArray;
        }
        Object[] objectArray = super.toArray();
        if (objectArray == null) {
            SmartHashSet.$$$reportNull$$$0(12);
        }
        return objectArray;
    }

    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        T theElement;
        if (a == null) {
            SmartHashSet.$$$reportNull$$$0(13);
        }
        if ((theElement = this.theElement) != null) {
            if (a.length == 0) {
                a = ArrayUtil.newArray(ArrayUtil.getComponentType(a), 1);
            }
            a[0] = theElement;
            if (a.length > 1) {
                a[1] = null;
            }
            if (a == null) {
                SmartHashSet.$$$reportNull$$$0(14);
            }
            return a;
        }
        Object[] objectArray = super.toArray((Object[])a);
        if (objectArray == null) {
            SmartHashSet.$$$reportNull$$$0(15);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/SmartHashSet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/SmartHashSet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

