/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

public class VSCBundle
extends Bundle {
    private final Map<String, Collection<String>> grammarToExtensions;
    private final MultiMap<String, String> configToScopes;

    public VSCBundle(@NotNull String name, @NotNull String bundle) {
        if (name == null) {
            VSCBundle.$$$reportNull$$$0(0);
        }
        if (bundle == null) {
            VSCBundle.$$$reportNull$$$0(1);
        }
        super(name, bundle, BundleType.VSCODE);
        this.grammarToExtensions = new HashMap<String, Collection<String>>();
        this.configToScopes = new MultiMap();
    }

    @Override
    @NotNull
    public Collection<File> getGrammarFiles() {
        this.loadExtensions();
        Collection collection = this.grammarToExtensions.keySet().stream().map(path -> new File(this.bundleFile, (String)path)).collect(Collectors.toList());
        if (collection == null) {
            VSCBundle.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    public Collection<String> getExtensions(@NotNull File file, @NotNull Plist plist) {
        if (file == null) {
            VSCBundle.$$$reportNull$$$0(3);
        }
        if (plist == null) {
            VSCBundle.$$$reportNull$$$0(4);
        }
        HashSet<String> result = new HashSet<String>(super.getExtensions(file, plist));
        this.loadExtensions();
        result.addAll(this.grammarToExtensions.getOrDefault(FileUtilRt.toSystemIndependentName((String)Objects.requireNonNull(FileUtilRt.getRelativePath((File)this.bundleFile, (File)file))), Collections.emptyList()));
        return result;
    }

    private void loadExtensions() {
        if (!this.grammarToExtensions.isEmpty()) {
            return;
        }
        File packageJson = new File(this.bundleFile, "package.json");
        try {
            Object contributes;
            Object json = new Gson().fromJson((Reader)new FileReader(packageJson), Object.class);
            if (json instanceof Map && (contributes = ((Map)json).get("contributes")) instanceof Map) {
                Object languages = ((Map)contributes).get("languages");
                Object grammars = ((Map)contributes).get("grammars");
                if (languages instanceof ArrayList && grammars instanceof ArrayList) {
                    Map idToExtension = FactoryMap.create(s -> new HashSet());
                    HashMap<String, String> idToConfig = new HashMap<String, String>();
                    for (Object language : (ArrayList)languages) {
                        Object configuration;
                        Object filenames;
                        Object id;
                        if (!(language instanceof Map) || !((id = ((Map)language).get("id")) instanceof String)) continue;
                        Object extensions = ((Map)language).get("extensions");
                        if (extensions instanceof ArrayList) {
                            Stream<Object> stream = ((ArrayList)extensions).stream().map(ext -> StringUtil.trimStart((String)((String)ext), (String)"."));
                            ((Collection)idToExtension.get(id)).addAll(stream.collect(Collectors.toList()));
                        }
                        if ((filenames = ((Map)language).get("filenames")) instanceof ArrayList) {
                            ((Collection)idToExtension.get(id)).addAll((ArrayList)filenames);
                        }
                        if (!((configuration = ((Map)language).get("configuration")) instanceof String)) continue;
                        idToConfig.put((String)id, (String)configuration);
                    }
                    HashMap<String, Collection> grammarExtensions = new HashMap<String, Collection>();
                    MultiMap scopeConfig = new MultiMap();
                    for (Object grammar : (ArrayList)grammars) {
                        Object embedded;
                        if (!(grammar instanceof Map)) continue;
                        Object path = ((Map)grammar).get("path");
                        Object language = ((Map)grammar).get("language");
                        Collection extensions = (Collection)idToExtension.get(language);
                        if (path instanceof String) {
                            grammarExtensions.put((String)path, extensions);
                        }
                        Object scopeName = ((Map)grammar).get("scopeName");
                        String config = (String)idToConfig.get(language);
                        if (scopeName instanceof String && config != null) {
                            scopeConfig.putValue((Object)config, (Object)((String)scopeName));
                        }
                        if (!((embedded = ((Map)grammar).get("embeddedLanguages")) instanceof Map)) continue;
                        for (Object embeddedScope : ((Map)embedded).keySet()) {
                            String embeddedConfig;
                            Object embeddedLanguage = ((Map)embedded).get(embeddedScope);
                            if (!(embeddedScope instanceof String) || !(embeddedLanguage instanceof String) || (embeddedConfig = (String)idToConfig.get(embeddedLanguage)) == null) continue;
                            scopeConfig.putValue((Object)embeddedConfig, (Object)((String)embeddedScope));
                        }
                    }
                    this.grammarToExtensions.putAll(grammarExtensions);
                    this.configToScopes.putAllValues(scopeConfig);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public Collection<File> getPreferenceFiles() {
        Collection collection = this.configToScopes.keySet().stream().map(config -> new File(this.bundleFile, (String)config)).collect(Collectors.toList());
        if (collection == null) {
            VSCBundle.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    public List<Map.Entry<String, Plist>> loadPreferenceFile(@NotNull File file, @NotNull PlistReader plistReader) throws IOException {
        if (file == null) {
            VSCBundle.$$$reportNull$$$0(6);
        }
        if (plistReader == null) {
            VSCBundle.$$$reportNull$$$0(7);
        }
        Plist fromJson = VSCBundle.loadLanguageConfig(file);
        return this.configToScopes.get((Object)FileUtilRt.getRelativePath((File)this.bundleFile, (File)file)).stream().map(scope -> new AbstractMap.SimpleImmutableEntry<String, Plist>((String)scope, fromJson)).collect(Collectors.toList());
    }

    @NotNull
    private static Plist loadLanguageConfig(File languageConfig) throws IOException {
        Plist plist;
        Gson gson = new GsonBuilder().setLenient().create();
        try {
            Object json = gson.fromJson((Reader)new FileReader(languageConfig), Object.class);
            Plist settings = new Plist();
            if (json instanceof Map) {
                settings.setEntry("highlightingPairs", VSCBundle.loadBrackets((Map)json, "brackets"));
                settings.setEntry("smartTypingPairs", VSCBundle.loadBrackets((Map)json, "surroundingPairs"));
                settings.setEntry("shellVariables", PListValue.array(VSCBundle.loadComments((Map)json)));
            }
            plist = settings;
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new IOException(e);
        }
        if (plist == null) {
            VSCBundle.$$$reportNull$$$0(8);
        }
        return plist;
    }

    private static PListValue loadBrackets(Map json, String key) {
        Object brackets = json.get(key);
        if (!(brackets instanceof ArrayList)) {
            return null;
        }
        ArrayList<PListValue> pairs = new ArrayList<PListValue>();
        for (Object bracket : (ArrayList)brackets) {
            if (!(bracket instanceof ArrayList) || ((ArrayList)bracket).size() != 2) continue;
            pairs.add(PListValue.array(PListValue.string(((ArrayList)bracket).get(0).toString()), PListValue.string(((ArrayList)bracket).get(1).toString())));
        }
        return PListValue.array(pairs);
    }

    private static List<PListValue> loadComments(Map json) {
        ArrayList<PListValue> variables = new ArrayList<PListValue>();
        Object comments = json.get("comments");
        if (comments instanceof Map) {
            Object block;
            Object line = ((Map)comments).get("lineComment");
            boolean hasLine = line instanceof String;
            if (hasLine) {
                variables.add(VSCBundle.variable("TM_COMMENT_START", ((String)line).trim() + " "));
            }
            if ((block = ((Map)comments).get("blockComment")) instanceof ArrayList && ((ArrayList)block).size() == 2) {
                String suffix = hasLine ? "_2" : "";
                variables.add(VSCBundle.variable("TM_COMMENT_START" + suffix, ((ArrayList)block).get(0).toString().trim() + " "));
                variables.add(VSCBundle.variable("TM_COMMENT_END" + suffix, " " + ((ArrayList)block).get(1).toString().trim()));
            }
        }
        return variables;
    }

    private static PListValue variable(String name, String value) {
        Plist variable = new Plist();
        variable.setEntry("name", PListValue.string(name));
        variable.setEntry("value", PListValue.string(value));
        return PListValue.dict(variable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/bundles/VSCBundle";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plistReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/bundles/VSCBundle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrammarFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferenceFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLanguageConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadPreferenceFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

