function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { BehaviorSubject } from 'rxjs';
import { i18n } from '@kbn/i18n';
import { filter, map } from 'rxjs/operators';
import { createHashHistory } from 'history';
import { Storage, createKbnUrlTracker, createKbnUrlStateStorage } from '../../kibana_utils/public';
import { esFilters } from '../../data/public';
import { VisualizeConstants } from './application/visualize_constants';
import { FeatureCatalogueCategory } from '../../home/public';
import { DEFAULT_APP_CATEGORIES } from '../../../core/public';
export var VisualizePlugin = /*#__PURE__*/function () {
  function VisualizePlugin(initializerContext) {
    _classCallCheck(this, VisualizePlugin);

    this.initializerContext = initializerContext;

    _defineProperty(this, "appStateUpdater", new BehaviorSubject(function () {
      return {};
    }));

    _defineProperty(this, "stopUrlTracking", undefined);

    _defineProperty(this, "currentHistory", undefined);
  }

  _createClass(VisualizePlugin, [{
    key: "setup",
    value: function () {
      var _setup = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(core, _ref) {
        var _this = this;

        var home, kibanaLegacy, data, _createKbnUrlTracker, appMounted, appUnMounted, stopUrlTracker, setActiveUrl, restorePreviousUrl;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                home = _ref.home, kibanaLegacy = _ref.kibanaLegacy, data = _ref.data;
                _createKbnUrlTracker = createKbnUrlTracker({
                  baseUrl: core.http.basePath.prepend('/app/visualize'),
                  defaultSubUrl: '#/',
                  storageKey: "lastUrl:".concat(core.http.basePath.get(), ":visualize"),
                  navLinkUpdater$: this.appStateUpdater,
                  toastNotifications: core.notifications.toasts,
                  stateParams: [{
                    kbnUrlKey: '_g',
                    stateUpdate$: data.query.state$.pipe(filter(function (_ref2) {
                      var changes = _ref2.changes;
                      return !!(changes.globalFilters || changes.time || changes.refreshInterval);
                    }), map(function (_ref3) {
                      var _state$filters;

                      var state = _ref3.state;
                      return _objectSpread(_objectSpread({}, state), {}, {
                        filters: (_state$filters = state.filters) === null || _state$filters === void 0 ? void 0 : _state$filters.filter(esFilters.isFilterPinned)
                      });
                    }))
                  }],
                  getHistory: function getHistory() {
                    return _this.currentHistory;
                  }
                }), appMounted = _createKbnUrlTracker.appMounted, appUnMounted = _createKbnUrlTracker.appUnMounted, stopUrlTracker = _createKbnUrlTracker.stop, setActiveUrl = _createKbnUrlTracker.setActiveUrl, restorePreviousUrl = _createKbnUrlTracker.restorePreviousUrl;

                this.stopUrlTracking = function () {
                  stopUrlTracker();
                };

                core.application.register({
                  id: 'visualize',
                  title: 'Visualize',
                  order: 8002,
                  euiIconType: 'visualizeApp',
                  defaultPath: '#/',
                  category: DEFAULT_APP_CATEGORIES.kibana,
                  updater$: this.appStateUpdater.asObservable(),
                  // remove all references to visualize
                  mount: function () {
                    var _mount = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(params) {
                      var _yield$core$getStartS, _yield$core$getStartS2, coreStart, pluginsStart, unlistenParentHistory, history, services, _yield$import, renderApp, unmount;

                      return regeneratorRuntime.wrap(function _callee$(_context) {
                        while (1) {
                          switch (_context.prev = _context.next) {
                            case 0:
                              _context.next = 2;
                              return core.getStartServices();

                            case 2:
                              _yield$core$getStartS = _context.sent;
                              _yield$core$getStartS2 = _slicedToArray(_yield$core$getStartS, 2);
                              coreStart = _yield$core$getStartS2[0];
                              pluginsStart = _yield$core$getStartS2[1];
                              _this.currentHistory = params.history; // make sure the index pattern list is up to date

                              pluginsStart.data.indexPatterns.clearCache(); // make sure a default index pattern exists
                              // if not, the page will be redirected to management and visualize won't be rendered

                              _context.next = 10;
                              return pluginsStart.data.indexPatterns.ensureDefaultIndexPattern();

                            case 10:
                              appMounted(); // dispatch synthetic hash change event to update hash history objects
                              // this is necessary because hash updates triggered by using popState won't trigger this event naturally.

                              unlistenParentHistory = params.history.listen(function () {
                                window.dispatchEvent(new HashChangeEvent('hashchange'));
                              });
                              /**
                               * current implementation uses 2 history objects:
                               * 1. the hash history (used for the react hash router)
                               * 2. and the scoped history (used for url tracking)
                               * this should be replaced to use only scoped history after moving legacy apps to browser routing
                               */

                              history = createHashHistory();
                              services = _objectSpread(_objectSpread({}, coreStart), {}, {
                                history: history,
                                kbnUrlStateStorage: createKbnUrlStateStorage({
                                  history: history,
                                  useHash: coreStart.uiSettings.get('state:storeInSessionStorage')
                                }),
                                kibanaLegacy: pluginsStart.kibanaLegacy,
                                pluginInitializerContext: _this.initializerContext,
                                chrome: coreStart.chrome,
                                data: pluginsStart.data,
                                localStorage: new Storage(localStorage),
                                navigation: pluginsStart.navigation,
                                savedVisualizations: pluginsStart.visualizations.savedVisualizationsLoader,
                                share: pluginsStart.share,
                                toastNotifications: coreStart.notifications.toasts,
                                visualizeCapabilities: coreStart.application.capabilities.visualize,
                                visualizations: pluginsStart.visualizations,
                                embeddable: pluginsStart.embeddable,
                                setActiveUrl: setActiveUrl,
                                createVisEmbeddableFromObject: pluginsStart.visualizations.__LEGACY.createVisEmbeddableFromObject,
                                savedObjectsPublic: pluginsStart.savedObjects,
                                scopedHistory: params.history,
                                restorePreviousUrl: restorePreviousUrl,
                                featureFlagConfig: _this.initializerContext.config.get()
                              });
                              params.element.classList.add('visAppWrapper');
                              _context.next = 17;
                              return import('./application');

                            case 17:
                              _yield$import = _context.sent;
                              renderApp = _yield$import.renderApp;
                              unmount = renderApp(params, services);
                              return _context.abrupt("return", function () {
                                unlistenParentHistory();
                                unmount();
                                appUnMounted();
                              });

                            case 21:
                            case "end":
                              return _context.stop();
                          }
                        }
                      }, _callee);
                    }));

                    function mount(_x3) {
                      return _mount.apply(this, arguments);
                    }

                    return mount;
                  }()
                });
                kibanaLegacy.forwardApp('visualize', 'visualize');

                if (home) {
                  home.featureCatalogue.register({
                    id: 'visualize',
                    title: 'Visualize',
                    description: i18n.translate('visualize.visualizeDescription', {
                      defaultMessage: 'Create visualizations and aggregate data stores in your Elasticsearch indices.'
                    }),
                    icon: 'visualizeApp',
                    path: "/app/visualize#".concat(VisualizeConstants.LANDING_PAGE_PATH),
                    showOnHomePage: true,
                    category: FeatureCatalogueCategory.DATA
                  });
                }

              case 6:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function setup(_x, _x2) {
        return _setup.apply(this, arguments);
      }

      return setup;
    }()
  }, {
    key: "start",
    value: function start(core, plugins) {}
  }, {
    key: "stop",
    value: function stop() {
      if (this.stopUrlTracking) {
        this.stopUrlTracking();
      }
    }
  }]);

  return VisualizePlugin;
}();