function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { i18n } from '@kbn/i18n';
import uuid from 'uuid';
import { VISUALIZE_EMBEDDABLE_TYPE } from '../../../../visualizations/public';
import { showSaveModal, SavedObjectSaveModalOrigin } from '../../../../saved_objects/public';
import { unhashUrl } from '../../../../kibana_utils/public';
import { VisualizeConstants } from '../visualize_constants';
import { getEditBreadcrumbs } from './breadcrumbs';
export var getTopNavConfig = function getTopNavConfig(_ref, _ref2) {
  var hasUnsavedChanges = _ref.hasUnsavedChanges,
      setHasUnsavedChanges = _ref.setHasUnsavedChanges,
      openInspector = _ref.openInspector,
      originatingApp = _ref.originatingApp,
      setOriginatingApp = _ref.setOriginatingApp,
      hasUnappliedChanges = _ref.hasUnappliedChanges,
      _ref$savedVisInstance = _ref.savedVisInstance,
      embeddableHandler = _ref$savedVisInstance.embeddableHandler,
      savedVis = _ref$savedVisInstance.savedVis,
      vis = _ref$savedVisInstance.vis,
      stateContainer = _ref.stateContainer,
      visualizationIdFromUrl = _ref.visualizationIdFromUrl;
  var application = _ref2.application,
      chrome = _ref2.chrome,
      embeddable = _ref2.embeddable,
      history = _ref2.history,
      share = _ref2.share,
      setActiveUrl = _ref2.setActiveUrl,
      toastNotifications = _ref2.toastNotifications,
      visualizeCapabilities = _ref2.visualizeCapabilities,
      I18nContext = _ref2.i18n.Context,
      featureFlagConfig = _ref2.featureFlagConfig;

  /**
   * Called when the user clicks "Save" button.
   */
  function doSave(_x) {
    return _doSave.apply(this, arguments);
  }

  function _doSave() {
    _doSave = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(saveOptions) {
      var _vis$data$searchSourc;

      var newlyCreated, id, appPath;
      return regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              newlyCreated = !Boolean(savedVis.id) || savedVis.copyOnSave; // vis.title was not bound and it's needed to reflect title into visState

              stateContainer.transitions.setVis({
                title: savedVis.title
              });
              savedVis.searchSourceFields = (_vis$data$searchSourc = vis.data.searchSource) === null || _vis$data$searchSourc === void 0 ? void 0 : _vis$data$searchSourc.getSerializedFields();
              savedVis.visState = stateContainer.getState().vis;
              savedVis.uiStateJSON = vis.uiState.toString();
              setHasUnsavedChanges(false);
              _context3.prev = 6;
              _context3.next = 9;
              return savedVis.save(saveOptions);

            case 9:
              id = _context3.sent;

              if (id) {
                toastNotifications.addSuccess({
                  title: i18n.translate('visualize.topNavMenu.saveVisualization.successNotificationText', {
                    defaultMessage: "Saved '{visTitle}'",
                    values: {
                      visTitle: savedVis.title
                    }
                  }),
                  'data-test-subj': 'saveVisualizationSuccess'
                });

                if (originatingApp && saveOptions.returnToOrigin) {
                  appPath = "".concat(VisualizeConstants.EDIT_PATH, "/").concat(encodeURIComponent(id)); // Manually insert a new url so the back button will open the saved visualization.

                  history.replace(appPath);
                  setActiveUrl(appPath);

                  if (newlyCreated && embeddable) {
                    embeddable.getStateTransfer().navigateToWithEmbeddablePackage(originatingApp, {
                      state: {
                        id: id,
                        type: VISUALIZE_EMBEDDABLE_TYPE
                      }
                    });
                  } else {
                    application.navigateToApp(originatingApp);
                  }
                } else {
                  if (setOriginatingApp && originatingApp && newlyCreated) {
                    setOriginatingApp(undefined);
                  }

                  chrome.docTitle.change(savedVis.lastSavedTitle);
                  chrome.setBreadcrumbs(getEditBreadcrumbs(savedVis.lastSavedTitle));

                  if (id !== visualizationIdFromUrl) {
                    history.replace(_objectSpread(_objectSpread({}, history.location), {}, {
                      pathname: "".concat(VisualizeConstants.EDIT_PATH, "/").concat(id)
                    }));
                  }
                }
              }

              return _context3.abrupt("return", {
                id: id
              });

            case 14:
              _context3.prev = 14;
              _context3.t0 = _context3["catch"](6);
              // eslint-disable-next-line
              console.error(_context3.t0);
              toastNotifications.addDanger({
                title: i18n.translate('visualize.topNavMenu.saveVisualization.failureNotificationText', {
                  defaultMessage: "Error on saving '{visTitle}'",
                  values: {
                    visTitle: savedVis.title
                  }
                }),
                text: _context3.t0.message,
                'data-test-subj': 'saveVisualizationError'
              });
              return _context3.abrupt("return", {
                error: _context3.t0
              });

            case 19:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3, null, [[6, 14]]);
    }));
    return _doSave.apply(this, arguments);
  }

  var topNavMenu = [].concat(_toConsumableArray(originatingApp && savedVis.id ? [{
    id: 'saveAndReturn',
    label: i18n.translate('visualize.topNavMenu.saveAndReturnVisualizationButtonLabel', {
      defaultMessage: 'Save and return'
    }),
    emphasize: true,
    iconType: 'check',
    description: i18n.translate('visualize.topNavMenu.saveAndReturnVisualizationButtonAriaLabel', {
      defaultMessage: 'Finish editing visualization and return to the last app'
    }),
    testId: 'visualizesaveAndReturnButton',
    disableButton: hasUnappliedChanges,
    tooltip: function tooltip() {
      if (hasUnappliedChanges) {
        return i18n.translate('visualize.topNavMenu.saveAndReturnVisualizationDisabledButtonTooltip', {
          defaultMessage: 'Apply or Discard your changes before finishing'
        });
      }
    },
    run: function () {
      var _run = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var saveOptions;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                saveOptions = {
                  confirmOverwrite: false,
                  returnToOrigin: true
                };
                return _context.abrupt("return", doSave(saveOptions));

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function run() {
        return _run.apply(this, arguments);
      }

      return run;
    }()
  }] : []), _toConsumableArray(visualizeCapabilities.save ? [{
    id: 'save',
    label: savedVis.id && originatingApp ? i18n.translate('visualize.topNavMenu.saveVisualizationAsButtonLabel', {
      defaultMessage: 'save as'
    }) : i18n.translate('visualize.topNavMenu.saveVisualizationButtonLabel', {
      defaultMessage: 'save'
    }),
    emphasize: !savedVis.id || !originatingApp,
    description: i18n.translate('visualize.topNavMenu.saveVisualizationButtonAriaLabel', {
      defaultMessage: 'Save Visualization'
    }),
    testId: 'visualizeSaveButton',
    disableButton: hasUnappliedChanges,
    tooltip: function tooltip() {
      if (hasUnappliedChanges) {
        return i18n.translate('visualize.topNavMenu.saveVisualizationDisabledButtonTooltip', {
          defaultMessage: 'Apply or Discard your changes before saving'
        });
      }
    },
    run: function run() {
      var onSave = /*#__PURE__*/function () {
        var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(_ref3) {
          var newTitle, newCopyOnSave, isTitleDuplicateConfirmed, onTitleDuplicate, newDescription, returnToOrigin, currentTitle, saveOptions, response;
          return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  newTitle = _ref3.newTitle, newCopyOnSave = _ref3.newCopyOnSave, isTitleDuplicateConfirmed = _ref3.isTitleDuplicateConfirmed, onTitleDuplicate = _ref3.onTitleDuplicate, newDescription = _ref3.newDescription, returnToOrigin = _ref3.returnToOrigin;
                  currentTitle = savedVis.title;
                  savedVis.title = newTitle;
                  savedVis.copyOnSave = newCopyOnSave;
                  savedVis.description = newDescription;
                  saveOptions = {
                    confirmOverwrite: false,
                    isTitleDuplicateConfirmed: isTitleDuplicateConfirmed,
                    onTitleDuplicate: onTitleDuplicate,
                    returnToOrigin: returnToOrigin
                  };
                  _context2.next = 8;
                  return doSave(saveOptions);

                case 8:
                  response = _context2.sent;

                  // If the save wasn't successful, put the original values back.
                  if (!response.id || response.error) {
                    savedVis.title = currentTitle;
                  }

                  return _context2.abrupt("return", response);

                case 11:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }));

        return function onSave(_x2) {
          return _ref4.apply(this, arguments);
        };
      }();

      var createVisReference = function createVisReference() {
        if (!originatingApp) {
          return;
        }

        var input = _objectSpread(_objectSpread({}, vis.serialize()), {}, {
          id: uuid.v4()
        });

        embeddable.getStateTransfer().navigateToWithEmbeddablePackage(originatingApp, {
          state: {
            input: input,
            type: VISUALIZE_EMBEDDABLE_TYPE
          }
        });
      };

      var saveModal = /*#__PURE__*/React.createElement(SavedObjectSaveModalOrigin, {
        documentInfo: savedVis,
        onSave: onSave,
        objectType: 'visualization',
        onClose: function onClose() {},
        originatingApp: originatingApp
      });

      if (originatingApp === 'dashboards' && featureFlagConfig.showNewVisualizeFlow) {
        createVisReference();
      } else {
        showSaveModal(saveModal, I18nContext);
      }
    }
  }] : []), [{
    id: 'share',
    label: i18n.translate('visualize.topNavMenu.shareVisualizationButtonLabel', {
      defaultMessage: 'share'
    }),
    description: i18n.translate('visualize.topNavMenu.shareVisualizationButtonAriaLabel', {
      defaultMessage: 'Share Visualization'
    }),
    testId: 'shareTopNavButton',
    run: function run(anchorElement) {
      if (share) {
        share.toggleShareContextMenu({
          anchorElement: anchorElement,
          allowEmbed: true,
          allowShortUrl: visualizeCapabilities.createShortUrl,
          shareableUrl: unhashUrl(window.location.href),
          objectId: savedVis.id,
          objectType: 'visualization',
          sharingData: {
            title: savedVis.title
          },
          isDirty: hasUnappliedChanges || hasUnsavedChanges
        });
      }
    },
    // disable the Share button if no action specified
    disableButton: !share
  }, {
    id: 'inspector',
    label: i18n.translate('visualize.topNavMenu.openInspectorButtonLabel', {
      defaultMessage: 'inspect'
    }),
    description: i18n.translate('visualize.topNavMenu.openInspectorButtonAriaLabel', {
      defaultMessage: 'Open Inspector for visualization'
    }),
    testId: 'openInspectorButton',
    disableButton: function disableButton() {
      return !embeddableHandler.hasInspector || !embeddableHandler.hasInspector();
    },
    run: openInspector,
    tooltip: function tooltip() {
      if (!embeddableHandler.hasInspector || !embeddableHandler.hasInspector()) {
        return i18n.translate('visualize.topNavMenu.openInspectorDisabledButtonTooltip', {
          defaultMessage: "This visualization doesn't support any inspectors."
        });
      }
    }
  }]);
  return topNavMenu;
};