function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get } from 'lodash';
import React, { useEffect, useMemo } from 'react';
import { EuiIconTip, EuiPanel } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { search } from '../../../data/public';
import { SwitchOption, SelectOption, NumberInputOption } from '../../../charts/public';
import { totalAggregations } from './utils';
var tabifyGetColumns = search.tabifyGetColumns;

function TableOptions(_ref) {
  var aggs = _ref.aggs,
      stateParams = _ref.stateParams,
      setValidity = _ref.setValidity,
      setValue = _ref.setValue;
  var percentageColumns = useMemo(function () {
    return [{
      value: '',
      text: i18n.translate('visTypeTable.params.defaultPercentageCol', {
        defaultMessage: 'Don’t show'
      })
    }].concat(_toConsumableArray(tabifyGetColumns(aggs.getResponseAggs(), true).filter(function (col) {
      return get(col.aggConfig.toSerializedFieldFormat(), 'id') === 'number';
    }).map(function (_ref2) {
      var name = _ref2.name;
      return {
        value: name,
        text: name
      };
    })));
  }, [aggs]);
  var isPerPageValid = stateParams.perPage === '' || stateParams.perPage > 0;
  useEffect(function () {
    setValidity(isPerPageValid);
  }, [isPerPageValid, setValidity]);
  useEffect(function () {
    if (!percentageColumns.find(function (_ref3) {
      var value = _ref3.value;
      return value === stateParams.percentageCol;
    }) && percentageColumns[0] && percentageColumns[0].value !== stateParams.percentageCol) {
      setValue('percentageCol', percentageColumns[0].value);
    }
  }, [percentageColumns, stateParams.percentageCol, setValidity, setValue]);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(NumberInputOption, {
    label: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "visTypeTable.params.perPageLabel",
      defaultMessage: "Max rows per page"
    }), ' ', /*#__PURE__*/React.createElement(EuiIconTip, {
      content: "Leaving this field empty means it will use number of buckets from the response.",
      position: "right"
    })),
    isInvalid: !isPerPageValid,
    min: 1,
    paramName: "perPage",
    value: stateParams.perPage,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeTable.params.showMetricsLabel', {
      defaultMessage: 'Show metrics for every bucket/level'
    }),
    paramName: "showMetricsAtAllLevels",
    value: stateParams.showMetricsAtAllLevels,
    setValue: setValue,
    "data-test-subj": "showMetricsAtAllLevels"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeTable.params.showPartialRowsLabel', {
      defaultMessage: 'Show partial rows'
    }),
    tooltip: i18n.translate('visTypeTable.params.showPartialRowsTip', {
      defaultMessage: 'Show rows that have partial data. This will still calculate metrics for every bucket/level, even if they are not displayed.'
    }),
    paramName: "showPartialRows",
    value: stateParams.showPartialRows,
    setValue: setValue,
    "data-test-subj": "showPartialRows"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeTable.params.showTotalLabel', {
      defaultMessage: 'Show total'
    }),
    paramName: "showTotal",
    value: stateParams.showTotal,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(SelectOption, {
    label: i18n.translate('visTypeTable.params.totalFunctionLabel', {
      defaultMessage: 'Total function'
    }),
    disabled: !stateParams.showTotal,
    options: totalAggregations,
    paramName: "totalFunc",
    value: stateParams.totalFunc,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(SelectOption, {
    label: i18n.translate('visTypeTable.params.PercentageColLabel', {
      defaultMessage: 'Percentage column'
    }),
    options: percentageColumns,
    paramName: "percentageCol",
    value: stateParams.percentageCol,
    setValue: setValue,
    id: "datatableVisualizationPercentageCol"
  }));
} // default export required for React.Lazy
// eslint-disable-next-line import/no-default-export


export { TableOptions as default };