function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get } from 'lodash';
import React, { useState, useCallback } from 'react';
import { useMount } from 'react-use';
import { EuiComboBox, EuiFormRow } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { formatListAsProse, parseCommaSeparatedList, useValidation } from './utils';
var label = i18n.translate('visDefaultEditor.controls.field.fieldLabel', {
  defaultMessage: 'Field'
});

function FieldParamEditor(_ref) {
  var agg = _ref.agg,
      aggParam = _ref.aggParam,
      customError = _ref.customError,
      customLabel = _ref.customLabel,
      _ref$indexedFields = _ref.indexedFields,
      indexedFields = _ref$indexedFields === void 0 ? [] : _ref$indexedFields,
      showValidation = _ref.showValidation,
      value = _ref.value,
      setTouched = _ref.setTouched,
      setValidity = _ref.setValidity,
      setValue = _ref.setValue;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isDirty = _useState2[0],
      setIsDirty = _useState2[1];

  var selectedOptions = value ? [{
    label: value.displayName || value.name,
    target: value
  }] : [];

  var onChange = function onChange(options) {
    var selectedOption = get(options, '0.target');

    if (!(aggParam.required && !selectedOption)) {
      setValue(selectedOption);
    }

    if (aggParam.onChange) {
      aggParam.onChange(agg);
    }
  };

  var errors = customError ? [customError] : [];

  if (!indexedFields.length) {
    errors.push(i18n.translate('visDefaultEditor.controls.field.noCompatibleFieldsDescription', {
      defaultMessage: 'The index pattern {indexPatternTitle} does not contain any of the following compatible field types: {fieldTypes}',
      values: {
        indexPatternTitle: agg.getIndexPattern && agg.getIndexPattern().title,
        fieldTypes: getFieldTypesString(agg)
      }
    }));
  }

  var isValid = !!value && !errors.length && !isDirty; // we show an error message right away if there is no compatible fields

  var showErrorMessage = (showValidation || !indexedFields.length) && !isValid;
  useValidation(setValidity, isValid);
  useMount(function () {
    // set field if only one available
    if (indexedFields.length !== 1) {
      return;
    }

    var indexedField = indexedFields[0];

    if (!('options' in indexedField)) {
      setValue(indexedField.target);
    } else if (indexedField.options.length === 1) {
      setValue(indexedField.options[0].target);
    }
  });
  var onSearchChange = useCallback(function (searchValue) {
    return setIsDirty(Boolean(searchValue));
  }, []);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: customLabel || label,
    isInvalid: showErrorMessage,
    fullWidth: true,
    error: errors,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiComboBox, {
    compressed: true,
    placeholder: i18n.translate('visDefaultEditor.controls.field.selectFieldPlaceholder', {
      defaultMessage: 'Select a field'
    }),
    options: indexedFields,
    isDisabled: !indexedFields.length,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    isInvalid: showErrorMessage,
    onChange: onChange,
    onBlur: setTouched,
    onSearchChange: onSearchChange,
    "data-test-subj": "visDefaultEditorField",
    fullWidth: true
  }));
}

function getFieldTypesString(agg) {
  var param = get(agg, 'type.params', []).find(function (p) {
    return p.name === 'field';
  }) || {};
  return formatListAsProse(parseCommaSeparatedList(param.filterFieldTypes), {
    inclusive: false
  });
}

export { FieldParamEditor };