function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, useCallback, useEffect, useMemo, useState } from 'react';
import { isArray } from 'lodash';
import { EuiButtonEmpty, EuiFlexItem, EuiFormRow, EuiSpacer, htmlIdGenerator } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { EMPTY_STRING, getInitModelList, getRange, parse } from './number_list/utils';
import { NumberRow } from './number_list/number_row';
var generateId = htmlIdGenerator();

function SimpleNumberList(_ref) {
  var agg = _ref.agg,
      aggParam = _ref.aggParam,
      value = _ref.value,
      setValue = _ref.setValue,
      setTouched = _ref.setTouched;

  var _useState = useState(getInitModelList(value && isArray(value) ? value : [EMPTY_STRING])),
      _useState2 = _slicedToArray(_useState, 2),
      numbers = _useState2[0],
      setNumbers = _useState2[1];

  var numberRange = useMemo(function () {
    return getRange('[-Infinity,Infinity]');
  }, []); // This useEffect is needed to discard changes, it sets numbers a mapped value if they are different

  useEffect(function () {
    if (isArray(value) && (value.length !== numbers.length || !value.every(function (numberValue, index) {
      return numberValue === numbers[index].value;
    }))) {
      setNumbers(value.map(function (numberValue) {
        return {
          id: generateId(),
          value: numberValue,
          isInvalid: false
        };
      }));
    }
  }, [numbers, value]);
  var onUpdate = useCallback(function (numberList) {
    setNumbers(numberList);
    setValue(numberList.map(function (_ref2) {
      var numberValue = _ref2.value;
      return numberValue;
    }));
  }, [setValue]);
  var onChangeValue = useCallback(function (numberField) {
    onUpdate(numbers.map(function (number) {
      return number.id === numberField.id ? {
        id: numberField.id,
        value: parse(numberField.value),
        isInvalid: false
      } : number;
    }));
  }, [numbers, onUpdate]); // Add an item to the end of the list

  var onAdd = useCallback(function () {
    var newArray = [].concat(_toConsumableArray(numbers), [{
      id: generateId(),
      value: EMPTY_STRING,
      isInvalid: false
    }]);
    onUpdate(newArray);
  }, [numbers, onUpdate]);
  var onDelete = useCallback(function (id) {
    return onUpdate(numbers.filter(function (number) {
      return number.id !== id;
    }));
  }, [numbers, onUpdate]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    id: "".concat(aggParam.name, "-").concat(agg.id, "}"),
    label: aggParam.displayName || aggParam.name,
    fullWidth: true,
    compressed: true
  }, /*#__PURE__*/React.createElement(React.Fragment, null, numbers.map(function (number, arrayIndex) {
    return /*#__PURE__*/React.createElement(Fragment, {
      key: number.id
    }, /*#__PURE__*/React.createElement(NumberRow, {
      isInvalid: number.isInvalid,
      disableDelete: numbers.length === 1,
      model: number,
      labelledbyId: "".concat(aggParam.name, "-").concat(agg.id, "-legend"),
      range: numberRange,
      onDelete: onDelete,
      onChange: onChangeValue,
      onBlur: setTouched,
      autoFocus: numbers.length !== 1 && arrayIndex === numbers.length - 1
    }), numbers.length - 1 !== arrayIndex && /*#__PURE__*/React.createElement(EuiSpacer, {
      size: "s"
    }));
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.includeExclude.addUnitButtonLabel",
    defaultMessage: "Add value"
  })))));
}

export { SimpleNumberList };