function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get, has } from 'lodash';
import React, { useEffect, useCallback, useState } from 'react';
import { EuiComboBox, EuiFormRow, EuiLink, EuiText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { useKibana } from '../../../kibana_react/public';
import { AGG_TYPE_ACTION_KEYS } from './agg_params_state';

function DefaultEditorAggSelect(_ref) {
  var aggError = _ref.aggError,
      id = _ref.id,
      indexPattern = _ref.indexPattern,
      value = _ref.value,
      setValue = _ref.setValue,
      aggTypeOptions = _ref.aggTypeOptions,
      showValidation = _ref.showValidation,
      isSubAggregation = _ref.isSubAggregation,
      onChangeAggType = _ref.onChangeAggType;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isDirty = _useState2[0],
      setIsDirty = _useState2[1];

  var _useKibana = useKibana(),
      services = _useKibana.services;

  var selectedOptions = value ? [{
    label: value.title,
    target: value
  }] : [];
  var label = isSubAggregation ? /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.aggSelect.subAggregationLabel",
    defaultMessage: "Sub aggregation"
  }) : /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.aggSelect.aggregationLabel",
    defaultMessage: "Aggregation"
  });
  var aggHelpLink;

  if (has(value, 'name')) {
    aggHelpLink = services.docLinks.links.aggs[value.name];
  }

  var helpLink = value && aggHelpLink && /*#__PURE__*/React.createElement(EuiLink, {
    href: aggHelpLink,
    target: "_blank",
    rel: "noopener"
  }, /*#__PURE__*/React.createElement(EuiText, {
    size: "xs"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.aggSelect.helpLinkLabel",
    defaultMessage: "{aggTitle} help",
    values: {
      aggTitle: value ? value.title : ''
    }
  })));
  var errors = aggError ? [aggError] : [];

  if (!aggTypeOptions.length) {
    errors.push(i18n.translate('visDefaultEditor.aggSelect.noCompatibleAggsDescription', {
      defaultMessage: 'The index pattern {indexPatternTitle} does not have any aggregatable fields.',
      values: {
        indexPatternTitle: indexPattern && indexPattern.title
      }
    }));
  }

  var isValid = !!value && !errors.length && !isDirty;
  var onChange = useCallback(function (options) {
    var selectedOption = get(options, '0.target');

    if (selectedOption) {
      setValue(selectedOption);
    }
  }, [setValue]);
  var onSearchChange = useCallback(function (searchValue) {
    return setIsDirty(Boolean(searchValue));
  }, []);
  var setTouched = useCallback(function () {
    return onChangeAggType({
      type: AGG_TYPE_ACTION_KEYS.TOUCHED,
      payload: true
    });
  }, [onChangeAggType]);
  var setValidity = useCallback(function (valid) {
    return onChangeAggType({
      type: AGG_TYPE_ACTION_KEYS.VALID,
      payload: valid
    });
  }, [onChangeAggType]);
  useEffect(function () {
    setValidity(isValid);
  }, [isValid, setValidity]);
  useEffect(function () {
    if (errors.length) {
      setTouched();
    }
  }, [errors.length, setTouched]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: label,
    labelAppend: helpLink,
    error: errors,
    isInvalid: showValidation ? !isValid : false,
    fullWidth: true,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiComboBox, {
    placeholder: i18n.translate('visDefaultEditor.aggSelect.selectAggPlaceholder', {
      defaultMessage: 'Select an aggregation'
    }),
    id: "visDefaultEditorAggSelect".concat(id),
    isDisabled: !aggTypeOptions.length,
    options: aggTypeOptions,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    onBlur: setTouched,
    onChange: onChange,
    onSearchChange: onSearchChange,
    "data-test-subj": "defaultEditorAggSelect",
    isClearable: false,
    isInvalid: showValidation ? !isValid : false,
    fullWidth: true,
    compressed: true
  }));
}

export { DefaultEditorAggSelect };