/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { memo } from 'react';
import { Route, Router, Switch } from 'react-router-dom';
import { EuiPageBody } from '@elastic/eui';
import { ManagementAppWrapper } from '../management_app_wrapper';
import { ManagementLandingPage } from '../landing';
export var ManagementRouter = /*#__PURE__*/memo(function (_ref) {
  var dependencies = _ref.dependencies,
      history = _ref.history,
      setBreadcrumbs = _ref.setBreadcrumbs,
      onAppMounted = _ref.onAppMounted,
      sections = _ref.sections;
  return /*#__PURE__*/React.createElement(Router, {
    history: history
  }, /*#__PURE__*/React.createElement(EuiPageBody, {
    restrictWidth: false,
    className: "mgtPage__body"
  }, /*#__PURE__*/React.createElement(Switch, null, sections.map(function (section) {
    return section.getAppsEnabled().map(function (app) {
      return /*#__PURE__*/React.createElement(Route, {
        path: "".concat(app.basePath),
        component: function component() {
          return /*#__PURE__*/React.createElement(ManagementAppWrapper, {
            app: app,
            setBreadcrumbs: setBreadcrumbs,
            onAppMounted: onAppMounted,
            history: history
          });
        }
      });
    });
  }), /*#__PURE__*/React.createElement(Route, {
    path: '/',
    component: function component() {
      return /*#__PURE__*/React.createElement(ManagementLandingPage, {
        version: dependencies.kibanaVersion,
        setBreadcrumbs: setBreadcrumbs
      });
    }
  }))));
});