function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { withRouter } from 'react-router-dom';
import { EuiButton, EuiFlexGroup, EuiFlexItem, EuiText, EuiTitle } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { reactRouterNavigate } from '../../../../../../../kibana_react/public';
export var Header = withRouter(function (_ref) {
  var indexPatternId = _ref.indexPatternId,
      history = _ref.history;
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "s"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.scriptedHeader",
    defaultMessage: "Scripted fields"
  }))), /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.scriptedLabel",
    defaultMessage: "You can use scripted fields in visualizations and display them in your documents. However, you cannot search scripted fields."
  })))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, _extends({
    "data-test-subj": "addScriptedFieldLink"
  }, reactRouterNavigate(history, "patterns/".concat(indexPatternId, "/create-field/"))), /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.scripted.addFieldButton",
    defaultMessage: "Add scripted field"
  }))));
});