function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, createContext, useContext, useCallback } from 'react';
import { WithMultiContent, useMultiContentContext } from '../multi_content';
var formWizardContext = createContext({});
export var FormWizardProvider = WithMultiContent(function FormWizardProvider(_ref) {
  var _state$steps$state$ac;

  var children = _ref.children,
      _ref$defaultActiveSte = _ref.defaultActiveStep,
      defaultActiveStep = _ref$defaultActiveSte === void 0 ? 0 : _ref$defaultActiveSte,
      isEditing = _ref.isEditing,
      onSave = _ref.onSave;

  var _useMultiContentConte = useMultiContentContext(),
      getData = _useMultiContentConte.getData,
      validate = _useMultiContentConte.validate,
      validation = _useMultiContentConte.validation;

  var _useState = useState({
    activeStepIndex: defaultActiveStep,
    steps: {}
  }),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  var activeStepId = (_state$steps$state$ac = state.steps[state.activeStepIndex]) === null || _state$steps$state$ac === void 0 ? void 0 : _state$steps$state$ac.id;
  var lastStep = Object.keys(state.steps).length - 1;
  var isCurrentStepValid = validation.contents[activeStepId];
  var addStep = useCallback(function (id, label) {
    var isRequired = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    setState(function (prev) {
      var index = Object.keys(prev.steps).length;
      return _objectSpread(_objectSpread({}, prev), {}, {
        steps: _objectSpread(_objectSpread({}, prev.steps), {}, _defineProperty({}, index, {
          id: id,
          index: index,
          label: label,
          isRequired: isRequired,
          isComplete: isEditing !== null && isEditing !== void 0 ? isEditing : false
        }))
      });
    });
  }, [isEditing]);
  /**
   * Get the step index from a step id.
   */

  var getStepIndex = useCallback(function (stepId) {
    if (typeof stepId === 'number') {
      return stepId;
    } // We provided a string stepId, we need to find the corresponding index


    var targetStep = Object.values(state.steps).find(function (_step) {
      return _step.id === stepId;
    });

    if (!targetStep) {
      throw new Error("Can't navigate to step \"".concat(stepId, "\" as there are no step with that ID."));
    }

    return targetStep.index;
  }, [state.steps]);
  var navigateToStep = useCallback( /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(stepId) {
      var isValid, nextStepIndex;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return validate();

            case 2:
              isValid = _context.sent;

              if (isValid) {
                _context.next = 5;
                break;
              }

              return _context.abrupt("return");

            case 5:
              nextStepIndex = getStepIndex(stepId);

              if (!(nextStepIndex > lastStep)) {
                _context.next = 9;
                break;
              }

              // We are on the last step, save the data and don't go any further
              onSave(getData());
              return _context.abrupt("return");

            case 9:
              // Update the active step
              setState(function (prev) {
                var currentStep = prev.steps[prev.activeStepIndex];

                var nextState = _objectSpread(_objectSpread({}, prev), {}, {
                  activeStepIndex: nextStepIndex
                });

                if (nextStepIndex > prev.activeStepIndex && !currentStep.isComplete) {
                  // Mark the current step as completed
                  nextState.steps[prev.activeStepIndex] = _objectSpread(_objectSpread({}, currentStep), {}, {
                    isComplete: true
                  });
                }

                return nextState;
              });

            case 10:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x) {
      return _ref2.apply(this, arguments);
    };
  }(), [getStepIndex, validate, onSave, getData]);

  var value = _objectSpread(_objectSpread({}, state), {}, {
    activeStepId: activeStepId,
    lastStep: lastStep,
    isCurrentStepValid: isCurrentStepValid,
    addStep: addStep,
    navigateToStep: navigateToStep
  });

  return /*#__PURE__*/React.createElement(formWizardContext.Provider, {
    value: value
  }, children);
});
export var FormWizardConsumer = formWizardContext.Consumer;
export function useFormWizardContext() {
  var ctx = useContext(formWizardContext);

  if (ctx === undefined) {
    throw new Error('useFormWizardContext() must be called within a <FormWizardProvider />');
  }

  return ctx;
}