/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export var defaultEmbeddableFactoryProvider = function defaultEmbeddableFactoryProvider(def) {
  var _def$isContainerType, _def$createFromSavedO;

  var factory = {
    isContainerType: (_def$isContainerType = def.isContainerType) !== null && _def$isContainerType !== void 0 ? _def$isContainerType : false,
    canCreateNew: def.canCreateNew ? def.canCreateNew.bind(def) : function () {
      return true;
    },
    getDefaultInput: def.getDefaultInput ? def.getDefaultInput.bind(def) : function () {
      return {};
    },
    getExplicitInput: def.getExplicitInput ? def.getExplicitInput.bind(def) : function () {
      return Promise.resolve({});
    },
    createFromSavedObject: (_def$createFromSavedO = def.createFromSavedObject) !== null && _def$createFromSavedO !== void 0 ? _def$createFromSavedO : function (savedObjectId, input, parent) {
      throw new Error("Creation from saved object not supported by type ".concat(def.type));
    },
    create: def.create.bind(def),
    type: def.type,
    isEditable: def.isEditable.bind(def),
    getDisplayName: def.getDisplayName.bind(def),
    savedObjectMetaData: def.savedObjectMetaData
  };
  return factory;
};