/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import dateMath from '@elastic/datemath';
import { i18n } from '@kbn/i18n';

/**
 * Validates a given time filter range, provided by URL or UI
 * Unless valid, it returns false and displays a notification
 */
export function validateTimeRange(_ref, toastNotifications) {
  var from = _ref.from,
      to = _ref.to;
  var fromMoment = dateMath.parse(from);
  var toMoment = dateMath.parse(to);

  if (!fromMoment || !toMoment || !fromMoment.isValid() || !toMoment.isValid()) {
    toastNotifications.addDanger({
      title: i18n.translate('discover.notifications.invalidTimeRangeTitle', {
        defaultMessage: "Invalid time range"
      }),
      text: i18n.translate('discover.notifications.invalidTimeRangeText', {
        defaultMessage: "The provided time range is invalid. (from: '{from}', to: '{to}')",
        values: {
          from: from,
          to: to
        }
      })
    });
    return false;
  }

  return true;
}