function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './search_embeddable.scss';
import angular from 'angular';
import _ from 'lodash';
import * as Rx from 'rxjs';
import { i18n } from '@kbn/i18n';
import { APPLY_FILTER_TRIGGER } from '../../../../ui_actions/public';
import { RequestAdapter } from '../../../../inspector/public';
import { esFilters, getTime } from '../../../../data/public';
import { Embeddable } from '../../../../embeddable/public';
import * as columnActions from '../angular/doc_table/actions/columns';
import searchTemplate from './search_template.html';
import { getSortForSearchSource } from '../angular/doc_table';
import { getRequestInspectorStats, getResponseInspectorStats, getServices } from '../../kibana_services';
import { SEARCH_EMBEDDABLE_TYPE } from './constants';
import { SAMPLE_SIZE_SETTING, SORT_DEFAULT_ORDER_SETTING } from '../../../common';
export var SearchEmbeddable = /*#__PURE__*/function (_Embeddable) {
  _inherits(SearchEmbeddable, _Embeddable);

  var _super = _createSuper(SearchEmbeddable);

  function SearchEmbeddable(_ref, initialInput, executeTriggerActions, parent) {
    var _this;

    var $rootScope = _ref.$rootScope,
        $compile = _ref.$compile,
        savedSearch = _ref.savedSearch,
        editUrl = _ref.editUrl,
        editPath = _ref.editPath,
        indexPatterns = _ref.indexPatterns,
        editable = _ref.editable,
        filterManager = _ref.filterManager;

    _classCallCheck(this, SearchEmbeddable);

    _this = _super.call(this, initialInput, {
      defaultTitle: savedSearch.title,
      editUrl: editUrl,
      editPath: editPath,
      editApp: 'discover',
      indexPatterns: indexPatterns,
      editable: editable
    }, parent);
    _this.executeTriggerActions = executeTriggerActions;

    _defineProperty(_assertThisInitialized(_this), "savedSearch", void 0);

    _defineProperty(_assertThisInitialized(_this), "$rootScope", void 0);

    _defineProperty(_assertThisInitialized(_this), "$compile", void 0);

    _defineProperty(_assertThisInitialized(_this), "inspectorAdaptors", void 0);

    _defineProperty(_assertThisInitialized(_this), "searchScope", void 0);

    _defineProperty(_assertThisInitialized(_this), "panelTitle", '');

    _defineProperty(_assertThisInitialized(_this), "filtersSearchSource", void 0);

    _defineProperty(_assertThisInitialized(_this), "searchInstance", void 0);

    _defineProperty(_assertThisInitialized(_this), "autoRefreshFetchSubscription", void 0);

    _defineProperty(_assertThisInitialized(_this), "subscription", void 0);

    _defineProperty(_assertThisInitialized(_this), "type", SEARCH_EMBEDDABLE_TYPE);

    _defineProperty(_assertThisInitialized(_this), "filterManager", void 0);

    _defineProperty(_assertThisInitialized(_this), "abortController", void 0);

    _defineProperty(_assertThisInitialized(_this), "prevTimeRange", void 0);

    _defineProperty(_assertThisInitialized(_this), "prevFilters", void 0);

    _defineProperty(_assertThisInitialized(_this), "prevQuery", void 0);

    _defineProperty(_assertThisInitialized(_this), "fetch", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var searchSource, title, description, inspectorRequest, resp;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (_this.searchScope) {
                _context.next = 2;
                break;
              }

              return _context.abrupt("return");

            case 2:
              searchSource = _this.savedSearch.searchSource; // Abort any in-progress requests

              if (_this.abortController) _this.abortController.abort();
              _this.abortController = new AbortController();
              searchSource.setField('size', getServices().uiSettings.get(SAMPLE_SIZE_SETTING));
              searchSource.setField('sort', getSortForSearchSource(_this.searchScope.sort, _this.searchScope.indexPattern, getServices().uiSettings.get(SORT_DEFAULT_ORDER_SETTING))); // Log request to inspector

              _this.inspectorAdaptors.requests.reset();

              title = i18n.translate('discover.embeddable.inspectorRequestDataTitle', {
                defaultMessage: 'Data'
              });
              description = i18n.translate('discover.embeddable.inspectorRequestDescription', {
                defaultMessage: 'This request queries Elasticsearch to fetch the data for the search.'
              });
              inspectorRequest = _this.inspectorAdaptors.requests.start(title, {
                description: description
              });
              inspectorRequest.stats(getRequestInspectorStats(searchSource));
              searchSource.getSearchRequestBody().then(function (body) {
                inspectorRequest.json(body);
              });

              _this.updateOutput({
                loading: true,
                error: undefined
              });

              _context.prev = 14;
              _context.next = 17;
              return searchSource.fetch({
                abortSignal: _this.abortController.signal
              });

            case 17:
              resp = _context.sent;

              _this.updateOutput({
                loading: false,
                error: undefined
              }); // Log response to inspector


              inspectorRequest.stats(getResponseInspectorStats(searchSource, resp)).ok({
                json: resp
              }); // Apply the changes to the angular scope

              _this.searchScope.$apply(function () {
                _this.searchScope.hits = resp.hits.hits;
                _this.searchScope.totalHitCount = resp.hits.total;
              });

              _context.next = 26;
              break;

            case 23:
              _context.prev = 23;
              _context.t0 = _context["catch"](14);

              _this.updateOutput({
                loading: false,
                error: _context.t0
              });

            case 26:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, null, [[14, 23]]);
    })));

    _this.filterManager = filterManager;
    _this.savedSearch = savedSearch;
    _this.$rootScope = $rootScope;
    _this.$compile = $compile;
    _this.inspectorAdaptors = {
      requests: new RequestAdapter()
    };

    _this.initializeSearchScope();

    _this.autoRefreshFetchSubscription = getServices().timefilter.getAutoRefreshFetch$().subscribe(_this.fetch);
    _this.subscription = Rx.merge(_this.getOutput$(), _this.getInput$()).subscribe(function () {
      _this.panelTitle = _this.output.title || '';

      if (_this.searchScope) {
        _this.pushContainerStateParamsToScope(_this.searchScope);
      }
    });
    return _this;
  }

  _createClass(SearchEmbeddable, [{
    key: "getInspectorAdapters",
    value: function getInspectorAdapters() {
      return this.inspectorAdaptors;
    }
  }, {
    key: "getSavedSearch",
    value: function getSavedSearch() {
      return this.savedSearch;
    }
    /**
     *
     * @param {Element} domNode
     */

  }, {
    key: "render",
    value: function render(domNode) {
      if (!this.searchScope) {
        throw new Error('Search scope not defined');
      }

      this.searchInstance = this.$compile(searchTemplate)(this.searchScope);
      var rootNode = angular.element(domNode);
      rootNode.append(this.searchInstance);
      this.pushContainerStateParamsToScope(this.searchScope);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      _get(_getPrototypeOf(SearchEmbeddable.prototype), "destroy", this).call(this);

      this.savedSearch.destroy();

      if (this.searchInstance) {
        this.searchInstance.remove();
      }

      if (this.searchScope) {
        this.searchScope.$destroy();
        delete this.searchScope;
      }

      if (this.subscription) {
        this.subscription.unsubscribe();
      }

      if (this.autoRefreshFetchSubscription) {
        this.autoRefreshFetchSubscription.unsubscribe();
      }

      if (this.abortController) this.abortController.abort();
    }
  }, {
    key: "initializeSearchScope",
    value: function initializeSearchScope() {
      var _this2 = this;

      var searchScope = this.searchScope = this.$rootScope.$new();
      searchScope.description = this.savedSearch.description;
      searchScope.inspectorAdapters = this.inspectorAdaptors;
      var searchSource = this.savedSearch.searchSource;
      var indexPattern = searchScope.indexPattern = searchSource.getField('index');
      var timeRangeSearchSource = searchSource.create();
      timeRangeSearchSource.setField('filter', function () {
        if (!_this2.searchScope || !_this2.input.timeRange) return;
        return getTime(indexPattern, _this2.input.timeRange);
      });
      this.filtersSearchSource = searchSource.create();
      this.filtersSearchSource.setParent(timeRangeSearchSource);
      searchSource.setParent(this.filtersSearchSource);
      this.pushContainerStateParamsToScope(searchScope);

      searchScope.setSortOrder = function (sort) {
        _this2.updateInput({
          sort: sort
        });
      };

      searchScope.addColumn = function (columnName) {
        if (!searchScope.columns) {
          return;
        }

        indexPattern.popularizeField(columnName, 1);
        var columns = columnActions.addColumn(searchScope.columns, columnName);

        _this2.updateInput({
          columns: columns
        });
      };

      searchScope.removeColumn = function (columnName) {
        if (!searchScope.columns) {
          return;
        }

        var columns = columnActions.removeColumn(searchScope.columns, columnName);

        _this2.updateInput({
          columns: columns
        });
      };

      searchScope.moveColumn = function (columnName, newIndex) {
        if (!searchScope.columns) {
          return;
        }

        var columns = columnActions.moveColumn(searchScope.columns, columnName, newIndex);

        _this2.updateInput({
          columns: columns
        });
      };

      searchScope.filter = /*#__PURE__*/function () {
        var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(field, value, operator) {
          var filters;
          return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  filters = esFilters.generateFilters(_this2.filterManager, field, value, operator, indexPattern.id);
                  filters = filters.map(function (filter) {
                    return _objectSpread(_objectSpread({}, filter), {}, {
                      $state: {
                        store: esFilters.FilterStateStore.APP_STATE
                      }
                    });
                  });
                  _context2.next = 4;
                  return _this2.executeTriggerActions(APPLY_FILTER_TRIGGER, {
                    embeddable: _this2,
                    filters: filters
                  });

                case 4:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }));

        return function (_x, _x2, _x3) {
          return _ref3.apply(this, arguments);
        };
      }();
    }
  }, {
    key: "reload",
    value: function reload() {
      this.fetch();
    }
  }, {
    key: "pushContainerStateParamsToScope",
    value: function pushContainerStateParamsToScope(searchScope) {
      var isFetchRequired = !esFilters.onlyDisabledFiltersChanged(this.input.filters, this.prevFilters) || !_.isEqual(this.prevQuery, this.input.query) || !_.isEqual(this.prevTimeRange, this.input.timeRange) || !_.isEqual(searchScope.sort, this.input.sort || this.savedSearch.sort); // If there is column or sort data on the panel, that means the original columns or sort settings have
      // been overridden in a dashboard.

      searchScope.columns = this.input.columns || this.savedSearch.columns;
      searchScope.sort = this.input.sort || this.savedSearch.sort;
      searchScope.sharedItemTitle = this.panelTitle;

      if (isFetchRequired) {
        this.filtersSearchSource.setField('filter', this.input.filters);
        this.filtersSearchSource.setField('query', this.input.query);
        this.fetch();
        this.prevFilters = this.input.filters;
        this.prevQuery = this.input.query;
        this.prevTimeRange = this.input.timeRange;
      } else if (this.searchScope) {
        // trigger a digest cycle to make sure non-fetch relevant changes are propagated
        this.searchScope.$applyAsync();
      }
    }
  }]);

  return SearchEmbeddable;
}(Embeddable);