function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect, useState } from 'react';
export var ElasticRequestState;
/**
 * helper function to build a query body for Elasticsearch
 * https://www.elastic.co/guide/en/elasticsearch/reference/current//query-dsl-ids-query.html
 */

(function (ElasticRequestState) {
  ElasticRequestState[ElasticRequestState["Loading"] = 0] = "Loading";
  ElasticRequestState[ElasticRequestState["NotFound"] = 1] = "NotFound";
  ElasticRequestState[ElasticRequestState["Found"] = 2] = "Found";
  ElasticRequestState[ElasticRequestState["Error"] = 3] = "Error";
  ElasticRequestState[ElasticRequestState["NotFoundIndexPattern"] = 4] = "NotFoundIndexPattern";
})(ElasticRequestState || (ElasticRequestState = {}));

export function buildSearchBody(id, indexPattern) {
  var computedFields = indexPattern.getComputedFields();
  return {
    query: {
      ids: {
        values: [id]
      }
    },
    stored_fields: computedFields.storedFields,
    _source: true,
    script_fields: computedFields.scriptFields,
    docvalue_fields: computedFields.docvalueFields
  };
}
/**
 * Custom react hook for querying a single doc in ElasticSearch
 */

export function useEsDocSearch(_ref) {
  var esClient = _ref.esClient,
      id = _ref.id,
      index = _ref.index,
      indexPatternId = _ref.indexPatternId,
      indexPatternService = _ref.indexPatternService;

  var _useState = useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      indexPattern = _useState2[0],
      setIndexPattern = _useState2[1];

  var _useState3 = useState(ElasticRequestState.Loading),
      _useState4 = _slicedToArray(_useState3, 2),
      status = _useState4[0],
      setStatus = _useState4[1];

  var _useState5 = useState(null),
      _useState6 = _slicedToArray(_useState5, 2),
      hit = _useState6[0],
      setHit = _useState6[1];

  useEffect(function () {
    function requestData() {
      return _requestData.apply(this, arguments);
    }

    function _requestData() {
      _requestData = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var indexPatternEntity, _yield$esClient$searc, hits;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return indexPatternService.get(indexPatternId);

              case 3:
                indexPatternEntity = _context.sent;
                setIndexPattern(indexPatternEntity);
                _context.next = 7;
                return esClient.search({
                  index: index,
                  body: buildSearchBody(id, indexPatternEntity)
                });

              case 7:
                _yield$esClient$searc = _context.sent;
                hits = _yield$esClient$searc.hits;

                if (hits && hits.hits && hits.hits[0]) {
                  setStatus(ElasticRequestState.Found);
                  setHit(hits.hits[0]);
                } else {
                  setStatus(ElasticRequestState.NotFound);
                }

                _context.next = 15;
                break;

              case 12:
                _context.prev = 12;
                _context.t0 = _context["catch"](0);

                if (_context.t0.savedObjectId) {
                  setStatus(ElasticRequestState.NotFoundIndexPattern);
                } else if (_context.t0.status === 404) {
                  setStatus(ElasticRequestState.NotFound);
                } else {
                  setStatus(ElasticRequestState.Error);
                }

              case 15:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 12]]);
      }));
      return _requestData.apply(this, arguments);
    }

    requestData();
  }, [esClient, id, index, indexPatternId, indexPatternService]);
  return [status, hit, indexPattern];
}