/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { isString, isObject } from 'lodash';
export var isType = function isType() {
  for (var _len = arguments.length, types = new Array(_len), _key = 0; _key < _len; _key++) {
    types[_key] = arguments[_key];
  }

  return function (agg) {
    var field = agg.params.field;
    return types.some(function (type) {
      return field && field.type === type;
    });
  };
};
export var isNumberType = isType('number');
export var isStringType = isType('string');
export var isStringOrNumberType = isType('string', 'number');
export var migrateIncludeExcludeFormat = {
  serialize: function serialize(value, agg) {
    if (this.shouldShow && !this.shouldShow(agg)) return;
    if (!value || isString(value) || Array.isArray(value)) return value;else return value.pattern;
  },
  write: function write(aggConfig, output) {
    var value = aggConfig.getParam(this.name);

    if (Array.isArray(value) && value.length > 0 && isNumberType(aggConfig)) {
      var parsedValue = value.filter(function (val) {
        return Number.isFinite(val);
      });

      if (parsedValue.length) {
        output.params[this.name] = parsedValue;
      }
    } else if (isObject(value)) {
      output.params[this.name] = value.pattern;
    } else if (value && isStringType(aggConfig)) {
      output.params[this.name] = value;
    }
  }
};