function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { I18nProvider } from '@kbn/i18n/react';
import uuid from 'uuid';
import { Container } from '../../embeddable_plugin';
import { DASHBOARD_CONTAINER_TYPE } from './dashboard_constants';
import { createPanelState } from './panel';
import { DashboardViewport } from './viewport/dashboard_viewport';
import { KibanaContextProvider } from '../../../../kibana_react/public';
import { PLACEHOLDER_EMBEDDABLE } from './placeholder';
export var DashboardContainer = /*#__PURE__*/function (_Container) {
  _inherits(DashboardContainer, _Container);

  var _super = _createSuper(DashboardContainer);

  function DashboardContainer(initialInput, options, stateTransfer, parent) {
    var _this;

    _classCallCheck(this, DashboardContainer);

    _this = _super.call(this, _objectSpread({}, initialInput), {
      embeddableLoaded: {}
    }, options.embeddable.getEmbeddableFactory, parent);
    _this.options = options;

    _defineProperty(_assertThisInitialized(_this), "type", DASHBOARD_CONTAINER_TYPE);

    _defineProperty(_assertThisInitialized(_this), "renderEmpty", void 0);

    _defineProperty(_assertThisInitialized(_this), "embeddablePanel", void 0);

    _this.embeddablePanel = options.embeddable.getEmbeddablePanel(stateTransfer);
    return _this;
  }

  _createClass(DashboardContainer, [{
    key: "createNewPanelState",
    value: function createNewPanelState(factory) {
      var partial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var panelState = _get(_getPrototypeOf(DashboardContainer.prototype), "createNewPanelState", this).call(this, factory, partial);

      return createPanelState(panelState, this.input.panels);
    }
  }, {
    key: "showPlaceholderUntil",
    value: function showPlaceholderUntil(newStateComplete, placementMethod, placementArgs) {
      var _this2 = this;

      var originalPanelState = {
        type: PLACEHOLDER_EMBEDDABLE,
        explicitInput: {
          id: uuid.v4(),
          disabledActions: ['ACTION_CUSTOMIZE_PANEL', 'CUSTOM_TIME_RANGE', 'clonePanel', 'replacePanel', 'togglePanel']
        }
      };
      var placeholderPanelState = createPanelState(originalPanelState, this.input.panels, placementMethod, placementArgs);
      this.updateInput({
        panels: _objectSpread(_objectSpread({}, this.input.panels), {}, _defineProperty({}, placeholderPanelState.explicitInput.id, placeholderPanelState))
      });
      newStateComplete.then(function (newPanelState) {
        return _this2.replacePanel(placeholderPanelState, newPanelState);
      });
    }
  }, {
    key: "replacePanel",
    value: function replacePanel(previousPanelState, newPanelState) {
      var _newPanelState$explic;

      // TODO: In the current infrastructure, embeddables in a container do not react properly to
      // changes. Removing the existing embeddable, and adding a new one is a temporary workaround
      // until the container logic is fixed.
      var finalPanels = _objectSpread({}, this.input.panels);

      delete finalPanels[previousPanelState.explicitInput.id];
      var newPanelId = ((_newPanelState$explic = newPanelState.explicitInput) === null || _newPanelState$explic === void 0 ? void 0 : _newPanelState$explic.id) ? newPanelState.explicitInput.id : uuid.v4();
      finalPanels[newPanelId] = _objectSpread(_objectSpread(_objectSpread({}, previousPanelState), newPanelState), {}, {
        gridData: _objectSpread(_objectSpread({}, previousPanelState.gridData), {}, {
          i: newPanelId
        }),
        explicitInput: _objectSpread(_objectSpread({}, newPanelState.explicitInput), {}, {
          id: newPanelId
        })
      });
      this.updateInput({
        panels: finalPanels,
        lastReloadRequestTime: new Date().getTime()
      });
    }
  }, {
    key: "addOrUpdateEmbeddable",
    value: function () {
      var _addOrUpdateEmbeddable = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(type, explicitInput) {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (explicitInput.id && this.input.panels[explicitInput.id]) {
                  this.replacePanel(this.input.panels[explicitInput.id], {
                    type: type,
                    explicitInput: _objectSpread(_objectSpread({}, explicitInput), {}, {
                      id: uuid.v4()
                    })
                  });
                } else {
                  this.addNewEmbeddable(type, explicitInput);
                }

              case 1:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function addOrUpdateEmbeddable(_x, _x2) {
        return _addOrUpdateEmbeddable.apply(this, arguments);
      }

      return addOrUpdateEmbeddable;
    }()
  }, {
    key: "render",
    value: function render(dom) {
      ReactDOM.render( /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(KibanaContextProvider, {
        services: this.options
      }, /*#__PURE__*/React.createElement(DashboardViewport, {
        renderEmpty: this.renderEmpty,
        container: this,
        PanelComponent: this.embeddablePanel
      }))), dom);
    }
  }, {
    key: "getInheritedInput",
    value: function getInheritedInput(id) {
      var _this$input = this.input,
          viewMode = _this$input.viewMode,
          refreshConfig = _this$input.refreshConfig,
          timeRange = _this$input.timeRange,
          query = _this$input.query,
          hidePanelTitles = _this$input.hidePanelTitles,
          filters = _this$input.filters;
      return {
        filters: filters,
        hidePanelTitles: hidePanelTitles,
        query: query,
        timeRange: timeRange,
        refreshConfig: refreshConfig,
        viewMode: viewMode,
        id: id
      };
    }
  }]);

  return DashboardContainer;
}(Container);