/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { FormattedMessage } from '@kbn/i18n/react'; // @ts-ignore

import { EuiFlyout, EuiFlyoutHeader, EuiFlyoutBody, EuiTitle, EuiButton, EuiText, EuiFlyoutFooter } from '@elastic/eui';
import { EditorExample } from './editor_example';
export function WelcomePanel(props) {
  return /*#__PURE__*/React.createElement(EuiFlyout, {
    onClose: props.onDismiss,
    "data-test-subj": "welcomePanel",
    size: "s"
  }, /*#__PURE__*/React.createElement(EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "m"
  }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.pageTitle",
    defaultMessage: "Welcome to Console"
  })))), /*#__PURE__*/React.createElement(EuiFlyoutBody, null, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("h4", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.quickIntroTitle",
    defaultMessage: "Quick intro to the UI"
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.quickIntroDescription",
    defaultMessage: "The Console UI is split into two panes: an editor pane (left) and a response pane (right). Use the editor to type requests and submit them to Elasticsearch. The results will be displayed in the response pane on the right side."
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.supportedRequestFormatTitle",
    defaultMessage: "Console understands requests in a compact format, similar to cURL:"
  })), /*#__PURE__*/React.createElement(EditorExample, {
    panel: "welcome"
  }), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.supportedRequestFormatDescription",
    defaultMessage: "While typing a request, Console will make suggestions which you can then accept by hitting Enter/Tab. These suggestions are made based on the request structure as well as your indices and types."
  })), /*#__PURE__*/React.createElement("h4", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.quickTipsTitle",
    defaultMessage: "A few quick tips, while I have your attention"
  })), /*#__PURE__*/React.createElement("ul", null, /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.quickTips.submitRequestDescription",
    defaultMessage: "Submit requests to ES using the green triangle button."
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.quickTips.useWrenchMenuDescription",
    defaultMessage: "Use the wrench menu for other useful things."
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.quickTips.cUrlFormatForRequestsDescription",
    defaultMessage: "You can paste requests in cURL format and they will be translated to the Console syntax."
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.quickTips.resizeEditorDescription",
    defaultMessage: "You can resize the editor and output panes by dragging the separator between them."
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.quickTips.keyboardShortcutsDescription",
    defaultMessage: "Study the keyboard shortcuts under the Help button. Good stuff in there!"
  }))))), /*#__PURE__*/React.createElement(EuiFlyoutFooter, null, /*#__PURE__*/React.createElement(EuiButton, {
    fill: true,
    fullWidth: false,
    "data-test-subj": "help-close-button",
    onClick: props.onDismiss
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.welcomePage.closeButtonLabel",
    defaultMessage: "Dismiss"
  }))));
}