"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObjectToConfigAdapter = void 0;

var _saferLodashSet = require("@elastic/safer-lodash-set");

var _lodash = require("lodash");

var _utils = require("../../utils");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Allows plain javascript object to behave like `RawConfig` instance.
 * @internal
 */
class ObjectToConfigAdapter {
  constructor(rawConfig) {
    this.rawConfig = rawConfig;
  }

  has(configPath) {
    return (0, _lodash.has)(this.rawConfig, configPath);
  }

  get(configPath) {
    return (0, _lodash.get)(this.rawConfig, configPath);
  }

  set(configPath, value) {
    (0, _saferLodashSet.set)(this.rawConfig, configPath, value);
  }

  getFlattenedPaths() {
    return Object.keys((0, _utils.getFlattenedObject)(this.rawConfig));
  }

  toRaw() {
    return (0, _lodash.cloneDeep)(this.rawConfig);
  }

}

exports.ObjectToConfigAdapter = ObjectToConfigAdapter;