function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { AppNavLinkStatus } from '../application';
import { renderApp, setupUrlOverflowDetection } from './errors';
export var CoreApp = /*#__PURE__*/function () {
  function CoreApp(coreContext) {
    _classCallCheck(this, CoreApp);

    this.coreContext = coreContext;

    _defineProperty(this, "stopHistoryListening", void 0);
  }

  _createClass(CoreApp, [{
    key: "setup",
    value: function setup(_ref) {
      var http = _ref.http,
          application = _ref.application;
      application.register(this.coreContext.coreId, {
        id: 'error',
        title: 'App Error',
        navLinkStatus: AppNavLinkStatus.hidden,
        mount: function mount(params) {
          // Do not use an async import here in order to ensure that network failures
          // cannot prevent the error UI from displaying. This UI is tiny so an async
          // import here is probably not useful anyways.
          return renderApp(params, {
            basePath: http.basePath
          });
        }
      });
    }
  }, {
    key: "start",
    value: function start(_ref2) {
      var application = _ref2.application,
          http = _ref2.http,
          notifications = _ref2.notifications,
          uiSettings = _ref2.uiSettings;

      if (!application.history) {
        return;
      }

      this.stopHistoryListening = setupUrlOverflowDetection({
        basePath: http.basePath,
        history: application.history,
        toasts: notifications.toasts,
        uiSettings: uiSettings
      });
    }
  }, {
    key: "stop",
    value: function stop() {
      if (this.stopHistoryListening) {
        this.stopHistoryListening();
        this.stopHistoryListening = undefined;
      }
    }
  }]);

  return CoreApp;
}();